/* ʣ̲ - EnbanKensa
 * Copyright (c) 2004-2005 Kagetani Hideto
 * aspi.c
 * $Date: 2005/05/17 15:42:28 $
 * $Revision: 1.1 $
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <string.h>
#include <errno.h>

#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/file.h>
#include <linux/cdrom.h>

#include "aspi.h"
#include "cmd.h"

/*#define DEBUG*/

int OpenAspi()
{
  return RET_OK;
}


void CloseAspi()
{
}

int InitializeDrive(DRIVE *drive)
{
  drive->hid = -1;
  drive->tid = -1;
  drive->fd = -1;

  return RET_OK;
}

void FreeDrive(DRIVE *drive)
{
  if(drive->fd > 0){
    close(drive->fd);
    drive->fd = -1;
  }
}

int SetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout)
{
  BOOL target_changed=FALSE;
  char devname[12];

  if(ha!=NULL)
    if(*ha>=3)
      return RET_NG;
  if(tg!=NULL)
    if(*tg>=26)
      return RET_NG;

  if(ha!=NULL){
    drive->hid = *ha;
    target_changed=TRUE;
  }
  if(tg!=NULL){
    drive->tid = *tg;
    target_changed=TRUE;
  }
  if(timeout!=NULL){
    drive->timeout = *timeout;
  }

  if(target_changed){
    if(drive->fd>=0){
      close(drive->fd);
    }
    if(drive->hid==0)
      sprintf(devname, "/dev/hd%c", drive->tid+'a');
    else
      sprintf(devname, "/dev/scd%c", drive->tid+'0');
    drive->fd = open(devname, O_RDONLY|O_NONBLOCK);
    if(drive->fd<0){
      return RET_NG;
    }
  }

  return RET_OK;
}

void GetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout)
{
  if(ha!=NULL){
    *ha = drive->hid;
  }
  if(tg!=NULL){
    *tg = drive->tid;
  }
  if(timeout!=NULL){
    *timeout = drive->timeout;
  }
}


#ifdef DEBUG
void dump_cgc(struct cdrom_generic_command *cgc)
{
  struct request_sense *sense = cgc->sense;
  int i;

  printf("data direction: %d\n", cgc->data_direction);
  printf("cdb: ");
  for (i = 0; i < 12; i++)
    printf("%02x ", cgc->cmd[i]);
  printf("\n");
  
  printf("buffer (%d): ", cgc->buflen);
  for (i = 0; i < cgc->buflen; i++)
    printf("%02x ", cgc->buffer[i]);
  printf("\n");
  
  if (!sense)
    return;
  
  printf("sense: %02x.%02x.%02x\n", sense->sense_key, sense->asc, sense->ascq);
}
#endif

int SendAspiCmd(DRIVE *drive, BYTE *cdb, BYTE *buf, DWORD buflen,
		BYTE *sensedata, DWORD senselen, BYTE reqflag)
{
  int ret;
  struct cdrom_generic_command cgc;
  struct request_sense sense_data;

  if(drive->fd<0){
    printf("Device not opened.\n");
    return RET_NG;
  }

  memset(&sense_data, 0, sizeof(struct request_sense));
  memset(&cgc, 0, sizeof(struct cdrom_generic_command));
  cgc.timeout = drive->timeout*100;
  cgc.buffer = buf;
  cgc.buflen = buflen;

  switch(reqflag){
  case REQ_DATAIN:
    cgc.data_direction = CGC_DATA_READ;
    break;
  case REQ_DATAOUT:
    cgc.data_direction = CGC_DATA_WRITE;
    break;
  default:
    cgc.data_direction = CGC_DATA_NONE;
  }

  cgc.sense = &sense_data;
  cgc.quiet = 1;
  memcpy(cgc.cmd, cdb, 12);

  ret = ioctl(drive->fd, CDROM_SEND_PACKET, &cgc);
  memcpy(sensedata, &sense_data,
	 senselen < sizeof(struct request_sense) ?
	 senselen : sizeof(struct request_sense));
#if 0
  if((drive->sense_data[2] & 0x0f) != 0x00 ||
     drive->sense_data[12] != 0x00 ||
     drive->sense_data[13] != 0x00)
    ret = RET_CMDERR;
#else
  if(ret!=0)
    ret = RET_CMDERR;
#endif

#ifdef DEBUG
  dump_cgc(&cgc);
#endif
  return ret;
}

int GetHostAdapterCount()
{
  return 2;
}

int GetMaxTarget()
{
  return 26;
}
