/* ~Օʉ - EnbanKensa
 * Copyright (C) 2005 Kagetani Hideto
 */
#include "stdafx.h"
#include "ui.h"
#include "ThemeMessageDlg.h"
#include "EnbanKensaDlg.h"
#include "EnbanKensa.h"

static BOOL g_bAbort=FALSE;
static HWND g_hWnd=NULL;

static void UIFlushMessage()
{
	MSG msg;
	while( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) != 0 ){
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
}

void UISetHWND(HWND hWnd)
{
	g_hWnd = hWnd;
}

BOOL UICheckAbort()
{
	UIFlushMessage();
	return g_bAbort;
}

void UISetAbort()
{
	g_bAbort=TRUE;
}

void UIClearAbort()
{
	g_bAbort=FALSE;
}


int UIDispMessage(const char *message, int type)
{
	CThemeSet *pThemeClass = ((CEnbanKensaApp *)AfxGetApp())->GetThemeClass();
	CThemeMessageDlg *pDlg;
	UINT nFlags=0;
	int ret;

	switch(type){
	case UIDMT_ERROR:
		nFlags = MB_ICONSTOP|MB_OK;
		break;
	case UIDMT_QUESTION:
		nFlags = MB_ICONQUESTION|MB_YESNO;
		break;
	default:
		nFlags = MB_OK;
	}
	pDlg = new CThemeMessageDlg;
	pDlg->SetTheme(pThemeClass);
	ret = pDlg->Disp(message, NULL, nFlags);

	delete pDlg;

	return (ret==IDOK||ret==IDYES) ? UIDMRET_OK : UIDMRET_CANCEL;
}

void UIDispInfo(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_DISPINFO, (LPARAM)message);
}

void UIDrawLine(int x0, int y0, int x1, int y1, const UICOLOR *color)
{
	DRAWLINE_t dl;

	dl.x0 = x0;
	dl.y0 = y0;
	dl.x1 = x1;
	dl.y1 = y1;
	dl.color = RGB((color->red>>8), (color->green>>8), (color->blue>>8));
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_DRAWLINE, (LPARAM)&dl);
}

void UIDrawBox(int x0, int y0, int x1, int y1, const UICOLOR *color, BOOL fill)
{
	DRAWBOX_t db;

	db.x0 = x0;
	db.y0 = y0;
	db.x1 = x1;
	db.y1 = y1;
	db.color = RGB((color->red>>8), (color->green>>8), (color->blue>>8));
	db.fill = fill;
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_DRAWBOX, (LPARAM)&db);
}

void UIDrawText(int x0, int y0, const UICOLOR *color, const char *text)
{
	DRAWTEXT_t dt;

	dt.x0 = x0;
	dt.y0 = y0;
	dt.color = RGB((color->red>>8), (color->green>>8), (color->blue>>8));
	dt.text = text;
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_DRAWTEXT, (LPARAM)&dt);
}

void UIGetDrawableSize(int *width, int *height)
{
	DRAWABLESIZE_t ds;

	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_GETDRAWABLESIZE, (LPARAM)&ds);
	*width = ds.width;
	*height = ds.height;
}

int UISetting(OPTIONS *option)
{
	return ::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_SETTING, (LPARAM)option);
}
