/* ~Օʉ - EnbanKensa
 * Copyright (C) 2005 Kagetani Hideto
 */
#ifndef __UI_H__
#define __UI_H__

#include <windows.h>
#include "option.h"

#ifdef __cplusplus
extern "C" {
#endif

typedef struct {
	unsigned short red;
	unsigned short green;
	unsigned short blue;
} UICOLOR;

#define WM_USER_UICTL	(WM_USER+1)
#define UICTL_DISPINFO		1
#define UICTL_DRAWLINE		2
#define UICTL_DRAWBOX		3
#define UICTL_DRAWTEXT		4
#define UICTL_GETDRAWABLESIZE	5
#define UICTL_SETTING			6

extern void UISetHWND(HWND hWnd);
extern BOOL UICheckAbort();
extern void UISetAbort();
extern void UIClearAbort();
extern int UIDispMessage(const char *message, int type);
/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

extern void UIDispInfo(const char *message);
extern void UIDrawLine(int x0, int y0, int x1, int y1, const UICOLOR *color);
extern void UIDrawBox(int x0, int y0, int x1, int y1, const UICOLOR *color, BOOL fill);
extern void UIDrawText(int x0, int y0, const UICOLOR *color, const char *text);
extern void UIGetDrawableSize(int *width, int *height);
extern int UISetting(OPTIONS *option);

#ifdef __cplusplus
}
#endif

#endif /* !__EVENT_H__ */
