/* ~Օʉ
 * Copyright (C) 2004-2005 Kagetani Hideto
 */
#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#ifdef linux
# include <fcntl.h>
#endif
#include <time.h>
#if defined(WIN32)
# include <io.h>
#else
# include <unistd.h>
#endif
#if !defined(MACOSX)
# include <malloc.h>
#endif
#include "aspi.h"
#include "struct.h"
#include "cmd.h"
#include "ui.h"
#include "copydisc.h"
#include "cmdlog.h"
#include "netserver.h"


typedef struct {
	struct _TRACKINFO trackinfo;
	BYTE mode2;			/* MODE2Ȃ1AȊO0 */
	BYTE isrc[12+1];
	BOOL tao;			/* TAOŋL^Ă邩ǂ */
	WORD pause_len;		/* Audio Pause Length */
} CPTRACKINFO;

#define IS_TRACKMODE_DATA(m)	(((m) & 0x0c)==4)

#define IMGFILE_VERSION 0

typedef struct {
	BYTE version;		/* IMGFILE_VERSION */
	BYTE disc_type;
	BYTE disc_stat;
	BYTE last_sess_stat;
	BYTE media_catalog_number[13+1];
	DWORD last_addr;
	WORD sessions;
	WORD tracks;
	BYTE *cdtext;
	int cdtext_size;
	CPTRACKINFO *trackinfo;	/* <= KŌ */
} CPDISCINFO;



static DWORD g_SpeedData[10];
static int g_NumSpeedData=0;
static int g_MaxSpeedData=sizeof(g_SpeedData)/sizeof(DWORD);

static void InitSpeedData()
{
  g_NumSpeedData=0;
}

static void DispSpeed(DWORD lba, DWORD rest_blocks, CMDDRIVE *src, CMDDRIVE *dst)
{
  double blocks_per_sec;
  double curr_speed;
  char info[80];
  DWORD rest_time;
  int ret;
  double buffer_capacity;
  
  if(g_NumSpeedData >= g_MaxSpeedData){
	memmove(&g_SpeedData[0], &g_SpeedData[1],
			(g_MaxSpeedData-1)*sizeof(DWORD));
	g_NumSpeedData--;
  }
  g_SpeedData[g_NumSpeedData] = lba;
  g_NumSpeedData++;

  if(g_NumSpeedData <= 1){
	return;
  }
  
  blocks_per_sec = (double)(lba-g_SpeedData[0])/(g_NumSpeedData-1);
  if(GetOption()->flags & OPFLG_DVD){
	curr_speed = blocks_per_sec*2048/1024.0/1385;
  }
  else{
	curr_speed = blocks_per_sec*2352/1000.0/176.4;
  }

  sprintf(info, "%.1f{", curr_speed);
	  /* c莞ԌvZ */
  rest_time = (DWORD)(0.5+rest_blocks/blocks_per_sec);
  sprintf(info+strlen(info), " c莞=%d:%02d",
		  (int)(rest_time/60), (int)(rest_time%60));

  if(REALDRIVE(dst)){
	ret = SendReadBufferCapacity(dst, 0);
	if(ret == RET_OK){
	  buffer_capacity = 100-
		100.0*Get4bytes(dst->data_buf+8)/Get4bytes(dst->data_buf+4);
	  sprintf(info+strlen(info), " ~=%.1f%%", buffer_capacity);
	}
  }
  UIDispInfo(info);
  if(src->type == CMDDRVTYPE_NET){
	NAUIDispInfo(&src->u.net, info);
  }
}


void DebugLog(char *fmt, ...)
{
#ifdef DEBUGLOG
	va_list args;
	char str[512];
	FILE *fp;
	time_t now;

	fp = fopen("enban.log", "a");
	if(fp == NULL)
		return;

	time(&now);
	strftime(str, sizeof(str)-1, "%Y/%m/%d %H:%M:%S : ", localtime(&now));
	fputs(str, fp);

	va_start(args, fmt);
	vsprintf(str, fmt, args);

	fputs(str, fp);
	fclose(fp);
#endif
}


static int OpenDevice(CMDDRIVE *drive, DRIVEID *id,
					  BOOL reader, BOOL bWaitDisc,
					  BYTE *data_buf, int bufsize)
{
  int ret;
  DWORD timeout=5*60;

  ret = InitializeCmdDrive(drive, 0, 50, CMDDRVTYPE_DRIVE);
  if(ret!=RET_OK){
	return ret;
  }
  SetDriveBuffer(drive, data_buf, bufsize);
  ret = SetDriveAspiSetting(drive, &id->hid, &id->tid, &timeout);
  if(ret!=RET_OK){
	return ret;
  }

  ret = GetDiscType(drive, &drive->disc_type, bWaitDisc);
  if(ret!=RET_OK){
	if(ret!=RET_ABORT && bWaitDisc){
	  UIDispMessage("fBXN^Cv擾Ɏs܂B", UIDMT_ERROR);
	}
	FreeCmdDrive(drive);
	return ret;
  }
  ret = SendPreventAllow(drive, 1);
  if(ret!=RET_OK){
	DispCommandError(drive);
	FreeCmdDrive(drive);
	return ret;
  }

  return RET_OK;
}

static void CloseDevice(CMDDRIVE *drive)
{
  if(drive->type == CMDDRVTYPE_DRIVE){
	SendPreventAllow(drive, 0);
  }

  FreeCmdDrive(drive);
}

static int SetDiscInformation(CMDDRIVE *drive, CPDISCINFO *discinfo)
{
  int ret;

  if(drive->type == CMDDRVTYPE_ISO){
		/* ISOC[W̏ꍇ́A1ZbV̂ */
	if(discinfo->sessions > 1){
	  UIDispMessage("}`ZbṼC[Wt@C͏o܂B",
					UIDMT_ERROR);
	  return RET_NG;
	}
  }
  else if(drive->type == CMDDRVTYPE_IMAGE){
		/* ~ՕʉIWiC[W */
		/* C[Wt@CɃfBXN */
	discinfo->version = IMGFILE_VERSION;
	ret = WriteImageFile(&drive->u.image, discinfo,
						 sizeof(CPDISCINFO)-sizeof(CPTRACKINFO *),
						 TRUE);
	if(ret!=RET_OK)
	  return ret;
	  
	if(discinfo->cdtext_size>0){
	  ret = WriteImageFile(&drive->u.image,
						   discinfo->cdtext, discinfo->cdtext_size,
						   TRUE);
	  if(ret!=RET_OK)
		return ret;
	}
	ret = WriteImageFile(&drive->u.image, discinfo->trackinfo,
						 sizeof(CPTRACKINFO)*discinfo->tracks,
						 TRUE);
	if(ret!=RET_OK)
	  return ret;
  }

  return RET_OK;
}

static int WhetherTAO(CMDDRIVE *drive, WORD sess_num, BOOL *result,
					  DWORD *lout_start)
{
  int ret;
  int i;
  struct _FULLTOCDESC *ftd;
  DWORD lba=0UL;

  if(!REALDRIVE(drive))
	return RET_OK;

  *lout_start = 0UL;
  *result = TRUE;
  if(!DT_CD_FAMILY(drive->disc_type))
	return RET_OK;

	  /* TOC񂩂YZbṼ[hAEgJnAhX߂ */
  ret = SendReadToc(drive, sess_num, 1, RTF_FULLTOC);
  if(ret!=RET_OK){
		/* I[vZbV݂̂̏ꍇ̓G[ɂȂ...̂? */
	return RET_OK;
  }

  for(i=sizeof(struct _TOCHEADER); i<drive->bufsize; i+=sizeof(struct _FULLTOCDESC)){
	ftd = (struct _FULLTOCDESC *)(drive->data_buf+i);
	if(ftd->point == 0xa2){
	  lba = MSF2LBA(ftd->pmin, ftd->psec, ftd->pframe, FALSE);
	  break;
	}
  }

  if(lba==0UL){
		/* 炭I[vZbVȂ̂ŁATAO */
	return RET_OK;
  }

  *lout_start = lba;

	  /* [hAEgJnAhX̒O2ubNǂł݂ */
  ret = SendReadCD(drive, lba-2, 2);
  if(ret==RET_OK){
		/* ǂ߂A炭 Run-out L^ĂȂ̂ SAO */
	*result = FALSE;
  }

  return RET_OK;
}

static int GetGapLen(CMDDRIVE *drive, CPTRACKINFO *cpti)
{
  int ret;
  DWORD search_start, search_end, lba, track_start;
  DWORD real_start;
  BYTE track_num = cpti->trackinfo.track_number_lsb;

  track_start = Get4bytes(cpti->trackinfo.track_start);
  search_end = track_start;
  search_start = search_end - 151;	/* GAP=150ʓIȂ̂ŁA̎O猟 */
  real_start = search_start;

  while(TRUE){
		/*
		 * QTV[PVŃANZXԂ񑬂
		 */
	for(lba=search_start; lba<search_end; lba++){
	  ret = GetSubQ(drive, lba, 1);
	  if(ret!=RET_OK){
		search_start++;
		continue;
	  }
	  if((drive->data_buf[0] & 0x0f)!=0x01){
			/* ԂISRCMediaCatalogNumberL^Ă */
		search_start++;
		continue;
	  }
	  if(track_num==drive->data_buf[1]){
		break;
	  }
	}
	if(lba==real_start){
		  /* 擪ɃMbvȂAƑO猟 */
	  search_end = search_start;
	  search_start -= 150;
	  real_start = search_start;
	  continue;
	}
	break;
  }
  if(lba >= track_start)
	cpti->pause_len = 0;
  else if(track_start-lba > 0xffff)
	cpti->pause_len = 0xffff;
  else
	cpti->pause_len = (WORD)(track_start - lba);

  if(cpti->pause_len>0){
		/* Ô߁AMbv̍ŌmF */
	ret = GetSubQ(drive, Get4bytes(cpti->trackinfo.track_start)-1, 1);
	if(ret==RET_OK){
	  if((drive->data_buf[0] & 0x0f)==0x01 &&
		 drive->data_buf[1]==track_num &&
		 drive->data_buf[2]>0){
		cpti->pause_len--;
	  }
	}
  }

  return RET_OK;
}


static int GetTrackInformation(CMDDRIVE *drive, WORD track_num, CPTRACKINFO *cpti)
{
  int ret;

  ret = SendReadTrackInfo(drive, track_num);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }
  memcpy(&cpti->trackinfo, drive->data_buf, sizeof(struct _TRACKINFO));
  cpti->mode2 = 0;
  cpti->pause_len = 0;
  if(cpti->trackinfo.blank)
	return RET_OK;
  if(DT_CD_FAMILY(drive->disc_type)){
	memset(cpti->isrc, 0, 12+1);
	if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
		  /* MODE2ǂ𒲂ׂ */
	  ret = SendReadCD(drive, Get4bytes(cpti->trackinfo.track_start), 1);
	  if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	  }
	  if(drive->data_buf[15]==2)
		cpti->mode2 = 1;
	}
	else{
	  ret = SendReadSubchannel(drive, (BYTE)track_num, 0, 1, RSCF_ISRC);
	  if(ret!=RET_OK){
		DispCommandError(drive);
		return ret;
	  }
	  if(drive->data_buf[8] & 0x80){
		memcpy(cpti->isrc, drive->data_buf+9, 12);
	  }
	  if(track_num>1){
			/* Mbv𒲂ׂ */
		ret = GetGapLen(drive, cpti);
		if(ret!=RET_OK){
		  return ret;
		}
	  }
	}
  }

  return RET_OK;
}

static int AdjustTrackSize(CMDDRIVE *drive, CPDISCINFO *discinfo,
						   WORD track_num, DWORD lout_start)
{
  DWORD next_start=0;
  CPTRACKINFO *cpti, *ncpti=NULL;
  DWORD lba, track_size;
  int ret;
#if 0
  char buf[80];
#endif

  if(!REALDRIVE(drive))
	return RET_OK;

  if(DT_DVD_FAMILY(drive->disc_type))
	return RET_OK;

  next_start = lout_start;
  cpti = &discinfo->trackinfo[track_num-1];
  if(cpti->tao){
		/* gbNȂgbN̍Ō2ubNǂł݂ */
	if(Get4bytes(cpti->trackinfo.free_blocks)==0){
	  lba = Get4bytes(cpti->trackinfo.track_start) + 
		Get4bytes(cpti->trackinfo.track_size) -2;
	  ret = SendReadCD(drive, lba, 2);
	  if(ret!=RET_OK){
			/* ǂ߂ȂȂ炽Ԃ Run-out ł傤 */
		track_size = Get4bytes(cpti->trackinfo.track_size) -2;
		Set4bytes(cpti->trackinfo.track_size, track_size);
	  }
	}
	return RET_OK;
  }
  if(track_num < discinfo->tracks){
	ncpti = &discinfo->trackinfo[track_num];
	if(((WORD)cpti->trackinfo.session_number_msb<<8 | cpti->trackinfo.session_number_lsb)==
	   ((WORD)ncpti->trackinfo.session_number_msb<<8 | ncpti->trackinfo.session_number_lsb)){
		  /* ̃gbNZbV */
	  next_start = Get4bytes(ncpti->trackinfo.track_start);
	  if(IS_TRACKMODE_DATA(ncpti->trackinfo.track_mode)){
		next_start -= 150;
		if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ||
		   ncpti->mode2 != cpti->mode2){
			  /* 2part */
		  next_start -= 75;
		}
	  }
	  else{
		next_start -= ncpti->pause_len;
	  }
	}
  }
  if(next_start==0)
	return RET_OK;

	  /* ۂɓǂł݂? */
  for(lba=next_start-4; lba<next_start; lba++){
	ret = SendReadCD(drive, lba, 1);
	if(ret!=RET_OK)
	  break;
  }

  track_size = lba-Get4bytes(cpti->trackinfo.track_start);
#if 0
  if(track_size != Get4bytes(cpti->trackinfo.track_size)){
	sprintf(buf, "gbN%d ̃TCY 0x%08lX  0x%08lX ɕύX܂B",
			track_num, Get4bytes(cpti->trackinfo.track_size), track_size);
	UIDispMessage(buf, UIDMT_INFORMATION);
  }
#endif
  Set4bytes(cpti->trackinfo.track_size, track_size);

  return RET_OK;
}

static int GetCDText(CMDDRIVE *drive, CPDISCINFO *discinfo)
{
  int ret;
  WORD len;

  ret = SendReadToc(drive, 0, 0, RTF_CDTEXT);
  if(ret!=RET_OK){
	return RET_OK;
  }
  len = Get2bytes(drive->data_buf);
  if(len<=2){	/* header(4bytes) - length field(2bytes) */
		/* CD-TEXTȂ */
	return RET_OK;
  }
  len -= 2;
  discinfo->cdtext = (BYTE *)malloc(len);
  if(discinfo->cdtext==NULL)
	return RET_MEMERR;
  memcpy(discinfo->cdtext, drive->data_buf+4, len);
  discinfo->cdtext_size = len;
  return RET_OK;
}


static int GetDiscInformation(CMDDRIVE *drive, CPDISCINFO *discinfo)
{
  int ret;
  WORD track_num;
  WORD sess_num, last_sess_num;
  BOOL tao;
  struct _DISCINFO *di;
  CPTRACKINFO *cpti;
  DWORD last_addr=0, lout_start=0;
  DWORD track_size;
#ifdef WIN32
  __int64 file_size;
#else
  off_t file_size;
#endif

  if(!REALDRIVE(drive)){
	if(drive->type == CMDDRVTYPE_ISO){
		  /* ISOC[Wt@C̏ꍇ */
	  memset(discinfo, 0, sizeof(CPDISCINFO));
		  /* t@CTCY擾 */
#ifdef WIN32
	  file_size = _lseeki64(_fileno(drive->u.image.fp), 0, SEEK_END);
	  _lseeki64(_fileno(drive->u.image.fp), 0, SEEK_SET);
#else
	  fseeko(drive->u.image.fp, 0, SEEK_END);
	  file_size = ftello(drive->u.image.fp);
	  fseeko(drive->u.image.fp, 0, SEEK_SET);
#endif
	  track_size = (DWORD)((file_size+2047)/2048);
		
		  /* fBXNݒ */
	  discinfo->disc_stat = DISCSTAT_COMPLETE;
	  discinfo->last_sess_stat = SESSSTAT_COMPLETE;
	  discinfo->last_addr = (DWORD)(track_size-1);
	  discinfo->sessions = 1;
	  discinfo->tracks = 1;
	  discinfo->trackinfo = (CPTRACKINFO *)malloc(sizeof(CPTRACKINFO));
	  if(discinfo->trackinfo==NULL){
		free(discinfo->cdtext);
		discinfo->cdtext = NULL;
		return RET_MEMERR;
	  }
	  memset(discinfo->trackinfo, 0, sizeof(CPTRACKINFO));
	  discinfo->trackinfo->mode2 = 0;
	  discinfo->trackinfo->tao = FALSE;
	  discinfo->trackinfo->trackinfo.track_number_lsb = 1;
	  discinfo->trackinfo->trackinfo.session_number_lsb = 1;
	  discinfo->trackinfo->trackinfo.track_mode = 4;
	  discinfo->trackinfo->trackinfo.data_mode = 0x0f;
	  Set4bytes(discinfo->trackinfo->trackinfo.track_start, 0);
	  Set4bytes(discinfo->trackinfo->trackinfo.track_size, track_size);
	}
	else{
		  /* C[Wt@CfBXN𓾂 */
	  ret = ReadImageFile(&drive->u.image, discinfo,
						  sizeof(CPDISCINFO)-sizeof(CPTRACKINFO *),
						  TRUE);
	  if(ret!=RET_OK)
		return ret;
	  if(discinfo->version != IMGFILE_VERSION){
		return RET_NG;
	  }
		  /* CD-TEXT */
	  if(discinfo->cdtext_size>0){
		discinfo->cdtext = (BYTE *)malloc(discinfo->cdtext_size);
		if(discinfo->cdtext==NULL)
		  return RET_MEMERR;
		ret = ReadImageFile(&drive->u.image, discinfo->cdtext,
							discinfo->cdtext_size,
							TRUE);
		if(ret!=RET_OK){
		  free(discinfo->cdtext);
		  discinfo->cdtext = NULL;
		  return ret;
		}
	  }
	  else{
		discinfo->cdtext = NULL;
	  }
		  /* gbN */
	  discinfo->trackinfo = (CPTRACKINFO *)malloc(sizeof(CPTRACKINFO)*discinfo->tracks);
	  if(discinfo->trackinfo==NULL){
		free(discinfo->cdtext);
		discinfo->cdtext = NULL;
		return RET_MEMERR;
	  }
	  ret = ReadImageFile(&drive->u.image, discinfo->trackinfo,
						  sizeof(CPTRACKINFO)*discinfo->tracks,
						  TRUE);
	  if(ret!=RET_OK){
		free(discinfo->cdtext);
		discinfo->cdtext = NULL;
		free(discinfo->trackinfo);
		discinfo->trackinfo = NULL;
		return ret;
	  }
	}
	return RET_OK;
  }

	  /* hCu擾 */
  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }
  di = (struct _DISCINFO *)drive->data_buf;
  discinfo->disc_stat = di->disc_status;
  discinfo->last_sess_stat = di->sess_status;
  discinfo->sessions = (WORD)di->numsess_msb<<8 | di->numsess_lsb;
  discinfo->tracks = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
  discinfo->disc_type = di->disc_type;

  discinfo->cdtext = NULL;
  discinfo->cdtext_size = 0;
  memset(discinfo->media_catalog_number, 0, 13+1);
  if(DT_CD_FAMILY(drive->disc_type)){
	ret = SendReadSubchannel(drive, 0, 0, 1, RSCF_MCN);
	if(ret!=RET_OK){
	  DispCommandError(drive);
	  return ret;
	}
	if(drive->data_buf[8] & 0x80){
	  memcpy(discinfo->media_catalog_number, drive->data_buf+9, 13);
	}
		/* CD-TEXT */
	ret = GetCDText(drive, discinfo);
	if(ret!=RET_OK){
	  return ret;
	}
  }

	  /* gbNƂɏ擾 */
  UIMeter1Initialize("擾");
  if(drive->type==CMDDRVTYPE_NET){
	NAUIMeter1Initialize(&drive->u.net, "擾");
  }
  discinfo->trackinfo = (CPTRACKINFO *)malloc(sizeof(CPTRACKINFO)*discinfo->tracks);
  for(track_num=1; track_num<=discinfo->tracks; track_num++){
	UIMeter1Update(track_num*100/discinfo->tracks/2);
	if(drive->type==CMDDRVTYPE_NET){
	  NAUIMeter1Update(&drive->u.net, (BYTE)(track_num*100/discinfo->tracks/2));
	}
	if(UICheckAbort()){
	  free(discinfo->cdtext);
	  discinfo->cdtext = NULL;
	  free(discinfo->trackinfo);
	  discinfo->trackinfo = NULL;
	  return RET_ABORT;
	}
	cpti = &discinfo->trackinfo[track_num-1];
	ret = GetTrackInformation(drive, track_num, cpti);
	if(ret!=RET_OK){
	  free(discinfo->cdtext);
	  discinfo->cdtext = NULL;
	  free(discinfo->trackinfo);
	  discinfo->trackinfo = NULL;
	  return ret;
	}
  }

  last_sess_num = 0;
  for(track_num=1; track_num<=discinfo->tracks; track_num++){
	UIMeter1Update(track_num*100/discinfo->tracks/2+50);
	if(drive->type==CMDDRVTYPE_NET){
	  NAUIMeter1Update(&drive->u.net, (BYTE)(track_num*100/discinfo->tracks/2+50));
	}
	if(UICheckAbort()){
	  free(discinfo->cdtext);
	  discinfo->cdtext = NULL;
	  free(discinfo->trackinfo);
	  discinfo->trackinfo = NULL;
	  return RET_ABORT;
	}
	cpti = &discinfo->trackinfo[track_num-1];
		/* ZbVTAOL^ǂ𒲂ׂ */
	sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
	  cpti->trackinfo.session_number_lsb;
	if(sess_num != last_sess_num){
	  ret = WhetherTAO(drive, sess_num, &tao, &lout_start);
	  if(ret!=RET_OK){
		free(discinfo->cdtext);
		discinfo->cdtext = NULL;
		free(discinfo->trackinfo);
		discinfo->trackinfo = NULL;
		return ret;
	  }
	  last_sess_num = sess_num;
	}
	cpti->tao = tao;
		/* gbNTCY */
	ret = AdjustTrackSize(drive, discinfo, track_num, lout_start);
	if(ret!=RET_OK){
	  free(discinfo->cdtext);
	  discinfo->cdtext = NULL;
	  free(discinfo->trackinfo);
	  discinfo->trackinfo = NULL;
	  return ret;
	}
		/* fBXNŏIAhXXV */
	if(cpti->trackinfo.nwa_valid){
	  if(Get4bytes(cpti->trackinfo.next_writable_addr) > Get4bytes(cpti->trackinfo.track_start))
		last_addr = Get4bytes(cpti->trackinfo.next_writable_addr);
	}
	else{
	  last_addr = Get4bytes(cpti->trackinfo.track_start) +
		Get4bytes(cpti->trackinfo.track_size);
	}
  }
  discinfo->last_addr = last_addr;

  if(DT_DVD_FAMILY(drive->disc_type) && discinfo->tracks>1){
		/* DVDDAOł͕gbNL^łȂ */
	if(GetOption()->dao){
	  ret = UIDispMessage("gbN݂̂ DAO L^ł܂B\nTAO ŋL^𑱍s܂H",
						  UIDMT_QUESTION);
	  if(ret!=UIDMRET_OK){
		free(discinfo->cdtext);
		discinfo->cdtext = NULL;
		free(discinfo->trackinfo);
		discinfo->trackinfo = NULL;
		return RET_ABORT;
	  }
	  GetOption()->dao = FALSE;
	}
  }

  return RET_OK;
}

static int FormatDVD(CMDDRIVE *drive, BYTE type, DWORD size)
{
  int ret;
  WORD len, offset;
  struct _FORMATCAPA_HEADER *fch;
  struct _FORMATLIST_HEADER *fh;
  struct _FORMATDESC *fd, fcd;
  const char *message;

  if(!REALDRIVE(drive))
	return RET_OK;

	  /* Format Descriptor 𓾂 */
  ret = SendReadFormatCapacities(drive);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }
  fch = (struct _FORMATCAPA_HEADER *)drive->data_buf;
  len = fch->list_len;
  offset = sizeof(struct _FORMATCAPA_HEADER) + sizeof(struct _FORMATCURMAXDESC);
  for(; offset<len; offset += sizeof(struct _FORMATDESC)){
	fd = (struct _FORMATDESC *)(drive->data_buf + offset);
	if(fd->format_type==type){
	  memcpy(&fcd, fd, sizeof(struct _FORMATDESC));
	  break;
	}
  }
  if(offset>=len){
	return RET_NG;
  }

  fh = (struct _FORMATLIST_HEADER *)drive->data_buf;
  fd = (struct _FORMATDESC *)(drive->data_buf+sizeof(struct _FORMATLIST_HEADER));
  memset(fh, 0, sizeof(struct _FORMATLIST_HEADER));
  memcpy(fd, &fcd, sizeof(struct _FORMATDESC));
  fh->fov = 1;
  fh->immed = 1;
  Set2bytes(fh->fmtdesc_len, sizeof(struct _FORMATDESC));
  if(Get4bytes(fd->num_blocks) > size)
	Set4bytes(fd->num_blocks, size);
  len = sizeof(struct _FORMATLIST_HEADER) + sizeof(struct _FORMATDESC);
  ret = SendFormatUnit(drive, 1, 0, FUFC_OTHER, len);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }

  if(type==FDFT_QUICK || type==FDFT_QUICKADD || type==FDFT_QUICKGROW)
	message = "";
  else
	message = "";
  ret = WaitProgress(drive, message, FALSE);
  if(ret!=RET_OK){
	if(ret==RET_CMDERR)
	  DispCommandError(drive);
	return ret;
  }

  return RET_OK;
}

static int Formatting(CMDDRIVE *drive)
{
  int ret;
  struct _DISCINFO *di;

  if(!REALDRIVE(drive)){
	return RET_OK;
  }

  if(drive->disc_type!=DT_DVDPRW){
	return RET_OK;
  }

  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }

  di = (struct _DISCINFO *)drive->data_buf;
  if(di->bgformat_stat != BGFSTAT_NOTFORMATTED){
	return RET_OK;
  }

  ret = FormatDVD(drive, FDFT_DVDPRW, 0xffffffff);
  if(ret!=RET_OK){
	return ret;
  }

  return RET_OK;
}

static int Blanking(CMDDRIVE *drive)
{
  int ret;
  struct _DISCINFO *di;

  if(!REALDRIVE(drive)){
	return RET_OK;
  }

  if(drive->disc_type==DT_DVDRWS || drive->disc_type==DT_DVDRWO){
	if(GetOption()->dao==FALSE){
		  /* QuickFormat ̂ Blank sv */
	  return RET_OK;
	}
  }
  if(drive->disc_type==DT_DVDPRW){
		/* sv */
	return RET_OK;
  }
  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }

  di = (struct _DISCINFO *)drive->data_buf;
  if(di->disc_status==DISCSTAT_EMPTY){
	return RET_OK;
  }
  if(di->erasable==0){
	UIDispMessage("L^fBXNuNł͂Ȃ̂ŕʂł܂B", UIDMT_ERROR);
	return RET_NG;
  }

  ret = UIDispMessage("L^fBXNuNł͂܂B܂H", UIDMT_QUESTION);
  if(ret==UIDMRET_CANCEL){
	return RET_ABORT;
  }

  ret = BlankDisc(drive, 1);
  if(ret!=RET_OK){
	if(ret==RET_CMDERR){
	  DispCommandError(drive);
	}
	return ret;
  }

  return RET_OK;
}

static int GetWritableSize(CMDDRIVE *drive, DWORD *size_ret)
{
  int ret;
  WORD track_num;
  struct _DISCINFO *di;
  struct _TRACKINFO *ti;

  *size_ret = 0UL;
  if(!REALDRIVE(drive))
	return RET_OK;

  ret = SendReadDiscInfo(drive);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }
  di = (struct _DISCINFO *)drive->data_buf;
  track_num = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
  ret = SendReadTrackInfo(drive, track_num);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }
  ti = (struct _TRACKINFO *)drive->data_buf;
  *size_ret = Get4bytes(ti->free_blocks);

  return RET_OK;
}


static int CloseSession(CMDDRIVE *drive, int num_drv)
{
  int ret;
  int index;

  if(!REALDRIVE(&drive[0])){
	  return RET_OK;
  }

  for(index=0; index<num_drv; index++){
	ret = SendCloseTrackSession(&drive[index], 1, CTST_CLOSESESSION, 0);
	if(ret!=RET_OK){
	  DispCommandError(&drive[index]);
	  return ret;
	}
  }

  index=num_drv-1;
  ret = WaitProgress(&drive[index], "ZbV", FALSE);
  if(ret!=RET_OK){
	if(ret==RET_CMDERR)
	  DispCommandError(&drive[index]);
	return ret;
  }

  return RET_OK;
}

static int ExecCloseTrack(CMDDRIVE *drive, int num_drv, WORD track_num)
{
  int ret;
  int index;

  if(!REALDRIVE(&drive[0]))
	return RET_OK;

  for(index=0; index<num_drv; index++){
	ret = SendCloseTrackSession(&drive[index], 1, CTST_CLOSETRACK, track_num);
	if(ret!=RET_OK){
	  DispCommandError(&drive[index]);
	  return ret;
	}
  }

  index = num_drv-1;
  ret = WaitProgress(&drive[index], "gbN", FALSE);
  if(ret!=RET_OK){
	if(ret==RET_CMDERR)
	  DispCommandError(&drive[index]);
	return ret;
  }

  return RET_OK;
}

static int SyncCache(CMDDRIVE *drive)
{
  int ret;

  if(!REALDRIVE(drive))
	return RET_OK;

  ret = SendSynchronizeCache(drive, 1);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }

  ret = WaitProgress(drive, NULL, FALSE);
  if(ret!=RET_OK){
	if(ret==RET_CMDERR)
	  DispCommandError(drive);
	return ret;
  }

  return RET_OK;
}

static int ReserveTrack(CMDDRIVE *drive, DWORD size)
{
  int ret;

  if(!REALDRIVE(drive))
	return RET_OK;

  ret = SendReserveTrack(drive, size);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }

  return RET_OK;
}


static int SetWriteParametersPage(CMDDRIVE *drive, CPDISCINFO *discinfo,
								  WORD track_num, BOOL sao)
{
  CPTRACKINFO *cpti;
  struct _MODEPAGE05 *mp05;
  WORD sess_num;
  int ret;

  if(!REALDRIVE(drive))
	return RET_OK;

  if(track_num==0)
	track_num=1;
  cpti = &discinfo->trackinfo[track_num-1];
  sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
	(WORD)cpti->trackinfo.session_number_lsb;

	  /* ݒl擾ĕKvȕ */
  ret = SendModeSense(drive, MSPC_CURRENT, 5);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }
  mp05 = (struct _MODEPAGE05 *)(drive->data_buf +
								(drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));

  if(DT_DVD_FAMILY(drive->disc_type)){
	mp05->write_type = MP05WT_PACKET;
	mp05->track_mode = MP05TM_DATA;
	mp05->dbtype = MP05DBT_MODE1;
  }
  else{
	mp05->track_mode = cpti->trackinfo.track_mode;
	if(IS_TRACKMODE_DATA(mp05->track_mode)){
	  mp05->dbtype = cpti->mode2 ? MP05DBT_MIX : MP05DBT_MODE1;
	  mp05->write_type = cpti->trackinfo.packet ? MP05WT_PACKET : MP05WT_TAO;
	}
	else{
	  mp05->dbtype = MP05DBT_CDDA_2352;
	  mp05->write_type = MP05WT_TAO;
	}
  }

  mp05->BUFE = GetOption()->bufe;
  mp05->test_write = GetOption()->test_write;
  if(discinfo->sessions == sess_num){
		/* ŏIZbV */
	mp05->multi_session = discinfo->disc_stat==DISCSTAT_COMPLETE ? 0 : 3;
  }
  else{
	mp05->multi_session = 3;
  }
  mp05->fp = cpti->trackinfo.fp;
  mp05->copy = cpti->trackinfo.copy;
  mp05->session_format = discinfo->disc_type;
  memcpy(mp05->packet_size, cpti->trackinfo.packet_size, 4);

  if(sao){
	mp05->write_type = MP05WT_SAO;
	mp05->track_mode = MP05TM_DATA;
	mp05->fp = 0;
	Set4bytes(mp05->packet_size, 0UL);
  }

	  /* MCN */
  if(strlen(discinfo->media_catalog_number)>0){
	memcpy(mp05->media_cat_number, discinfo->media_catalog_number, 13);
	mp05->mc_val = 1;
  }
  else{
	memset(mp05->media_cat_number, 0, 13);
	mp05->mc_val = 0;
  }
	  /* ISRC */
  if(strlen(cpti->isrc)>0){
	memcpy(mp05->ISRC, cpti->isrc, 12);
	mp05->tc_val = 1;
  }
  else{
	memset(mp05->ISRC, 0, 12);
	mp05->tc_val = 0;
  }
  
  ret = SendModeSelect(drive, 5);
  if(ret!=RET_OK){
	DispCommandError(drive);
	return ret;
  }

  return RET_OK;
}


static int SetSpeed(CMDDRIVE *drive, int read_speed, int write_speed)
{
  int ret;
  WORD read_kbps, write_kbps;
  struct _PERFORMANCEDESC *pd;

  if(!REALDRIVE(drive))
	return RET_OK;

  if(DT_CD_FAMILY(drive->disc_type)){
	read_kbps = read_speed ? (WORD)(read_speed*176.4) : 0xffff;
	write_kbps = write_speed ? (WORD)(write_speed*176.4) : 0xffff;
	ret = SendSetCdSpeed(drive, read_kbps, write_kbps, 0);
	if(ret!=RET_OK){
	  DispCommandError(drive);
	  return ret;
	}
  }
  else{
	pd = (struct _PERFORMANCEDESC *)drive->data_buf;
	memset(pd, 0, sizeof(struct _PERFORMANCEDESC));
	pd->rdd = (read_speed==0 && write_speed==0) ? 1:0;
	Set4bytes(pd->read_size, (DWORD)(read_speed*1385));
	Set4bytes(pd->read_time, 1000);
	Set4bytes(pd->write_size, (DWORD)(write_speed*1385));
	Set4bytes(pd->write_time, 1000);

	ret = SendSetStreaming(drive);
#if 0	/* G[ɂȂĂpׁA */
	if(ret!=RET_OK){
	  DispCommandError(drive);
	  return ret;
	}
#endif
  }

  return RET_OK;
}



static int GetVPSize(CMDDRIVE *drive, DWORD lba, DWORD *size_ret)
{
  BYTE tmp[4];
  DWORD start_lba;
  DWORD len;
  int ret;

  if(!REALDRIVE(drive)){
	if(drive->type == CMDDRVTYPE_ISO){
	  return RET_OK;
	}
	else{
	  ret = ReadImageFile(&drive->u.image, tmp, 4, TRUE);
	  if(ret!=RET_OK)
		return ret;
	  *size_ret = Get4bytes(tmp);
	}	  
  }
  else{
	start_lba = lba;
	len = drive->bufsize / 2352;
	ret=RET_OK;
	while(TRUE){
	  while(TRUE){
		if(UICheckAbort())
		  return RET_ABORT;
		ret = SendReadCD(drive, lba, len);
		if(ret!=RET_OK)
		  break;
		lba += len;
	  }
	  if(len==1)
		break;
	  len=1;
	}
	*size_ret = lba - start_lba;
  }
  
  return RET_OK;
}

static int SetVPSize(CMDDRIVE *drive, DWORD size)
{
  BYTE tmp[4];
  int ret;

  if(!REALDRIVE(drive)){
	if(drive->type == CMDDRVTYPE_ISO){
	  return RET_OK;
	}
	else{
	  Set4bytes(tmp, size);
	  ret = WriteImageFile(&drive->u.image, tmp, 4, TRUE);
	  if(ret!=RET_OK)
		return ret;
	}
  }
  
  return RET_OK;
}


/**
 * @brief	READgC񐔐ݒ(ModePage01h)
 * @param[in]	drive	ΏۃhCu
 * @param[in]	count	ݒ肷郊gC
 * @param[out]	current	ݒÕgC
 * @retval	RET_OK	I
 * @retval	RET_CMDERR	R}hG[
 * @retval	RET_NG	G[
 */
static int SetReadRetryCount(CMDDRIVE *drive, BYTE count, BYTE *current)
{
  int ret;
  struct _MODEPAGE01 *mp01;
  ret = SendModeSense(drive, MSPC_CURRENT, 1);
  if(ret != RET_OK){
	return ret;
  }
  mp01 = (struct _MODEPAGE01 *)
	(drive->data_buf + (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8 : 16));
  if(current != NULL){
	*current = mp01->rd_retry_count;
  }
  mp01->rd_retry_count = count;
  ret = SendModeSelect(drive, 1);
  if(ret != RET_OK){
	return ret;
  }

  return RET_OK;
}

/**
 * @brief	READs
 * @param[in]	src		ǂݍ݃hCu
 * @param[in]	lba		JnLBA
 * @param[in]	blocksize	ubNTCY
 * @param[in]	len		ǂݍ݃ubN
 * @param[in]	long_read	LONGREAD邩ǂ
 * @param[in]	long_read_size	LONGREAD̃TCY
 * @retval	RET_OK	I
 * @retval	RET_CMDERR	R}hG[
 * @retval	RET_NG	G[
 */
static int ExecRead(CMDDRIVE *src, DWORD lba, DWORD blocksize, DWORD len,
					BOOL long_read, DWORD long_read_size)
{
  int ret;
  BYTE *sp, *dp;
  DWORD cnt;
  
	  /* Read */
  if(!REALDRIVE(src)){
	ret = ReadImageFile(&src->u.image, src->data_buf, blocksize*len,
						(src->type==CMDDRVTYPE_IMAGE) ? TRUE:FALSE);
	if(ret!=RET_OK)
	  return ret;
  }
  else{
	if(long_read){
	  if(long_read_size){
			/* LONGREADM */
		if(blocksize==2048){
		  ret = SendLongRead12(src, lba, (WORD)len, len*blocksize,
							   long_read_size);
		}
		else{
		  ret = SendLongReadCD(src, lba, len, long_read_size);
		}
		if(ret!=RET_OK){
		  return ret;
		}
	  }
		  /* LONGREADʎM */
	  if(blocksize==2048){
		ret = SendLongRead12(src, lba, (WORD)len, len*blocksize, 0);
	  }
	  else{
		ret = SendLongReadCD(src, lba, len, 0);
	  }
	  if(ret!=RET_OK){
		return ret;
	  }
	}
	else{
		  /* ʏREAD */
	  if(blocksize==2048){
		ret = SendRead10(src, lba, (WORD)len, len*blocksize);
	  }
	  else{
		ret = SendReadCD(src, lba, len);
	  }
			
	  if(ret!=RET_OK){
		return ret;
	  }
	}
	  
	if(blocksize==2332){
		  /* ReadCD bs=2352 œǂ񂾂ǂA
			 KvȂ̂ 2332 Ȃ̂Ńobt@l߂ */
	  sp = dp = src->data_buf;
	  sp += 16;	/* sync 16bytes */
	  for(cnt=0; cnt<len; cnt++){
		memmove(dp, sp, 2332);
		sp += 2352;
		dp += 2332;
	  }
	}
	else if(blocksize==2336){
		  /* 2336 Ƀobt@l߂ */
	  sp = dp = src->data_buf;
	  sp += 16;	/* sync 16bytes */
	  for(cnt=0; cnt<len; cnt++){
		memmove(dp, sp, 2336);
		sp += 2352;
		dp += 2336;
	  }
	}
  }

  return RET_OK;
}

  

/*
 * blocksize  2048/2332/2336/2352 삷B
 * ȊO͑ΉĂȂB
 */
static int ExecReadWrite(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
						 DWORD lba, DWORD blocksize, DWORD len,
						 BOOL long_read, DWORD long_read_size,
						 BOOL leadin)
{
	int ret;
	int index;
	int retry=0;
	char info[80];
	BYTE rdretry_keep=0;

	for(retry=0; retry<=32; retry++){
	  if(retry > 0){
		if(rdretry_keep == 0){
			  /* hCuREADgC񐔂𑝂₷ */
		  ret = SetReadRetryCount(src, 0xff, &rdretry_keep);
		  if(ret != RET_OK){
			rdretry_keep=0;
		  }
		}
		if(retry==16){
			  /* ăXsAbvĂ݂肷 */
		  UIDispInfo("ĉ]");
		  if(UICheckAbort()){
			ret = RET_ABORT;
			break;
		  }
		  SendStartStop(src, 1, 0, 0);
#ifdef WIN32
		  Sleep(1000);
#else
		  sleep(1);
#endif
		}
		sprintf(info, "ēǍ:%d", retry);
		UIDispInfo(info);
		if(UICheckAbort()){
		  ret = RET_ABORT;
		  break;
		}
	  }
	  ret = ExecRead(src, lba, blocksize, len, long_read, long_read_size);
	  if(ret==RET_OK){
		break;
	  }
	  else if(ret!=RET_CMDERR){
		break;
	  }
	}
	if(rdretry_keep > 0){
		  /* hCuREADgC񐔐ݒ߂ */
	  SetReadRetryCount(src, rdretry_keep, NULL);
	}
	if(ret!=RET_OK){
	  DispCommandError(src);
	  return ret;
	}

	/* Write */
	if(!REALDRIVE(&dst[0])){
	  ret = WriteImageFile(&dst->u.image, dst->data_buf, len*blocksize,
						   (dst->type==CMDDRVTYPE_IMAGE) ? TRUE:FALSE);
	  if(ret!=RET_OK)
		return ret;
	}
	else{
	  if(leadin && (num_dst>1)){
			/*
			 * SAOLead-inL^JnꍇAL^uœ
			 * Lead-inL^Jn悤ɂB
			 */
		BOOL *started = (BOOL *)malloc(sizeof(BOOL)*num_dst);
		int start_count=0;
		if(started==NULL){
		  return RET_MEMERR;
		}
		memset(started, 0, sizeof(BOOL)*num_dst);
		while(start_count<num_dst){
		  for(index=0; index<num_dst; index++){
			if(started[index]){
			  continue;
			}
			ret = SendWrite10(&dst[index], lba, (WORD)len, len*blocksize,
							  FALSE);
			if(ret==RET_CMDERR){
			  if((SD_SENSEKEY(&dst[index])==0x02) &&
				 (SD_ASC(&dst[index])==0x04) &&
				 (SD_ASCQ(&dst[index])==0x08)){
				continue;
			  }
			}
			if(ret!=RET_OK){
			  DispCommandError(&dst[index]);
			  free(started);
			  return ret;
			}
			started[index] = TRUE;
			start_count++;
		  }
		}
		free(started);
	  }
	  else{
			/* Lead-inL^JnȂǂ͈ӎɕʂɋL^ */
		for(index=0; index<num_dst; index++){
		  ret = SendWrite10(&dst[index], lba, (WORD)len, len*blocksize, TRUE);
		  if(ret!=RET_OK){
			DispCommandError(&dst[index]);
			return ret;
		  }
		}
		
	  }
	}

	return RET_OK;
}



static int OpenTrack(CMDDRIVE *drive, CPDISCINFO *discinfo, WORD track_num)
{
  int ret;

  if(REALDRIVE(drive)){
	if(DT_CD_FAMILY(drive->disc_type)){
	  ret = SetWriteParametersPage(drive, discinfo, track_num,
								   !discinfo->trackinfo[track_num-1].tao );
	  if(ret!=RET_OK)
		return ret;
	}
	else{
	  if(drive->disc_type==DT_DVDR ||
		 drive->disc_type==DT_DVDRWS || drive->disc_type==DT_DVDRWO){
			/* DVD-R/-RW */
		if(drive->disc_type!=DT_DVDR && GetOption()->dao==FALSE){
		  ret = FormatDVD(drive,
						  (BYTE)(track_num==1 ? FDFT_QUICK : FDFT_QUICKADD),
						  0x00000000);
		}
		else{
		  ret = SetWriteParametersPage(drive, discinfo, track_num,
									   GetOption()->dao);
		}
		if(ret!=RET_OK)
		  return ret;
	  }
	}
  }

  return RET_OK;
}


static int CloseTrack(CMDDRIVE *drive, int num_drv,
					  CPDISCINFO *discinfo, WORD track_num)
{
  CPTRACKINFO *cpti;
  int ret;

  if(REALDRIVE(&drive[0])){
	cpti = &discinfo->trackinfo[track_num-1];
	if(cpti->trackinfo.packet && cpti->trackinfo.nwa_valid==0 &&
	   Get4bytes(cpti->trackinfo.free_blocks)==0 &&
	   drive[0].disc_type!=DT_DVDRWS &&
	   drive[0].disc_type!=DT_DVDRWO &&
	   GetOption()->dao==FALSE){
	  ret = ExecCloseTrack(drive, num_drv, track_num);
	  if(ret!=RET_OK)
		return ret;
	}
  }

  return RET_OK;
}

static void MakeCDTextBuffer(BYTE *buf, DWORD fillsize,
							 BYTE *cdtext, DWORD cdtext_size, DWORD *cdtext_offset)
{
  DWORD cdtext_restsize;
  DWORD copysize;

  while(fillsize>0){
	cdtext_restsize = cdtext_size - (*cdtext_offset);
	if(fillsize < cdtext_restsize){
	  copysize = fillsize;
	}
	else{
	  copysize = cdtext_restsize;
	}
	
	memcpy(buf, cdtext+(*cdtext_offset), copysize);
	buf += copysize;
	fillsize -= copysize;
	*cdtext_offset += copysize;
	if(*cdtext_offset >= cdtext_size)
	  *cdtext_offset = 0;
  }
}

/*
 * CRČvZ̓Tbp܂B
 * crc.h ɏĂʂAcdrecord 2.0 pNĂĂ܂B
 */
#define LOCAL
#define UInt16_t WORD
#include "crc.h"
static void CalcCDTextCRC(CPDISCINFO *discinfo)
{
  int i, j;
  WORD crc;

  for(i=0; i<discinfo->cdtext_size; i+=18){
	crc = 0;
	for(j=0; j<16; j++){
	  crc = (crc<<BPB) ^ crctab[(crc>>(BPW-BPB)) ^ discinfo->cdtext[i+j]];
	}
	crc = crc ^ 0xFFFF;
	discinfo->cdtext[i+16] = (BYTE)(crc>>8);
	discinfo->cdtext[i+17] = (BYTE)(crc);
  }
}


static int WriteCDText(CMDDRIVE *drive, int num_drv, CPDISCINFO *discinfo)
{
	int ret = RET_OK;
	struct _DISCINFO *di;
	DWORD lba;
	DWORD rest_blocks, total_blocks, len, deflen;
	BYTE *converted_cdtext=NULL;
	DWORD converted_cdtext_size;
	DWORD cdtext_offset=0;
	long t1, t2;
	DWORD i;
	DWORD *leadin_start;
	DWORD max_leadin;
	int index;

	if(!REALDRIVE(&drive[0]))
		return RET_OK;

	leadin_start = (DWORD *)malloc(sizeof(DWORD)*num_drv);
	if(leadin_start == NULL){
	  return RET_MEMERR;
	}
		/* Lead-inJnԂ擾 */
	max_leadin = 0;
	for(index=0; index<num_drv; index++){
	  ret = SendReadDiscInfo(&drive[index]);
	  if(ret!=RET_OK){
		DispCommandError(&drive[index]);
		free(leadin_start);
		return ret;
	  }
	  di = (struct _DISCINFO *)drive[index].data_buf;
	  leadin_start[index] = MSF2LBA(di->last_lead_in[1],
									di->last_lead_in[2],
									di->last_lead_in[3], FALSE);
	  if(max_leadin < leadin_start[index]){
		max_leadin = leadin_start[index];
	  }
	}
		/*
		 * }ĂfBXN̒ŁALead-inJnԂ
		 * x̂ɍ킹B
		 */
	for(index=0; index<num_drv; index++){
	  len = (drive[index].bufsize-1)/96;
	  lba = leadin_start[index];
	  rest_blocks = (DWORD)(max_leadin-lba);
	  memset(drive[index].data_buf, 0, drive[index].bufsize);
	  while(rest_blocks > 0){
		if(len > rest_blocks){
		  len = rest_blocks;
		}
		ret = SendWrite10(&drive[index], lba, (WORD)len, len*96, TRUE);
		if(ret!=RET_OK){
		  DispCommandError(&drive[index]);
		  free(leadin_start);
		  return ret;
		}
		rest_blocks -= len;
		lba += len;
	  }
	}
	free(leadin_start);

		/* CD-TEXTf[^쐬 */
	CalcCDTextCRC(discinfo);
	converted_cdtext_size = (discinfo->cdtext_size * 4+2)/3;
	converted_cdtext = malloc(converted_cdtext_size);
	if(converted_cdtext==NULL)
	  return RET_MEMERR;
	for(i=0; i<converted_cdtext_size/4; i++){
		  /*   8bit        6bit
		   * aaaaaaaa    00aaaaaa
		   * bbbbbbbb => 00aabbbb
		   * cccccccc    00bbbbcc
		   *             00cccccc
		   */
	  converted_cdtext[i*4+0] = (discinfo->cdtext[i*3+0]>>2) & 0x3f;
	  converted_cdtext[i*4+1] = ((discinfo->cdtext[i*3+0]<<4) & 0x30) |
		                        ((discinfo->cdtext[i*3+1]>>4) & 0x0f);
	  converted_cdtext[i*4+2] = ((discinfo->cdtext[i*3+1]<<2) & 0x3c) |
		                        ((discinfo->cdtext[i*3+2]>>6) & 0x03);
	  converted_cdtext[i*4+3] = (discinfo->cdtext[i*3+2]>>0) & 0x3f;
	}

	lba = max_leadin;
	rest_blocks = total_blocks = (DWORD)(-150-lba);

		/*
		 * 1xɓ]łubNvZ(1ubN=96bytes)
		 * AAShCũobt@TCYƂB
		 */
	deflen = (drive->bufsize-1)/96;

		/* ʕ\ */
	UIMeter2Initialize("CD-TEXT");
	if(drive->type==CMDDRVTYPE_NET){
	  NAUIMeter2Initialize(&drive->u.net, "CD-TEXT");
	}
	t1 = t2 = time(NULL);

	while(rest_blocks>0){
	  t2 = time(NULL);
	  if(t1!=t2){
		UIMeter2Update((total_blocks-rest_blocks)*100/total_blocks);
		if(drive->type==CMDDRVTYPE_NET){
		  NAUIMeter2Update(&drive->u.net,
						   (BYTE)((total_blocks-rest_blocks)
								  *100/total_blocks));
		}
		t1=t2;
	  }
	  if(UICheckAbort()){
		ret = RET_ABORT;
		break;
	  }

	  len = deflen < rest_blocks ? deflen : rest_blocks;
	  for(index=0; index<num_drv; index++){
		MakeCDTextBuffer(drive[index].data_buf, len*96,
						 converted_cdtext, converted_cdtext_size, &cdtext_offset);
		ret = SendWrite10(&drive[index], lba, (WORD)len, len*96, TRUE);
		if(ret!=RET_OK){
		  DispCommandError(&drive[index]);
		  break;
		}
	  }
	  if(ret!=RET_OK){
		break;
	  }
	  lba += len;
	  rest_blocks -= len;
	}

	free(converted_cdtext);

	return ret;
}


static int WriteLoop(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
					 DWORD lba, DWORD blocks, DWORD deflen,
					 DWORD blocksize, BOOL vp_track, DWORD last_addr,
					 BOOL sao, BOOL leadin)
{
	int ret;
	DWORD rest_blocks, total_blocks, len;
	DWORD long_read_rest=0;
	DWORD long_read_size=0;
	BOOL long_read=FALSE;
	BOOL long_read_now=FALSE;
	long t1, t2;
	int percent_total;
	int index;

	InitSpeedData();
	rest_blocks = total_blocks = blocks;

	if(src->type == CMDDRVTYPE_NET){
		  /* LONG READ  */
	  long_read_size = (0x00ffffffUL/deflen)*deflen;
	  long_read = TRUE;
	}

	t1 = t2 = time(NULL);
	ret = RET_OK;
	while(rest_blocks>0 && ret==RET_OK){
	  if(vp_track){
		ret = GetVPSize(src, lba, &blocks);
		if(ret!=RET_OK)
		  break;
		for(index=0; index<num_dst; index++){
		  ret = SetVPSize(&dst[index], blocks);
		  if(ret!=RET_OK)
			break;
		}
		if(ret!=RET_OK)
		  break;
	  }
	  else
		blocks = rest_blocks;

	  while(blocks>0){
		t2 = time(NULL);
		if(t1!=t2){
		  percent_total = (lba*100/last_addr);
		  if(GetOption()->on_the_fly==FALSE)
			percent_total = percent_total/2 + (REALDRIVE(dst) ? 50 : 0);
		  UIMeter1Update(percent_total);
		  UIMeter2Update((total_blocks-rest_blocks)*100/total_blocks);
		  if(src->type==CMDDRVTYPE_NET){
			NAUIMeter1Update(&src->u.net, (BYTE)percent_total);
			NAUIMeter2Update(&src->u.net,
							 (BYTE)((total_blocks-rest_blocks)*100/total_blocks));
		  }
			  /* x,c莞Ԃ\ */
		  DispSpeed(lba, rest_blocks, src, dst);
		  t1=t2;
		}
		if(UICheckAbort()){
		  ret = RET_ABORT;
		  break;
		}
		len = deflen>blocks ? blocks : deflen;
		if(long_read){
		  long_read_now = FALSE;
		  if(long_read_rest == 0){
				/* LONGREADM */
			long_read_now = TRUE;
			if(long_read_size > blocks){
			  long_read_size = blocks;
			}
			long_read_rest = long_read_size;
		  }
		}
		ret = ExecReadWrite(src, dst, num_dst, lba, blocksize, len,
							long_read, (long_read_now ? long_read_size : 0),
							leadin);
		if(ret!=RET_OK)
		  break;
		lba += len;
		blocks -= len;
		rest_blocks -= len;
		if(long_read){
		  long_read_rest -= len;
		}
	  }

	  percent_total = (lba*100/last_addr);
	  if(GetOption()->on_the_fly==FALSE)
		percent_total = percent_total/2 + (REALDRIVE(dst) ? 50 : 0);
	  UIMeter1Update(percent_total);
	  UIMeter2Update((total_blocks-rest_blocks)*100/total_blocks);
	  if(src->type==CMDDRVTYPE_NET){
		NAUIMeter1Update(&src->u.net, (BYTE)percent_total);
		NAUIMeter2Update(&src->u.net,
						 (BYTE)((total_blocks-rest_blocks)*100/total_blocks));
	  }
	  if(ret==RET_OK){
		if(!sao){
		  for(index=0; index<num_dst; index++){
			ret = SyncCache(&dst[index]);
			if(ret!=RET_OK)
			  break;
		  }
		}
	  }

	  if(vp_track){
		lba += 7;
		if(rest_blocks>7)
		  rest_blocks -= 7;
		if(rest_blocks<7)
		  rest_blocks=0;
	  }
	}

	UIDispInfo("");
	if(src->type==CMDDRVTYPE_NET){
	  NAUIDispInfo(&src->u.net, "");
	}
	return ret;
}

static int CopyTrack(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
					 CPDISCINFO *discinfo, WORD track_num)
{
	int ret;
	BOOL vp_track=FALSE;
	CPTRACKINFO *cpti = &discinfo->trackinfo[track_num-1];
	DWORD len;
	DWORD blocksize;
	DWORD blocks;
	DWORD lba;
	char msgbuf[80];
	int index;

	/* VariablePacketǂ */
	if(cpti->trackinfo.packet && Get4bytes(cpti->trackinfo.packet_size)==0)
	  vp_track=TRUE;
	/* L^ubN */
	if(cpti->trackinfo.nwa_valid){
	  blocks = Get4bytes(cpti->trackinfo.next_writable_addr) -
		Get4bytes(cpti->trackinfo.track_start);
	}
	else{
	  blocks = Get4bytes(cpti->trackinfo.track_size) -
		Get4bytes(cpti->trackinfo.free_blocks);
	}
	/* ubNTCY */
	if(DT_DVD_FAMILY(dst->disc_type)){
	  blocksize = 2048;
		  /* 1ɓ]ubN */
	  len = 16;
	}
	else{
	  if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
		blocksize = cpti->mode2 ? 2332 : 2048;
	  }
	  else{
		blocksize = 2352;
	  }
		  /* 1ɓ]łubN */
	  if(REALDRIVE(src)){
		len = src->bufsize / (blocksize==2048 ? 2048 : 2352);
	  }
	  else if(REALDRIVE(&dst[0])){
		len = dst->bufsize / (blocksize==2048 ? 2048 : 2352);
	  }
	  else{
		len = 16;
	  }
	}
	if(blocksize*len >= 0x10000){
		  /* wnaspi32.dll ł 64KB ]łȂ炵̂ */
	  len = 0xffff/blocksize;
	}

		/* L^AhX */
	lba = Get4bytes(cpti->trackinfo.track_start);

	for(index=0; index<num_dst; index++){
	  ret = OpenTrack(&dst[index], discinfo, track_num);
	  if(ret!=RET_OK)
		return ret;
	}

	/* ʕ\ */
	sprintf(msgbuf, "gbN%d", track_num);
	UIMeter2Initialize(msgbuf);
	if(src->type==CMDDRVTYPE_NET){
	  NAUIMeter2Initialize(&src->u.net, msgbuf);
	}

	if(Get4bytes(cpti->trackinfo.free_blocks) > 0){
	  for(index=0; index<num_dst; index++){
		ret = ReserveTrack(&dst[index],
						   Get4bytes(cpti->trackinfo.track_size));
		if(ret!=RET_OK)
		  return ret;
	  }
	}

	ret = WriteLoop(src, dst, num_dst, lba, blocks, len, blocksize,
					vp_track, discinfo->last_addr, FALSE, FALSE);
	if(ret!=RET_OK){
		  /* G[̏ꍇ́ASyncCacheďI */
	  for(index=0; index<num_dst; index++){
		SyncCache(&dst[index]);
	  }
	}
	else{
	  ret = CloseTrack(dst, num_dst, discinfo, track_num);
	}

	return ret;
}

static int CreateCueSheet(CMDDRIVE *drive, CPDISCINFO *discinfo, WORD track_num,
						  struct _CUESHEET **cs_ret)
{
	struct _CUESHEET *cs = NULL, *csp;
	int cur_cs = 0;
	int num_cs = 0;
	DWORD gap_len;
	WORD sess_num = 0;
	DWORD nwa;
	CPTRACKINFO *cpti=NULL, *lcpti=NULL;
	struct _TRACKINFO *ti;
	int ret;
	BOOL gap_2part;
	BOOL cdtext=FALSE;
	int retry;	/* CD-TEXTT|[ghCüׂ̃gC */

	if(track_num==1 && discinfo->cdtext_size>0)
		cdtext = TRUE;

	for(retry=0; retry<2; retry++){
		cur_cs = 0;
		num_cs = 0;
		sess_num = 0;
		/* NWA擾 */
		if(!REALDRIVE(drive)){
			nwa = 0;
		}
		else{
			ret = SendReadTrackInfo(drive, track_num);
			if(ret!=RET_OK){
				DispCommandError(drive);
				return ret;
			}
			ti = (struct _TRACKINFO *)drive->data_buf;
			nwa = Get4bytes(ti->next_writable_addr);
		}
		nwa -= 150;

		if(strlen(discinfo->media_catalog_number)!=0){
			/* Media Catalog Number */
			num_cs += 2;
			cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
			if(cs==NULL)
				return RET_MEMERR;
			csp = &cs[cur_cs++];
			csp->ctladr = CSADR_MCN;
			memcpy(&csp->tno, discinfo->media_catalog_number, 7);
			csp = &cs[cur_cs++];
			csp->ctladr = CSADR_MCN;
			memcpy(&csp->tno, discinfo->media_catalog_number+7, 7);
		}

		cpti = NULL;
		lcpti = NULL;
		ret = RET_OK;
		for( ; track_num <= discinfo->tracks; track_num++){
			lcpti = cpti;
			cpti = &discinfo->trackinfo[track_num-1];
			gap_len = 0;
			if(sess_num==0){
				sess_num = (WORD)cpti->trackinfo.session_number_msb<<8 |
							(WORD)cpti->trackinfo.session_number_lsb;
				/* Lead-in */
				num_cs++;
				cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
				csp->ctladr |= CSADR_NORMAL;
				csp->tno = 0;
				csp->index = 0;
				csp->dataform = cdtext ? 0x41 : 0x01;
				csp->scms = 0;
				LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
				gap_len = 150;
			}
			else if(sess_num != ((WORD)cpti->trackinfo.session_number_msb<<8 |
								(WORD)cpti->trackinfo.session_number_lsb)){
				cpti = lcpti;
				break;
			}

			if(strlen(cpti->isrc)!=0){
				/* ISRC */
				num_cs += 2;
				cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = CSADR_ISRC;
				csp->tno = (BYTE)track_num;
				memcpy(&csp->index, cpti->isrc, 6);
				csp = &cs[cur_cs++];
				csp->ctladr = CSADR_ISRC;
				csp->tno = (BYTE)track_num;
				memcpy(&csp->index, cpti->isrc+6, 6);
			}
			gap_2part = FALSE;
			if(gap_len==0){
#if 1	/* ̕ǂ? */
				if(lcpti!=NULL){
					gap_len = Get4bytes(cpti->trackinfo.track_start) -
								(Get4bytes(lcpti->trackinfo.track_start) +
								 Get4bytes(lcpti->trackinfo.track_size));
					if(IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
						/* DATA */
						if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
							lcpti->mode2 != cpti->mode2){
							/* 2part */
							gap_2part = TRUE;
						}
					}
					else{
						/* AUDIO */
						if(IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode)){
							/* ODATȀꍇ? */
							gap_2part = TRUE;
						}
					}
				}
#else
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode)){
					/* AUDIO */
					gap_len = cpti->pause_len;
				}
				else if(lcpti!=NULL){
					/* DATA  2nd ȍ~ */
					gap_len = 150;
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ||
						lcpti->mode2 != cpti->mode2){
						/* 2part */
						gap_len = 75+150;
						gap_2part = TRUE;
					}
				}
#endif
			}
			nwa = Get4bytes(cpti->trackinfo.track_start) - gap_len;
			if(gap_len>0){
				/* pre-gap */
				if(gap_2part && gap_len>150){
					num_cs++;
					cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
					if(cs==NULL)
						return RET_MEMERR;
					csp = &cs[cur_cs++];
					csp->ctladr = IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
					csp->ctladr |= CSADR_NORMAL;
					csp->tno = (BYTE)track_num;
					csp->index = 0;
					if(!IS_TRACKMODE_DATA(lcpti->trackinfo.track_mode))
						csp->dataform = 0x01;
					else
						csp->dataform = lcpti->mode2 ? 0x24 : 0x14;
					csp->scms = lcpti->trackinfo.copy ? 0x80 : 0;
					LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
					nwa += (gap_len-150);
					gap_len = 150;
				}
				num_cs++;
				cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
				if(cs==NULL)
					return RET_MEMERR;
				csp = &cs[cur_cs++];
				csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
				csp->ctladr |= CSADR_NORMAL;
				csp->tno = (BYTE)track_num;
				csp->index = 0;
				if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
					csp->dataform = 0x01;
				else
					csp->dataform = cpti->mode2 ? 0x24 : 0x14;
				csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
				LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
				nwa += gap_len;
			}
			/* Audio/Data */
			num_cs++;
			cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
			if(cs==NULL)
				return RET_MEMERR;
			csp = &cs[cur_cs++];
			csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
			csp->ctladr |= CSADR_NORMAL;
			csp->tno = (BYTE)track_num;
			csp->index = 1;
			if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
				csp->dataform = 0x00;
			else
				csp->dataform = cpti->mode2 ? 0x20 : 0x10;
			csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
			LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);
			nwa += Get4bytes(cpti->trackinfo.track_size);
		}
		/* Lead-out */
		num_cs++;
		cs = (struct _CUESHEET *)realloc(cs, num_cs * sizeof(struct _CUESHEET));
		if(cs==NULL)
			return RET_MEMERR;
		csp = &cs[cur_cs++];
		csp->ctladr = IS_TRACKMODE_DATA(cpti->trackinfo.track_mode) ? CSCTL_DATA : CSCTL_AUDIO;
		csp->ctladr |= CSADR_NORMAL;
		csp->tno = 0xAA;
		csp->index = 1;
		if(!IS_TRACKMODE_DATA(cpti->trackinfo.track_mode))
			csp->dataform = 0x01;
		else
			csp->dataform = cpti->mode2 ? 0x24 : 0x14;
		csp->scms = cpti->trackinfo.copy ? 0x80 : 0;
		LBA2MSF(nwa, &csp->min, &csp->sec, &csp->frame);

		*cs_ret = cs;

		if(REALDRIVE(drive)){
			ret = SendSendCueSheet(drive, cs, num_cs*sizeof(struct _CUESHEET));
			if(ret!=RET_OK){
				if(!retry && cdtext){
					cdtext = FALSE;	/* CD-TEXT 𖳌ɂăgC */
				}
				else{
					DispCommandError(drive);
					*cs_ret = NULL;
					free(cs);
					return ret;
				}
			}
		}
		if(ret==RET_OK)
			break;
	}

	return RET_OK;
}

static int CopySession(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
					   CPDISCINFO *discinfo,
					   WORD *track_num_ret)
{
	int ret=RET_OK;
	WORD track_num = *track_num_ret;
	struct _CUESHEET *cs=NULL, *csp;
	BOOL done=FALSE;
	DWORD lba, blocks;
	DWORD translen, blocksize;
	char msgbuf[80];
	int index;
	BOOL leadin=FALSE;

	for(index=0; index<num_dst; index++){
	  if(cs!=NULL){
		free(cs);
		cs=NULL;
	  }
	  ret = SetWriteParametersPage(&dst[index], discinfo, track_num, TRUE);
	  if(ret!=RET_OK)
		return ret;

	  ret = CreateCueSheet(&dst[index], discinfo, track_num, &cs);
	  if(ret!=RET_OK)
		return ret;
	}

	for(csp=cs; !done; csp++){
	  if((csp->ctladr & 0x0f)!=CSADR_NORMAL)
		continue;
	  if(csp->tno==0xaa){
		done=TRUE;
		continue;
	  }
	  if(csp->dataform==0x24 || csp->dataform==0x14 || csp->dataform==0x01){
			/* f[^]iV */
		if(csp->dataform==0x01){
		  if(REALDRIVE(dst)){
			UIDispInfo("L^");
			leadin = TRUE;
		  }
		}
		continue;
	  }
	  if(csp->dataform==0x41){
			/* CD-TEXT */
		if(csp->dataform==0x01){
		  UIDispInfo("CD-TEXTL^");
		}
		ret = WriteCDText(dst, num_dst, discinfo);
		if(ret!=RET_OK)
		  break;
		continue;
	  }
	  lba = MSF2LBA(csp->min, csp->sec, csp->frame, FALSE);
#if 1
	  blocks = Get4bytes(discinfo->trackinfo[csp->tno-1].trackinfo.track_size);
#else	/* CueSheet狁߂ꍇ́AISRC𖳎ėLMSFKv */
	  blocks = MSF2LBA((csp+1)->min, (csp+1)->sec, (csp+1)->frame, FALSE) - lba;
#endif
	  switch(csp->dataform){
	  case 0x20:
		blocksize = 2336;
		break;
	  case 0x10:
		blocksize = 2048;
		break;
	  default:
		blocksize = 2352;
	  }
	  if(REALDRIVE(src))
		translen = src->bufsize / (blocksize==2048 ? 2048 : 2352);
	  else
		translen = dst[0].bufsize / (blocksize==2048 ? 2048 : 2352);
	  if(blocksize*translen >= 0x10000){
			/* wnaspi32.dll ł 64KB ]łȂ炵̂ */
		translen = 0xffff / (blocksize==2048 ? 2048 : 2352);
	  }

		  /* ʕ\ */
	  sprintf(msgbuf, "gbN%d", csp->tno);
	  UIMeter2Initialize(msgbuf);
	  if(src->type==CMDDRVTYPE_NET){
		NAUIMeter2Initialize(&src->u.net, msgbuf);
	  }

	  ret = WriteLoop(src, dst, num_dst,
					  lba, blocks, translen, blocksize,
					  FALSE, discinfo->last_addr, TRUE, leadin);
	  if(ret!=RET_OK){
		break;
	  }
	  *track_num_ret = csp->tno;
	  leadin = FALSE;
	}

	for(index=0; index<num_dst; index++){
	  SyncCache(&dst[index]);
	}

	(*track_num_ret)++;

	free(cs);
	return ret;
}


static int CopyDAO(CMDDRIVE *src, CMDDRIVE *dst, int num_dst,
				   CPDISCINFO *discinfo)
{
	int disc_type;
	int ret;
	int index;

	if(!REALDRIVE(src) && !REALDRIVE(&dst[0]))
		return RET_NG;

	if(REALDRIVE(src))
		disc_type = src->disc_type;
	else
		disc_type = dst[0].disc_type;

	if(DT_CD_FAMILY(disc_type)){
		  /* ͂₱ɂ͗Ȃ */
	  UIDispMessage("cOȂACD  DAO ͂ł܂B",
					UIDMT_ERROR);
	  return RET_ABORT;
	}
	else{
		  /* DVD-R/-RW */
	  for(index=0; index<num_dst; index++){
		ret = SetWriteParametersPage(&dst[index], discinfo, 1,
									 GetOption()->dao);
		if(ret!=RET_OK)
		  return ret;
		ret = ReserveTrack(&dst[index],
						   Get4bytes(discinfo->trackinfo[0].trackinfo.track_size));
		if(ret!=RET_OK)
		  return ret;
	  }

	  ret = CopyTrack(src, dst, num_dst, discinfo, 1);
	  if(ret!=RET_OK)
		return ret;
	}

	return RET_OK;
}



static int ExecCopy(CMDDRIVE *src, CMDDRIVE *dst, int num_dst)
{
	int ret;
	CPDISCINFO discinfo;
	DWORD free_size;
	WORD track_num;
	WORD sess_num;
	CPTRACKINFO *cpti;
	BOOL sao=FALSE;
	int index;

	for(index=0; index<num_dst; index++){
		  /* L^悤ƂfBXNBLANKłȂBLANKs */
	  ret = Blanking(&dst[index]);
	  if(ret!=RET_OK)
		return ret;
		  /* L^fBA DVD+RW ŁAtH[}bgȂtH[}bgJn */
	  ret = Formatting(&dst[index]);
	  if(ret!=RET_OK)
		return ret;
	}
	
		/* \[XfBXN̏𓾂(ReadDiscInfo. & ReadTrackInfo.) */
	ret = GetDiscInformation(src, &discinfo);
	if(ret!=RET_OK)
	  return ret;

	if(discinfo.last_addr==0){
	  UIDispMessage("ʌfBXN̓uNłBʂł܂B",
					UIDMT_INFORMATION);
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return RET_ABORT;
	}

		/* L^zhCuȂAC[Wt@CɃfBXNo */
	if(num_dst==1){
	  ret = SetDiscInformation(&dst[0], &discinfo);
	  if(ret!=RET_OK){
		free(discinfo.trackinfo);
		free(discinfo.cdtext);
		return ret;
	  }
	}

	for(index=0; index<num_dst; index++){
	  if(REALDRIVE(&dst[index])){
		if(dst[index].disc_type!=DT_DVDRWO &&
		   dst[index].disc_type!=DT_DVDRWS &&
		   dst[index].disc_type!=DT_DVDPRW){
			  /* DVD-RW/+RW łȂꍇAeʃ`FbN */
			  /* WriteParametersPageݒɂăt[ubN
				 eĂ܂ */
		  ret = SetWriteParametersPage(&dst[index], &discinfo, 1,
									   !discinfo.trackinfo[0].tao );
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }

			  /* L^fBXN̋󂫗eʂ𓾂 */
		  ret = GetWritableSize(&dst[index], &free_size);
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }
		  if(free_size < discinfo.last_addr){
			ret = UIDispMessage("L^fBXNeʂsĂ܂B\nđs܂H",
								UIDMT_QUESTION);
			if(ret==UIDMRET_CANCEL){
			  free(discinfo.trackinfo);
			  free(discinfo.cdtext);
			  return RET_ABORT;
			}
		  }
		}

		if(dst[0].disc_type!=DT_DVDR &&
		   dst[0].disc_type!=DT_DVDRWO &&
		   dst[0].disc_type!=DT_DVDRWS){
			  /* DVD-R/-RW ȊO DAO  */
		  GetOption()->dao = FALSE;
		}
	  }
	}

		/* Ǎxݒ */
	ret = SetSpeed(src, GetOption()->read_speed, 0);
	if(ret!=RET_OK){
	  free(discinfo.trackinfo);
	  free(discinfo.cdtext);
	  return ret;
	}

	for(index=0; index<num_dst; index++){
		  /* L^xݒ */
	  ret = SetSpeed(&dst[index],
					 GetOption()->write_speed,
					 GetOption()->write_speed);
	  if(ret!=RET_OK){
		free(discinfo.trackinfo);
		free(discinfo.cdtext);
		return ret;
	  }
	}

	if(REALDRIVE(src)){
	  UIMeter1Initialize("S");
	  if(src->type==CMDDRVTYPE_NET){
		NAUIMeter1Initialize(&src->u.net, "S");
	  }
	}

	if(GetOption()->dao){
	  ret = CopyDAO(src, dst, num_dst, &discinfo);
	  if(ret!=RET_OK){
		free(discinfo.trackinfo);
		free(discinfo.cdtext);
		return ret;
	  }
	}
	else{
	  track_num=1;
	  for(sess_num=1; sess_num<=discinfo.sessions; sess_num++){
		if(track_num > discinfo.tracks)
		  break;
		if(track_num==discinfo.tracks &&
		   discinfo.trackinfo[track_num-1].trackinfo.blank){
			  /* ŏIgbNBLANKȂ牽I */
		  break;
		}
		if(discinfo.trackinfo[track_num-1].tao==FALSE){
			  /* SAOL^ */
		  sao = TRUE;
		  ret = CopySession(src, dst, num_dst, &discinfo, &track_num);
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }
		  continue;
		}

			/* TAOL^ */
		sao = FALSE;
		for(; track_num <= discinfo.tracks; track_num++){
		  cpti = &discinfo.trackinfo[track_num-1];
		  if(sess_num !=
			 ((WORD)cpti->trackinfo.session_number_msb<<8 |
			  (WORD)cpti->trackinfo.session_number_lsb)){
				/* ̃ZbV͏I */
			ret = CloseSession(dst, num_dst);
			if(ret!=RET_OK){
			  free(discinfo.trackinfo);
			  free(discinfo.cdtext);
			  return ret;
			}
			break;
		  }
		  if(track_num==discinfo.tracks &&
			 discinfo.trackinfo[track_num-1].trackinfo.blank){
				/* ŏIgbNBLANKȂ牽I */
			break;;
		  }

		  ret = CopyTrack(src, dst, num_dst, &discinfo, track_num);
		  if(ret!=RET_OK){
			free(discinfo.trackinfo);
			free(discinfo.cdtext);
			return ret;
		  }
		}
	  }

	  if(discinfo.last_sess_stat==SESSSTAT_COMPLETE && sao==FALSE){
		ret = CloseSession(dst, num_dst);
		if(ret!=RET_OK){
		  free(discinfo.trackinfo);
		  free(discinfo.cdtext);
		  return ret;
		}
	  }
	}

	free(discinfo.trackinfo);
	free(discinfo.cdtext);

	return RET_OK;
}

static int OpenTempImageDevice(CMDDRIVE *drive, BOOL reader,
							   BYTE *data_buf, int bufsize, const char *tmpfile)
{
  int ret;

  ret = InitializeCmdDrive(drive, 0, 50, CMDDRVTYPE_IMAGE);
  if(ret!=RET_OK){
	return ret;
  }
  SetDriveBuffer(drive, data_buf, bufsize);
  ret = OpenImage(&drive->u.image, tmpfile, reader);
  if(ret!=RET_OK){
	return ret;
  }

  return RET_OK;
}

static int OpenISOImageDevice(CMDDRIVE *drive, BOOL reader,
							  BYTE *data_buf, int bufsize)
{
  char tmpfile[_MAX_PATH];
  int ret;

  if(reader){
	tmpfile[0] = '\0';
  }
  else{
	strcpy(tmpfile, "image.iso");
  }
  
  ret = UIFileDialog(reader, tmpfile, sizeof(tmpfile), "iso");
  if(ret!=UIDMRET_OK){
	return RET_ABORT;
  }
  ret = InitializeCmdDrive(drive, 0, 50, CMDDRVTYPE_ISO);
  if(ret!=RET_OK){
	return ret;
  }
  SetDriveBuffer(drive, data_buf, bufsize);
  ret = OpenImage(&drive->u.image, tmpfile, reader);
  if(ret!=RET_OK){
	return ret;
  }

  return RET_OK;
}

static BOOL DispSocketError(CMDDRIVE *drive, int ret_value)
{
  if(ret_value==RET_SOCKET){
	const char *message = NAGetErrorMessage(&drive->u.net);
	if(message != NULL){
	  char *net_err = (char *)malloc(256);
	  if(net_err != NULL){
		sprintf(net_err, "lbg[NG[ %ld : ", drive->u.net.error_code);
		net_err = (char *)realloc(net_err, strlen(net_err)+strlen(message)+1);
		if(net_err != NULL){
		  strcat(net_err, message);
		  UIDispMessage(message, UIDMT_ERROR);
		  free(net_err);
		}
	  }
	  return TRUE;
	}
  }
  return FALSE;
}

static int OpenNetDevice(CMDDRIVE *drive, BOOL server,
						 BYTE *data_buf, int bufsize)
{
  int ret;
  char remote_host[128];
  int port_number;

  ret = UINetDialog(server, remote_host, sizeof(remote_host), &port_number);
  if(ret!=UIDMRET_OK){
	return RET_ABORT;
  }
  ret = InitializeCmdDrive(drive, 0, 50, CMDDRVTYPE_NET);
  if(ret!=RET_OK){
	return ret;
  }
  SetDriveBuffer(drive, data_buf, bufsize);
  if(server){
		/* T[o[h */
	drive->u.net.u.server.port = (WORD)port_number;
	ret = NACreateServer(&drive->u.net);
	if(ret!=RET_OK){
	  DispSocketError(drive, ret);
	  return ret;
	}
	UIClearAbort();
	while(1){
	  if(UICheckAbort()){
		ret = RET_ABORT;
		break;
	  }
	  ret = NAWaitConnect(&drive->u.net, 1000);
	  if(ret==RET_OK){
		break;
	  }
	  if(ret!=RET_TIMEOUT){
		break;
	  }
	}
	if(ret!=RET_OK){
	  DispSocketError(drive, ret);
	  FreeCmdDrive(drive);
	  return ret;
	}
  }
  else{
		/* NCAg[h */
	drive->u.net.remote_host = strdup(remote_host);
	drive->u.net.u.client.remote_port = (WORD)port_number;
	ret = NAConnect(&drive->u.net);
	if(ret!=RET_OK){
	  DispSocketError(drive, ret);
	  FreeCmdDrive(drive);
	  return ret;
	}

	ret = GetDiscType(drive, &drive->disc_type, TRUE);
	if(ret!=RET_OK){
	  if(ret!=RET_ABORT){
		UIDispMessage("fBXN^Cv擾Ɏs܂B", UIDMT_ERROR);
	  }
	  FreeCmdDrive(drive);
	  return ret;
	}
	ret = SendPreventAllow(drive, 1);
	if(ret!=RET_OK){
	  DispCommandError(drive);
	  FreeCmdDrive(drive);
	  return ret;
	}
  }
  
  return RET_OK;
}
						
void PostProcess(int retcode, CMDDRIVE *src, CMDDRIVE *dstp, int num_dst)
{
  int ret;
  int index;
  BOOL socket_error = FALSE;

  if(retcode==RET_SOCKET){
	if(src->type==CMDDRVTYPE_NET)
	  socket_error = DispSocketError(src, retcode);
	else
	  socket_error = DispSocketError(dstp, retcode);
  }

  if(src->type == CMDDRVTYPE_NET){
	if(retcode==RET_OK){
	  NASendComplete(&src->u.net);
	}
	else if(retcode==RET_ABORT){
	  NASendAbort(&src->u.net);
	}
	FreeSOCKCB(&src->u.net);
  }
  if(dstp->type == CMDDRVTYPE_NET){
	if(retcode==RET_OK){
	  NASendComplete(&dstp->u.net);
	}
	else if(retcode==RET_ABORT){
	  NASendAbort(&dstp->u.net);
	}
	FreeSOCKCB(&dstp->u.net);
  }
  
  if(socket_error==FALSE){
	if(retcode==RET_ABORT){
	  UIDispMessage("f܂B", UIDMT_INFORMATION);
	}
	else if(retcode==RET_OK){
	  ret = UIDispMessage("ɏI܂Bro܂?",
						  UIDMT_QUESTION);
	  if(ret==UIDMRET_OK){
		for(index=0; index<num_dst; index++){
		  OpenTray(&dstp[index]);
		}
		OpenTray(src);
	  }
	}
	else{
	  ret = UIDispMessage("G[܂BR}hO𐶐܂?",
						  UIDMT_QUESTION);
	  if(ret==UIDMRET_OK){
		CreateLog(src, dstp, num_dst);
	  }
	}
  }
}




int CopyDisc(DRIVEID *reader, DRIVEID *writer, int num_writer)
{
	BOOL bSameDrive=FALSE;
	BOOL bDVD=FALSE;
	CMDDRIVE src, dst, virtual_drv, *dstp=NULL;
	int ret;
	OPTIONS *option;
	int index;
	int num_writable_drive=0;
	int disc_type;
	BYTE *data_buf;
	int bufsize;
	char tmpfile[_MAX_PATH];

	memset(&src, 0, sizeof(src));
	memset(&dst, 0, sizeof(dst));
	memset(&virtual_drv, 0, sizeof(virtual_drv));

	UICheckAbort();
	
	dstp = (CMDDRIVE *)malloc(num_writer*sizeof(CMDDRIVE));
	if(dstp==NULL){
	  UIDispMessage("mۂɎs܂B", UIDMT_ERROR);
	  return RET_NG;
	}
	memset(dstp, 0, num_writer*sizeof(CMDDRIVE));
	bufsize = 0x10000;
	data_buf = (BYTE *)malloc(bufsize);
	if(data_buf==NULL){
	  UIDispMessage("mۂɎs܂B", UIDMT_ERROR);
	  free(dstp);
	  return RET_NG;
	}
	
	if(reader->hid != HID_VIRTUAL && writer->hid != HID_VIRTUAL){
	  if(reader->hid == writer->hid &&
		 reader->tid == writer->tid){
		bSameDrive = TRUE;
	  }
	}

		/* ǎ摕ũI[v */
	if(reader->hid == HID_VIRTUAL){
	  if(reader->tid == CMDDRVTYPE_ISO){
			/* ISOC[W */
		ret = OpenISOImageDevice(&src, TRUE, data_buf, bufsize);
		if(ret!=RET_OK){
		  free(dstp);
		  free(data_buf);
		  return ret;
		}
	  }
	  else if(reader->tid == CMDDRVTYPE_NET){
			/* lbg[Nڑꂽu */
		ret = OpenNetDevice(&src, FALSE, data_buf, bufsize);
		if(ret!=RET_OK){
		  free(dstp);
		  free(data_buf);
		  return ret;
		}
	  }
	  else{
		free(dstp);
		free(data_buf);
		return RET_NG;
	  }
	}
	else{
		  /* ʏ̃foCX */
	  ret = OpenDevice(&src, reader, TRUE, TRUE, data_buf, bufsize);
	  if(ret!=RET_OK){
		free(dstp);
		free(data_buf);
		return ret;
	  }
	}
	disc_type = src.disc_type;
	
	if(bSameDrive){
	  ret = SetOption(&src, &src, src.disc_type);
	  if(ret!=RET_OK){
		CloseDevice(&src);
		free(dstp);
		free(data_buf);
		return ret;
	  }
	  num_writable_drive = 1;
	}
	else{
	  if(writer->hid == HID_VIRTUAL){
		if(writer->tid == CMDDRVTYPE_ISO){
			  /* ISOC[W */
		  ret = OpenISOImageDevice(&dst, FALSE, data_buf, bufsize);
		  if(ret!=RET_OK){
			CloseDevice(&src);
			free(dstp);
			free(data_buf);
			return ret;
		  }
		}
		else if(writer->tid == CMDDRVTYPE_NET){
			  /* lbg[Nڑꂽu */
		  ret = OpenNetDevice(&dst, TRUE, data_buf, bufsize);
		  if(ret!=RET_OK){
			CloseDevice(&src);
			free(dstp);
			free(data_buf);
			return ret;
		  }
			  /* T[o[hҋ@ */
		  ret = WaitingNetCmd(&dst, &src);
		  PostProcess(ret, &src, &dst, num_writable_drive);
		  CloseDevice(&src);
		  CloseDevice(&dst);
		  free(dstp);
		  free(data_buf);
		  return ret;
		}
		else{
		  CloseDevice(&src);
		  free(dstp);
		  free(data_buf);
		  return RET_NG;
		}
		memcpy(&dstp[0], &dst, sizeof(CMDDRIVE));
		num_writable_drive = 1;
	  }
	  else{
			/* ʏ̃foCX */
		for(index=0; index<num_writer; index++){
		  memset(&dst, 0, sizeof(dst));
		  ret = OpenDevice(&dst, &writer[index], FALSE,
						   (num_writer==1), data_buf, bufsize);
		  if(ret!=RET_OK){
			continue;
		  }
		  memcpy(&dstp[num_writable_drive], &dst, sizeof(CMDDRIVE));
		  num_writable_drive++;
		}
		if(num_writable_drive==0){
		  CloseDevice(&src);
		  free(dstp);
		  free(data_buf);
		  return RET_NG;
		}
	  }

	  if(disc_type==DT_UNKNOWN){
		disc_type = dstp[0].disc_type;
	  }
	  
	  ret = SetOption(&src, &dstp[0], disc_type);
	  if(ret!=RET_OK){
		CloseDevice(&src);
		for(index=0; index<num_writable_drive; index++){
		  CloseDevice(&dstp[index]);
		}
		free(dstp);
		free(data_buf);
		return ret;
	  }
	}

		/* ꎞt@C */
	strcpy(tmpfile, GetOption()->temppath);
	if(strlen(tmpfile)+1+7+1>=sizeof(tmpfile)){
	  return RET_NG;
	}
#ifdef WIN32
	if(strlen(tmpfile)>0){
	  if(tmpfile[strlen(tmpfile)-1]=='\\')
		strcat(tmpfile, "tmp.img");
	  else
		strcat(tmpfile, "\\tmp.img");
	}
	else
	  strcat(tmpfile, "\\tmp.img");
#else
	strcat(tmpfile, "/tmp.img");
#endif

	option = GetOption();
	if(option->on_the_fly){
		  /* On-The-Fly */
	  bDVD = DT_DVD_FAMILY(disc_type);
	  for(index=0; index<num_writable_drive; index++){
		if(!REALDRIVE(&dstp[index])){
		  dstp[index].disc_type = disc_type;
		}
		else if((bDVD != DT_DVD_FAMILY(dstp[index].disc_type)) &&
				REALDRIVE(&src)){
		  UIDispMessage("CD  DVD ADVD  CD ɂ̓Rs[ł܂B",
						UIDMT_ERROR);
		  CloseDevice(&src);
		  for(index=0; index<num_writer; index++){
			CloseDevice(&dstp[index]);
		  }
		  free(dstp);
		  free(data_buf);
		  return RET_NG;
		}
	  }
	  ret = ExecCopy(&src, dstp, num_writable_drive);
	  PostProcess(ret, &src, dstp, num_writable_drive);
	  CloseDevice(&src);
	  for(index=0; index<num_writable_drive; index++){
		CloseDevice(&dstp[index]);
	  }
	  free(dstp);
	  free(data_buf);
	}
	else{
		  /* ꎞt@CoR */
	  ret = OpenTempImageDevice(&virtual_drv, FALSE, data_buf, bufsize, tmpfile);
	  if(ret!=RET_OK){
		CloseDevice(&src);
		if(!bSameDrive){
		  for(index=0; index<num_writable_drive; index++){
			CloseDevice(&dstp[index]);
		  }
		}
		free(dstp);
		free(data_buf);
		return ret;
	  }

	  virtual_drv.disc_type = src.disc_type;

	  ret = ExecCopy(&src, &virtual_drv, 1);	/* DISC => Image file */
	  if(ret==RET_OK){
		OpenTray(&src);
		if(src.type == CMDDRVTYPE_NET){
		  NASendComplete(&src.u.net);
		}
	  }
	  else{
		PostProcess(ret, &src, dstp, num_writable_drive);
	  }
	  CloseDevice(&src);
	  CloseDevice(&virtual_drv);
	  if(ret!=RET_OK){
		RemoveImageFile(tmpfile);
		if(!bSameDrive){
		  for(index=0; index<num_writable_drive; index++){
			CloseDevice(&dstp[index]);
		  }
		}
		free(dstp);
		free(data_buf);
		return ret;
	  }

	  ret = OpenTempImageDevice(&virtual_drv, TRUE, data_buf, bufsize, tmpfile);
	  if(ret!=RET_OK){
		if(!bSameDrive){
		  for(index=0; index<num_writable_drive; index++){
		    CloseDevice(&dstp[index]);
		  }
		}
		free(dstp);
		free(data_buf);
		return ret;
	  }
	  if(bSameDrive){
	    num_writable_drive=1;
			/* fBXN}҂ */
	    ret = OpenDevice(&dstp[0], writer, FALSE, TRUE, data_buf, bufsize);
	    if(ret!=RET_OK){
		  PostProcess(ret, &src, dstp, num_writable_drive);
	      CloseDevice(&virtual_drv);
		  RemoveImageFile(tmpfile);
		  if(!bSameDrive){
			for(index=0; index<num_writable_drive; index++){
			  CloseDevice(&dstp[index]);
			}
		  }
	      free(dstp);
		  free(data_buf);
	      return ret;
	    }
	  }

		  /* Image file => DISC */
	  ret = ExecCopy(&virtual_drv, dstp, num_writable_drive);
	  PostProcess(ret, &src, dstp, num_writable_drive);
	  CloseDevice(&virtual_drv);
	  RemoveImageFile(tmpfile);
	  if(!bSameDrive){
		for(index=0; index<num_writable_drive; index++){
		  CloseDevice(&dstp[index]);
		}
	  }
	  free(dstp);
	  free(data_buf);
	}

	return ret;
}

