#import "MainWindowControl.h"
#import "SettingDlgControl.h"
#import "SettingNetControl.h"
#import "ui.h"
#import "scan.h"
#import "cmd.h"
#import "copydisc.h"
#import "cmdlog.h"

@implementation MainWindowControl

static SCAN_t *g_Readers=NULL;
static SCAN_t *g_Writers=NULL;
static BOOL g_bRunningCopy=FALSE;
static int g_AllWritableDrives=-1;
static int g_ReaderISO=-1;
static int g_WriterISO=-1;
static int g_ReaderNet=-1;
static int g_WriterNet=-1;

- (IBAction)exitProgram:(id)sender
{
	[NSApp terminate : self];
}

- (IBAction)scanDrive:(id)sender
{
	SCAN_t *scan;
	id combo;
	int i, j;

	g_Readers = ScanDrive(FALSE);
	g_Writers = ScanDrive(TRUE);

	for(i=0; i<2; i++){
		scan = i==0 ? g_Readers : g_Writers;
		combo = i==0 ? readerCombo : writerCombo;
		[combo removeAllItems];
		for(j=0; strlen(scan[j].inqdata)!=0; j++){
			// ComboBox̏ꍇ
			//[combo addItemWithObjectValue : [NSString stringWithCString : scan[j].inqdata]];
			// PopupButton ̏ꍇ
			[combo addItemWithTitle : [NSString stringWithCString : scan[j].inqdata]];
		}
	}
	
	g_AllWritableDrives = [writerCombo numberOfItems];
	[writerCombo addItemWithTitle: [NSString stringWithCString : "L^fBXN}ς݂̑Su"]];

	g_ReaderISO = [readerCombo numberOfItems];
	[readerCombo addItemWithTitle: [NSString stringWithCString : "ISOC[Wt@C"]];
	g_WriterISO = [writerCombo numberOfItems];
	[writerCombo addItemWithTitle: [NSString stringWithCString : "ISOC[Wt@C"]];
	
	g_ReaderNet = [readerCombo numberOfItems];
	[readerCombo addItemWithTitle: [NSString stringWithCString : "lbg[N"]];
	g_WriterNet = [writerCombo numberOfItems];
	[writerCombo addItemWithTitle: [NSString stringWithCString : "lbg[N"]];
}

- (IBAction)startCopy:(id)sender
{

	if(g_bRunningCopy){
		UISetAbort();
		[buttonStartCopy setEnabled : NO];
		return;
	}
	UIClearAbort();
	g_bRunningCopy = TRUE;
	[buttonQuit setEnabled : NO];
	[readerCombo setEnabled : NO];
	[writerCombo setEnabled : NO];
	[buttonStartCopy setTitle : [NSString stringWithCString : "f"]];
#ifdef USE_THREAD
	[NSThread detachNewThreadSelector: @selector(startCopyThread:)
								toTarget: self
											 withObject: nil];
#else
	[self startCopyThread: nil];
#endif
	g_bRunningCopy = FALSE;
}

- (void)startCopyThread:(id)object
{
	NSAutoreleasePool *ap = [[NSAutoreleasePool alloc] init];
	DRIVEID reader, *writerp=NULL;
	int sel_reader, sel_writer;
	int ret;
	int writer_num = 1;
	int index;
	
	/* IhCu擾 */
	sel_reader = [readerCombo indexOfSelectedItem];
	sel_writer = [writerCombo indexOfSelectedItem];
	
	/* upm */
	writerp = (DRIVEID *)malloc(sizeof(DRIVEID));
	if(writerp==NULL){
		[self MessageBoxDlg : "ȕɎs܂B(mۃG[)"
					  title : NULL
					  flags : MBF_TYPEOK|MBF_ICONSTOP];
		[buttonStartCopy setEnabled : YES];
		[buttonQuit setEnabled : YES];
		[readerCombo setEnabled : YES];
		[writerCombo setEnabled : YES];
		[buttonStartCopy setTitle : [NSString stringWithCString : "ʊJn"]];
		[ap release];
		return;
	}
	
	/* uݒ */
	if(sel_writer == g_AllWritableDrives){
		writer_num = 0;
		for(index=0; strlen(g_Writers[index].inqdata)!=0; index++){
			if(g_Readers[sel_reader].hid == g_Writers[index].hid &&
			   g_Readers[sel_reader].tid == g_Writers[index].tid){
				/* ǎ摕u͖ */
				continue;
			}
			writerp = (DRIVEID *)realloc(writerp, (writer_num+1)*sizeof(DRIVEID));
			if(writerp==NULL){
				[self MessageBoxDlg : "ȕɎs܂B(mۃG[)"
							  title : NULL
							  flags : MBF_TYPEOK|MBF_ICONSTOP];
				[buttonStartCopy setEnabled : YES];
				[buttonQuit setEnabled : YES];
				[readerCombo setEnabled : YES];
				[writerCombo setEnabled : YES];
				[buttonStartCopy setTitle : [NSString stringWithCString : "ʊJn"]];
				[ap release];
				return;
			}
			writerp[writer_num].hid = g_Writers[index].hid;
			writerp[writer_num].tid = g_Writers[index].tid;
			writer_num++;
		}
	}
	else if(sel_writer == g_WriterISO){
		writerp->hid = HID_VIRTUAL;
		writerp->tid = CMDDRVTYPE_ISO;
		writer_num = 1;
	}
	else if(sel_writer == g_WriterNet){
		writerp->hid = HID_VIRTUAL;
		writerp->tid = CMDDRVTYPE_NET;
		writer_num = 1;
	}
	else{
		writerp->hid = g_Writers[sel_writer].hid;
		writerp->tid = g_Writers[sel_writer].tid;
		writer_num = 1;
	}
	
	/* ǎ摕uݒ */
	if(sel_reader == g_ReaderISO){
		reader.hid = HID_VIRTUAL;
		reader.tid = CMDDRVTYPE_ISO;
	}
	else if(sel_reader == g_ReaderNet){
		reader.hid = HID_VIRTUAL;
		reader.tid = CMDDRVTYPE_NET;
	}
	else{
		reader.hid = g_Readers[sel_reader].hid;
		reader.tid = g_Readers[sel_reader].tid;
	}

	UIClearAbort();
	ret = CopyDisc(&reader, writerp, writer_num);

	[buttonStartCopy setEnabled : YES];
	[buttonQuit setEnabled : YES];
	[readerCombo setEnabled : YES];
	[writerCombo setEnabled : YES];
	[buttonStartCopy setTitle : [NSString stringWithCString : "ʊJn"]];

	/* u */
	free(writerp);

	UIMeter1Initialize(NULL);
	UIMeter2Initialize(NULL);
	[ap release];
}

- (void)startUp
{
	UISetMWC(self);
	[self scanDrive : self];
}

- (void)uiCtlMeter1Initialize:(const char *)string
{
	if(string==NULL){
		[meter1Label setStringValue : @""];	
	}
	else{
		[meter1Label setStringValue : [NSString stringWithCString : string]];
	}
	[meter1 setDoubleValue : 0.0];
}

- (void)uiCtlMeter2Initialize:(const char *)string
{
	if(string==NULL){
		[meter2Label setStringValue : @""];	
	}
	else{
		[meter2Label setStringValue : [NSString stringWithCString : string]];
	}
	[meter2 setDoubleValue : 0.0];
}

- (void)uiCtlMeter1Update:(int)percentage
{
	[meter1 setDoubleValue : (double)percentage];
}

- (void)uiCtlMeter2Update:(int)percentage
{
	[meter2 setDoubleValue : (double)percentage];
}

- (void)uiCtlDispInfo:(const char *)string
{
	if(string==NULL){
		[infoLabel setStringValue : @""];
	}
	else{
		[infoLabel setStringValue : [NSString stringWithCString : string]];
	}
}

- (int)uiCtlSetting:(OPTIONS *)option
{
	return [settingPanel openSettingDialog: option];
}

- (int)uiCtlNetSetting : (BOOL)serverMode
		 remoteAddress : (char *)remote
		   addressSize : (int)size
			portNumber : (int *)portNumber
{
	return [netSettingPanel openNetSettingDialog:serverMode
								   remoteAddress:remote
									 addressSize:size
									  portNumber:portNumber];
}


- (int)MessageBoxDlg : (const char *)messageKey
			   title : (const char *)titleKey
				flags : (int)flags
{
	NSAlert *alert;
	NSString *button1Label, *button2Label, *button3Label;
	NSString *message, *title=NULL;
	NSAlertStyle alertStyle;
	int retvalue[3], retcode;

	if(titleKey!=NULL)
		title = [NSString stringWithCString : titleKey];
	message = [NSString stringWithCString : messageKey];
	
	switch(flags & MBF_TYPEMASK){
	case MBF_TYPEABORTRETRYIGNORE:
		button1Label = [NSString stringWithCString : "f"];
		button2Label = [NSString stringWithCString : "Ďs"];
		button3Label = [NSString stringWithCString : ""];
		retvalue[0] = MBR_ABORT;
		retvalue[1] = MBR_RETRY;
		retvalue[2] = MBR_IGNORE;
		break;
	case MBF_TYPEOKCANCEL:
		button1Label = [NSString stringWithCString : ""];
		button2Label = [NSString stringWithCString : ""];
		button3Label = NULL;
		retvalue[0] = MBR_OK;
		retvalue[1] = MBR_CANCEL;
		retvalue[2] = 0;
		break;
	case MBF_TYPERETRYCANCEL:
		button1Label = [NSString stringWithCString : "Ďs"];
		button2Label = [NSString stringWithCString : ""];
		button3Label = NULL;
		retvalue[0] = MBR_RETRY;
		retvalue[1] = MBR_CANCEL;
		retvalue[2] = 0;
		break;
	case MBF_TYPEYESNO:
		button1Label = [NSString stringWithCString : "͂"];
		button2Label = [NSString stringWithCString : ""];
		button3Label = NULL;
		retvalue[0] = MBR_YES;
		retvalue[1] = MBR_NO;
		retvalue[2] = 0;
		break;
	case MBF_TYPEYESNOCANCEL:
		button1Label = [NSString stringWithCString : "͂"];
		button2Label = [NSString stringWithCString : ""];
		button3Label = [NSString stringWithCString : ""];
		retvalue[0] = MBR_YES;
		retvalue[1] = MBR_NO;
		retvalue[2] = MBR_CANCEL;
		break;
	case MBF_TYPEOK:
		button1Label = [NSString stringWithCString : ""];
		button2Label = NULL;
		button3Label = NULL;
		retvalue[0] = MBR_OK;
		retvalue[1] = 0;
		retvalue[2] = 0;
		break;
	default:
		return MBR_CANCEL;
	}
	
	switch(flags & MBF_ICONMASK){
	case MBF_ICONEXCLAMATION:
		alertStyle = NSWarningAlertStyle;
		break;
	case MBF_ICONQUESTION:
		alertStyle = NSInformationalAlertStyle;
		break;
	case MBF_ICONSTOP:
		alertStyle = NSCriticalAlertStyle;
		break;
	default:
		alertStyle = NSInformationalAlertStyle;
	}

	/* localize */
	if(button1Label!=NULL){
		button1Label = [[NSBundle mainBundle]
				localizedStringForKey : button1Label
								value : nil
								table : nil];
	}
	if(button2Label!=NULL){
		button2Label = [[NSBundle mainBundle]
				localizedStringForKey : button2Label
								value : nil
								table : nil];
	}
	if(button3Label!=NULL){
		button3Label = [[NSBundle mainBundle]
				localizedStringForKey : button3Label
								value : nil
								table : nil];
	}
	message = [[NSBundle mainBundle]
					localizedStringForKey : message
									value : nil
									table : nil];
	title = [[NSBundle mainBundle]
					localizedStringForKey : title
									value : nil
									table : nil];
	
	/* create alert panel */
	alert = [[NSAlert alloc] init];
	if(button1Label!=NULL)
		[alert addButtonWithTitle : button1Label];
	if(button2Label!=NULL)
		[alert addButtonWithTitle : button2Label];
	if(button3Label!=NULL)
		[alert addButtonWithTitle : button3Label];
	[alert setMessageText : message];
	[alert setInformativeText : title];
	[alert setAlertStyle : alertStyle];
	
	switch([alert runModal]){
	case NSAlertFirstButtonReturn:
		retcode = retvalue[0];
		break;
	case NSAlertSecondButtonReturn:
		retcode = retvalue[1];
		break;
	case NSAlertThirdButtonReturn:
		retcode = retvalue[2];
		break;
	default:
		retcode = MBR_CANCEL;		
	}
	[alert release];
	return retcode;
}

/*
 * delegate
 */
- (void) applicationDidFinishLaunching: (NSNotification *)aNotification
{
    [self startUp];
}

- (void) applicationWillTerminate: (NSNotification *)aNotification
{
    if(g_Readers!=NULL){
		free(g_Readers);
		g_Readers = NULL;
	}
	if(g_Writers!=NULL){
		free(g_Writers);
		g_Writers = NULL;
	}
}

- (void)windowWillClose:(NSNotification *)aNotification
{
    [NSApp terminate: self];
}

@end
