/*
 * @file cmd.c
 * @brief R}hs֘A
 * @author BananaJinn
 * @version $Id: cmd.c,v 1.20 2008/01/04 14:09:58 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#include <stdio.h>
#include <string.h>
#if !defined(WIN32)
# include <unistd.h>
#endif
#include "struct.h"
#include "cmd.h"
#include "cmdlog.h"
#include "ui.h"
#include "text.h"

WORD Get2bytes(BYTE *buf)
{
	return (WORD)buf[0]<<8 | buf[1];
}

DWORD Get3bytes(BYTE *buf)
{
	return (DWORD)buf[0]<<16 | (DWORD)buf[1]<<8 | buf[2];
}

DWORD Get4bytes(BYTE *buf)
{
	return (DWORD)buf[0]<<24 | (DWORD)buf[1]<<16 | (DWORD)buf[2]<<8 | buf[3];
}

void Set2bytes(BYTE *buf, WORD value)
{
	buf[0] = (BYTE)(value>>8);
	buf[1] = (BYTE)value;
}

void Set3bytes(BYTE *buf, DWORD value)
{
	buf[0] = (BYTE)(value>>16);
	buf[1] = (BYTE)(value>>8);
	buf[2] = (BYTE)value;
}

void Set4bytes(BYTE *buf, DWORD value)
{
	buf[0] = (BYTE)(value>>24);
	buf[1] = (BYTE)(value>>16);
	buf[2] = (BYTE)(value>>8);
	buf[3] = (BYTE)value;
}

WORD Get2bytesLE(BYTE *buf)
{
	return (WORD)buf[1]<<8 | buf[0];
}

DWORD Get3bytesLE(BYTE *buf)
{
	return (DWORD)buf[2]<<16 | (DWORD)buf[1]<<8 | buf[0];
}

DWORD Get4bytesLE(BYTE *buf)
{
	return (DWORD)buf[3]<<24 | (DWORD)buf[2]<<16 | (DWORD)buf[1]<<8 | buf[0];
}

void Set2bytesLE(BYTE *buf, WORD value)
{
	buf[1] = (BYTE)(value>>8);
	buf[0] = (BYTE)value;
}

void Set3bytesLE(BYTE *buf, DWORD value)
{
	buf[2] = (BYTE)(value>>16);
	buf[1] = (BYTE)(value>>8);
	buf[0] = (BYTE)value;
}

void Set4bytesLE(BYTE *buf, DWORD value)
{
	buf[3] = (BYTE)(value>>24);
	buf[2] = (BYTE)(value>>16);
	buf[1] = (BYTE)(value>>8);
	buf[0] = (BYTE)value;
}


DWORD MSF2LBA(BYTE min, BYTE sec, BYTE frame, BOOL force_positive)
{
	DWORD ret = min*60 + sec;
	ret *= 75;
	ret += frame;
	if(min < 90 || force_positive)
		ret -= 150;
	else
		ret -= 450150;
	return ret;
}

BOOL LBA2MSF(DWORD lba, BYTE *min, BYTE *sec, BYTE *frame)
{
	BYTE m, s, f;

	if(lba >= (DWORD)-150 || lba < 405000){
		m = (BYTE)((lba+150)/60/75);
		s = (BYTE)((lba+150 - m*60*75)/75);
		f = (BYTE)(lba+150 - m*60*75 - s*75);
	}
	else if(lba>=(DWORD)-45150 && lba<=(DWORD)-151){
		m = (BYTE)((lba+450150)/60/75);
		s = (BYTE)((lba+450150 - m*60*75)/75);
		f = (BYTE)(lba+450150 - m*60*75 - s*75);
	}
	else{
		*min = 0xff;
		*sec = 0xff;
		*frame = 0xff;
		return FALSE;
	}

	*min = m;
	*sec = s;
	*frame = f;

	if(lba>404849)
		return FALSE;
	return TRUE;
}



int SendTestUnitReady(CMDDRIVE *drive)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendStartStop(CMDDRIVE *drive, BYTE immed, BYTE load_eject, BYTE start_or_load)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_START_STOP;
	cdb[1] = (BYTE)(immed ? 1:0);
	cdb[4] = (BYTE)((load_eject ? 2:0)|(start_or_load ? 1:0));
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendPreventAllow(CMDDRIVE *drive, BYTE prevent)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_PREVENT_ALLOW;
	cdb[4] = (BYTE)(prevent ? 1:0);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendModeSense(CMDDRIVE *drive, BYTE page_control, BYTE page_code)
{
	BYTE cdb[12];
	WORD len;
	int ret;

	len = drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_MODE_SENSE10;
	cdb[2] = (BYTE)(page_control<<6 | page_code);
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK){
		return ret;
	}
	len = Get2bytes(drive->data_buf) + 2;
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}

int SendModeSelect(CMDDRIVE *drive, BYTE pf)
{
	BYTE cdb[12];
	WORD len;
	struct _MODEPAGE_HEADER *mph;

	mph = (struct _MODEPAGE_HEADER *)
		(drive->data_buf+(drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16));
	len = mph->p_len + (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16) + 2;
	memset(drive->data_buf, 0, drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_MODE_SELECT10;
	cdb[1] = (BYTE)(pf ? 0x10:0);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}

int SendReadToc(CMDDRIVE *drive, WORD track_sess_num, BYTE msf, BYTE format)
{
	BYTE cdb[12];
	WORD len = 4;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_TOC;
	cdb[1] = (BYTE)(msf ? 2:0);
	cdb[2] = (BYTE)(format & 0x0f);
	cdb[6] = (BYTE)(track_sess_num);
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK){
		return ret;
	}
	len = Get2bytes(drive->data_buf);
        len += 2;
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}


int SendReadDiscInfo(CMDDRIVE *drive)
{
	BYTE cdb[12];
	WORD len;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_DISC_INFO;
	Set2bytes(cdb+7, 2);
	ret = SendCmd(drive, cdb, 2, REQ_DATAIN);
	if(ret!=RET_OK){
		return ret;
	}
	len = Get2bytes(drive->data_buf) + 2;
	Set2bytes(cdb+7, len);
	memset(drive->data_buf, 0, sizeof(struct _DISCINFO));
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}


int SendReadTrackInfo(CMDDRIVE *drive, WORD track_num)
{
	BYTE cdb[12];
	WORD len = sizeof(struct _TRACKINFO);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_TRACK_INFO;
	cdb[1] = 0x01;
	Set2bytes(cdb+4, track_num);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}


int SendCloseTrackSession(CMDDRIVE *drive, BYTE immed, BYTE type, WORD track_num)
{
	BYTE cdb[12];
	
	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_CLOSE_TRACK_SESSION;
	cdb[1] = (BYTE)(immed ? 1:0);
	cdb[2] = (BYTE)(type & 7);
	Set2bytes(cdb+4, track_num);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendReadSubchannel(CMDDRIVE *drive, BYTE track_num, BYTE msf, BYTE subq, BYTE format)
{
	BYTE cdb[12];
	WORD len=4;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_SUBCHANNEL;
	cdb[1] = (BYTE)(msf ? 2:0);
	cdb[2] = (BYTE)(subq ? 0x40:0);
	cdb[3] = format;
	cdb[6] = track_num;
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK)
		return ret;
	len = Get2bytes(drive->data_buf+2) + 4;
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}

int SendReadCD(CMDDRIVE *drive, DWORD addr, DWORD len)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_CD;
	Set4bytes(cdb+2, addr);
	Set3bytes(cdb+6, len);
	cdb[9] = 0xf8;
	return SendCmd(drive, cdb, len*2352, REQ_DATAIN);
}

int SendReadFormatCapacities(CMDDRIVE *drive)
{
	BYTE cdb[12];
	WORD len=4;
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_FORMAT_CAPACITIES;
	Set2bytes(cdb+7, len);
	ret = SendCmd(drive, cdb, len, REQ_DATAIN);
	if(ret!=RET_OK)
		return ret;
	len = drive->data_buf[3] + sizeof(struct _FORMATCAPA_HEADER) +
								sizeof(struct _FORMATCURMAXDESC);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, len, REQ_DATAIN);
}



int SendFormatUnit(CMDDRIVE *drive, BYTE fmtdata, BYTE cmplist, BYTE format_code, WORD len)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_FORMAT_UNIT;
	cdb[1] = (BYTE)((fmtdata ? 0x10:0)|(cmplist ? 8:0)|(format_code & 7));
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}

int SendSetCdSpeed(CMDDRIVE *drive, WORD read_speed, WORD write_speed, BYTE rotctl)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SET_CD_SPEED;
	cdb[1] = (BYTE)(rotctl & 3);
	Set2bytes(cdb+2, read_speed);
	Set2bytes(cdb+4, write_speed);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendSetStreaming(CMDDRIVE *drive)
{
	BYTE cdb[12];
	WORD len = sizeof(struct _PERFORMANCEDESC);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SET_STREAMING;
	Set2bytes(cdb+9, len);
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}


int SendSynchronizeCache(CMDDRIVE *drive, BYTE immed)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SYNCHRONIZE_CACHE;
	cdb[1] = (BYTE)(immed ? 2:0);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendReserveTrack(CMDDRIVE *drive, DWORD size)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_RESERVE_TRACK;
	Set4bytes(cdb+5, size);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendRead10(CMDDRIVE *drive, DWORD lba, WORD len, DWORD buflen)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ10;
	Set4bytes(cdb+2, lba);
	Set2bytes(cdb+7, len);
	return SendCmd(drive, cdb, buflen, REQ_DATAIN);
}

int SendWrite10(CMDDRIVE *drive, DWORD lba, WORD len, DWORD buflen,
				BOOL retry)
{
	BYTE cdb[12];
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_WRITE10;
	Set4bytes(cdb+2, lba);
	Set2bytes(cdb+7, len);
	if(retry){
	  while(TRUE){
		ret = SendCmd(drive, cdb, buflen, REQ_DATAOUT);
		if(ret!=RET_CMDERR)
		  break;
		if(!(SD_ASC(drive)==0x04 && SD_ASCQ(drive)==0x08))
		  break;
	  }
	  return ret;
	}
	else{
	  return SendCmd(drive, cdb, buflen, REQ_DATAOUT);
	}
}

int SendSeek10(CMDDRIVE *drive, DWORD lba)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SEEK10;
	Set4bytes(cdb+2, lba);
	return SendCmd(drive, cdb, 0, REQ_NODATA);
}

int SendSendCueSheet(CMDDRIVE *drive, void *cuesheet, DWORD len)
{
	BYTE cdb[12];

	if(len >= (DWORD)drive->bufsize)
		return RET_NG;

	if(cuesheet!=NULL)
		memcpy(drive->data_buf, cuesheet, len);

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_SEND_CUE_SHEET;
	Set3bytes(cdb+6, len);
	return SendCmd(drive, cdb, len, REQ_DATAOUT);
}

int SendReadBufferCapacity(CMDDRIVE *drive, BYTE block)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_BUFFER_CAPACITY;
	cdb[1] = (BYTE)(block ? 1:0);
	Set2bytes(cdb+7, 12);
	return SendCmd(drive, cdb, 12, REQ_DATAIN);
}


int SendLongRead12(CMDDRIVE *drive, DWORD lba, DWORD len, DWORD buflen,
				   DWORD total_blocks)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ12;
	Set4bytes(cdb+2, lba);
	Set4bytes(cdb+6, len);
	return SendCmdLongRead(drive, cdb, buflen, REQ_DATAIN, total_blocks);
}

int SendLongReadCD(CMDDRIVE *drive, DWORD addr, DWORD len,
				   DWORD total_blocks)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_CD;
	Set4bytes(cdb+2, addr);
	Set3bytes(cdb+6, len);
	cdb[9] = 0xf8;
	return SendCmdLongRead(drive, cdb, len*2352, REQ_DATAIN, total_blocks);
}



int OpenTray(CMDDRIVE *drive)
{
  if(drive->type == CMDDRVTYPE_NET){
		/* lbg[N摕ũgC͍sȂ */
	return RET_OK;
  }
  
  SendPreventAllow(drive, 0);
  return SendStartStop(drive, 0, 1, 0);
}

int OpenTrayImmediate(CMDDRIVE *drive)
{
  if(drive->type == CMDDRVTYPE_NET){
		/* lbg[N摕ũgC͍sȂ */
	return RET_OK;
  }
  
  SendPreventAllow(drive, 0);
  return SendStartStop(drive, 1, 1, 0);
}

int CloseTray(CMDDRIVE *drive)
{
  if(drive->type == CMDDRVTYPE_NET){
		/* lbg[N摕ũgC͍sȂ */
	return RET_OK;
  }
  return SendStartStop(drive, 0, 1, 1);
}


int GetDiscType(CMDDRIVE *drive, int *disc_type_ret, BOOL bWaitDisc)
{
	BYTE cdb[12];
	int ret;
	struct _FEATURE_HEADER *fh;
	struct _DISCINFO *di;
	int disc_type;

	*disc_type_ret = DT_UNKNOWN;

	ret = CheckReady(drive, bWaitDisc);
	if(ret!=RET_OK){
		return ret;
	}

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_GET_CONFIGURATION;
	cdb[8] = 8;
	ret = SendCmd(drive, cdb, 8, REQ_DATAIN);
	if(ret==RET_OK){
		fh = (struct _FEATURE_HEADER *)drive->data_buf;
		disc_type = Get2bytes(fh->cur_profile);
		*disc_type_ret = disc_type;
		return RET_OK;
	}
	if(SD_SENSEKEY(drive)==5 && SD_ASC(drive)==0x20){
		/* GET CONFIG R}hT|[g */
		ret = SendReadDiscInfo(drive);
		if(ret!=RET_OK){
			return ret;
		}
		di = (struct _DISCINFO *)drive->data_buf;
		*disc_type_ret = di->erasable ? DT_CDRW : DT_CDR;
		return RET_OK;
	}

	return ret;
}

int CheckReady(CMDDRIVE *drive, BOOL bWaitDisc)
{
	int ret;
	BOOL bGood=FALSE;
	BOOL bEjected=FALSE;

	while(bGood==FALSE){
	  if(UICheckAbort()){
		return RET_ABORT;
	  }
	  ret = SendTestUnitReady(drive);
	  if(ret==RET_OK){
		bGood=TRUE;
	  }
	  else{
		if(SD_SENSEKEY(drive)==0x02 &&
		   SD_ASC(drive)==0x04 &&
		   SD_ASCQ(drive)==0x01){
		  UIDispInfo(MSG_WAITING_READY /*"ł̂҂Ă܂"*/);
			  /* becoming ready */
		}
		else if(SD_SENSEKEY(drive)==0x06 &&
				SD_ASC(drive)==0x28 &&
				SD_ASCQ(drive)==0x00){
			  /* medium change */
		}
		else if(SD_SENSEKEY(drive)==0x06 &&
				SD_ASC(drive)==0x29 &&
				SD_ASCQ(drive)==0x00){
			  /* power on, reset */
		}
#if 0
		else if(SD_SENSEKEY(drive)==0x02 &&
				SD_ASC(drive)==0x3a &&
				SD_ASCQ(drive)==0x00){
			  /* medium not present */
		}
#endif
		else{
		  if(bWaitDisc){
				/* Eject */
			if(bEjected==FALSE){
			  OpenTrayImmediate(drive);
			  bEjected=TRUE;
			  UIDispInfo(MSG_INSERT_DISC /*"fBXN}Ă"*/);
			}
		  }
		  else{
			return RET_NG;
		  }
		}
#ifdef WIN32
		Sleep(1000);
#else
		sleep(1);
#endif
	  }
	}

	return RET_OK;
}

int BlankDisc(CMDDRIVE *drive, BYTE type)
{
	BYTE cdb[12];
	int ret;

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_BLANK;
	cdb[1] = (BYTE)(0x10|type);
	ret = SendCmd(drive, cdb, 0, REQ_NODATA);
	if(ret!=RET_OK){
		return ret;
	}

	ret = WaitProgress(drive, MSG_QUICK_BLANK /*""*/, FALSE);
	return ret;
}


int WaitProgress(CMDDRIVE *drive, const char *message, BOOL meter1)
{
	WORD indicator=0;
	BOOL bGood=FALSE;
	int ret;

	if(message!=NULL){
		if(meter1)
			UIMeter1Initialize(message);
		else
			UIMeter2Initialize(message);
	}

	while(bGood==FALSE){
		if(UICheckAbort()){
			return RET_ABORT;
		}
		//ret = SendTestUnitReady(drive);
		ret = SendReadDiscInfo(drive);
		if(ret==RET_OK){
			bGood=TRUE;
		}
		else{
			if(SD_SENSEKEY(drive)!=0x02){
				return RET_CMDERR;
			}
			/*  */
			if(drive->sense_data[15] & 0x80){
				indicator = Get2bytes(drive->sense_data+16);
				if(message!=NULL){
					if(meter1)
						UIMeter1Update((float)(indicator*100+0x7fff)/0xffff);
					else
						UIMeter2Update((float)(indicator*100+0x7fff)/0xffff);
				}
			}
#if defined(WIN32)
			Sleep(100);
#else
			usleep(100*1000);
#endif
		}
	}

	return RET_OK;
}

void DispCommandError(CMDDRIVE *drive)
{
	char buf[80];

	if(SD_SENSEKEY(drive)!=0){
	  sprintf(buf, MSG_COMMAND_ERROR
		  /*"R}hsG[(%02Xh : %X/%02X/%02X)"*/,
			  drive->cmdcode,
			  SD_SENSEKEY(drive), SD_ASC(drive), SD_ASCQ(drive));
	  UIDispMessage(buf, UIDMT_ERROR);
	}
}

/*
 * READ CD R}h SUB-Q f[^擾
 */
int GetSubQ(CMDDRIVE *drive, DWORD lba, DWORD len)
{
	BYTE cdb[12];

	memset(cdb, 0, sizeof(cdb));
	cdb[0] = CMD_READ_CD;
	Set4bytes(cdb+2, lba);
	Set3bytes(cdb+6, len);
	cdb[10] = 2;
	return SendCmd(drive, cdb, len*16, REQ_DATAIN);
}

int SetSpeed(CMDDRIVE *drive, int read_speed, int write_speed)
{
  int ret;
  WORD read_kbps, write_kbps;
  struct _PERFORMANCEDESC *pd;

  if(!REALDRIVE(drive))
	return RET_OK;

  if(DT_CD_FAMILY(drive->disc_type)){
	read_kbps = read_speed ? (WORD)(read_speed*176.4) : 0xffff;
	write_kbps = write_speed ? (WORD)(write_speed*176.4) : 0xffff;
	ret = SendSetCdSpeed(drive, read_kbps, write_kbps, 0);
	if(ret!=RET_OK){
	  DispCommandError(drive);
	  return ret;
	}
  }
  else{
	pd = (struct _PERFORMANCEDESC *)drive->data_buf;
	memset(pd, 0, sizeof(struct _PERFORMANCEDESC));
	pd->rdd = (read_speed==0 && write_speed==0) ? 1:0;
	Set4bytes(pd->read_size, (DWORD)(read_speed*1385));
	Set4bytes(pd->read_time, 1000);
	Set4bytes(pd->write_size, (DWORD)(write_speed*1385));
	Set4bytes(pd->write_time, 1000);

	ret = SendSetStreaming(drive);
#if 0	/* G[ɂȂĂpׁA */
	if(ret!=RET_OK){
	  DispCommandError(drive);
	  return ret;
	}
#endif
  }

  return RET_OK;
}
