/*
 * @file netaccess.h
 * @brief lbg[NANZX
 * @author BananaJinn
 * @version $Id: netaccess.h,v 1.11 2007/10/02 15:10:52 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __NETACCESS_H__
#define __NETACCESS_H__

#if defined(WIN32)
# include <winsock.h>
# define SD_RECEIVE      0x00
# define SD_SEND         0x01
# define SD_BOTH         0x02
#else
# include <sys/socket.h>
  typedef int SOCKET;
#endif
#if defined(linux) || defined(__MINGW32__)
# include <iconv.h>
#endif

#define NETTIMEOUT (60*1000)

typedef struct {
  BOOL server_mode;
  union {
	struct {
	  WORD port;
	  SOCKET listen_socket;
	  SOCKET socket_desc;
	} server;
	struct {
	  DWORD remote_address;
	  WORD remote_port;
	  SOCKET socket_desc;
	} client;
  } u;
  char *remote_host;
  DWORD error_code;
#if defined(linux) || defined(__MINGW32__)
  iconv_t iconv_desc;
#endif
} SOCKCB;



/*
 * f[^]`
 * +-----------------------+ ----
 * | length[0]          MSB|   ^
 * +-----------------------+   |
 * | length[1]             |   |
 * +-----------------------+   |
 * | length[2]             |   | ʕ
 * +-----------------------+   | (8 bytes)
 * | length[3]          LSB|   |
 * +-----------------------+   |
 * | data type             |   |
 * +-----------------------+   |
 * | reserved              |   |
 * +-----------------------+   |
 * | reserved              |   |
 * +-----------------------+   |
 * | reserved              |   v
 * +-----------------------+ ----
 * | ...                   |   ^
 * |                       |   | ʕ(data typeɂ)
 * |                       |   v
 * +-----------------------+ ----
 *
 * length͌ʕ̃f[^\(ʕ͊܂܂Ȃ)
 */

/*
 * ATAPI/ASPIR}h(Client => Server)
 * ʃf[^ NETCMDHEADER + R}hf[^()
 */
#define NETDATATYPE_COMMAND		1
/*
 * ATAPI/ASPIR}hɑ΂鉞(Server => Client)
 * ʃf[^ NETCMDHEADER + R}hf[^()
 */
#define NETDATATYPE_RESPONSE	2
/*
 * ATAPI/ASPIR}h̒READ(Client => Server)
 * READ(12)܂READCĎ`ServerAăf[^Ԃ
 * ʃf[^ NETCMDHEADER + g[^length(4bytes)
 */
#define NETDATATYPE_LONGREAD	3

typedef struct {
  BYTE reqflag;
  BYTE reserved[3];
  BYTE cdb[12];
  BYTE data_length[4];
  BYTE sense_data[0x20];
} NETCMDHEADER;

/*
 * \XV(Client => Server)
 * ʃf[^ NETDISPHEADER + bZ[W(\0܂)
 * bZ[W񒷂 0 ̏ꍇ̓vOXo[̂ݍXV肷
 */
#define NETDATATYPE_DISPLAY		4

typedef struct {
  BYTE area;	/* 0:ʉbZ[W/1:vOXo[1/2:vOXo[2 */
  BYTE percent;	/* vOXo[̐i(0-100) */
} NETDISPHEADER;

/*
 * f(Client <=> Server)
 * ʃf[^͂ȂBɏ𒆒fB
 */
#define NETDATATYPE_ABORT		5

/*
 * (Client => Server)
 * ʃf[^͂ȂB
 */
#define NETDATATYPE_COMPLETE	6

extern int InitializeSOCKCB(SOCKCB *scb);
extern int FreeSOCKCB(SOCKCB *scb);

extern int NACreateServer(SOCKCB *scb);
extern int NAWaitConnect(SOCKCB *scb, DWORD timeout);
extern int NAConnect(SOCKCB *scb);
extern int NAClose(SOCKCB *scb);
extern int NASend(SOCKCB *scb, const void *buffer, int length, DWORD timeout,
				  BOOL check_readfd);
extern int NAReceive(SOCKCB *scb, void *buffer, int length, DWORD timeout);

extern int SendNetCmd(SOCKCB *scb, BYTE *cdb, void *buf, DWORD buflen,
					  BYTE *sensedata, DWORD senselen, int reqflag);
extern int SendNetCmdLongRead(SOCKCB *scb, BYTE *cdb, void *buf, DWORD buflen,
							  BYTE *sensedata, DWORD senselen,
							  int reqflag, DWORD total_blocks);

extern int NASendDispCmd(SOCKCB *scb, BYTE area, BYTE percent,
						 const char *message);
extern int NASendAbort(SOCKCB *scb);
extern int NASendComplete(SOCKCB *scb);
extern int NAUIDispInfo(SOCKCB *scb, const char *message);
extern int NAUIMeter1Initialize(SOCKCB *scb, const char *message);
extern int NAUIMeter2Initialize(SOCKCB *scb, const char *message);
extern int NAUIMeter1Update(SOCKCB *scb, float percentage);
extern int NAUIMeter2Update(SOCKCB *scb, float percentage);
extern const char *NAGetErrorMessage(SOCKCB *scb);
#if defined(linux) || defined(__MINGW32__)
extern char *ConvertCharcode(iconv_t iconv_desc, const char *in_string);
#endif
extern BOOL DispSocketError(SOCKCB *scb, int ret_value);

#endif /* !__NETACCESS_H__ */
