/*
 * @file option.c
 * @brief ʐݒ
 * @author BananaJinn
 * @version $Id: option.c,v 1.22 2008/04/06 15:15:15 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#include <stdio.h>
#include <string.h>
#if !defined(WIN32)
# include <stdlib.h>
# include <pwd.h>
# include <unistd.h>
# include <sys/types.h>
#endif	/* !WIN32 */
#include "mem.h"
#include "option.h"
#include "cmd.h"
#include "ui.h"
#include "text.h"

static OPTIONS g_Option;

/**
 * ǂݎ葬xz擾
 * @param[in]	drive	u
 * @param[out]	option	IvV\
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int GetReadableSpeed(CMDDRIVE *drive, OPTIONS *option)
{
  BYTE speeds[] = { 52, 48, 32, 24, 20, 16, 12, 10, 8, 6, 4, 2, 1 };

  if(!REALDRIVE(drive)){
    option->readable_speed = NULL;
    option->num_readable_speed = 0;
    return RET_OK;
  }
  option->readable_speed = (BYTE *)MemNew(sizeof(speeds));
  if(option->readable_speed == NULL){
    UIDispMessage(MSG_MEM_ALLOC_ERROR
		  /*"mۂɎs܂B"*/, UIDMT_ERROR);
    return RET_NG;
  }

  option->num_readable_speed = sizeof(speeds)/sizeof(BYTE);
  memcpy(option->readable_speed, speeds, sizeof(speeds));
  return RET_OK;
}

/**
 * ݂̋L^x擾
 * @param[in]	drive	u
 * @param[in]	option	IvV\
 * @return	x(n{)
 */
static int GetCurrentWriteSpeed(CMDDRIVE *drive, OPTIONS *option)
{
  struct _MODEPAGE2A *mp2a;
  WORD speed_kbs;
  WORD len;
  int ret;

  ret = SendModeSense(drive, MSPC_CURRENT, 0x2a);
  if(ret != RET_OK){
    return 0;
  }
  mp2a = (struct _MODEPAGE2A *)(drive->data_buf+
				(drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16));
  len = Get2bytes(drive->data_buf)-(drive->cmd_type==CMDDRVCTYPE_ATAPI ? 6:14);
  if(len > 28){
    speed_kbs = Get2bytes(mp2a->v3_cur_write_speed);
  }
  else{
    speed_kbs = Get2bytes(mp2a->cur_write_speed);
  }

  if(option->flags & OPFLG_DVD){
    return speed_kbs/1385;
  }
  return (int)((speed_kbs+0.5)/176.4);
}

/**
 * ݉\xz擾
 * @param[in]	drive	u
 * @param[out]	option	IvV\
 * @retval	RET_OK	I
 * @retval	RET_NG	G[
 */
static int GetWritableSpeed(CMDDRIVE *drive, OPTIONS *option)
{
  BYTE speeds[] = { 52, 48, 32, 24, 20, 16, 12, 10, 8, 6, 4, 2, 1 };
  struct _MODEPAGE2A *mp2a;
  struct _WRITESPEED_PERFOMANCE *wr_speed;
  WORD num_wr_speed_des, index_des;
  WORD speed_kbs;
  WORD len;
  int ret;

  if(!REALDRIVE(drive)){
    option->writable_speed = NULL;
    option->num_writable_speed = 0;
    return RET_OK;
  }

  ret = SendModeSense(drive, MSPC_CURRENT, 0x2a);
  if(ret != RET_OK){
    DispCommandError(drive);
    return ret;
  }
  option->writable_speed = NULL;
  option->num_writable_speed = 0;
  len = Get2bytes(drive->data_buf)-(drive->cmd_type==CMDDRVCTYPE_ATAPI ? 6:14);
  if(len > 30){
    mp2a = (struct _MODEPAGE2A *)(drive->data_buf+
				  (drive->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16));
    num_wr_speed_des = Get2bytes(mp2a->num_wr_speed_des);
    if(num_wr_speed_des > 0){
      option->writable_speed = (BYTE *)MemNew(num_wr_speed_des*sizeof(BYTE));
      if(option->writable_speed == NULL){
	UIDispMessage(MSG_MEM_ALLOC_ERROR
		      /*"mۂɎs܂B"*/, UIDMT_ERROR);
	return RET_NG;
      }
      wr_speed = mp2a->wr_speed_des;
      for(index_des=0; index_des<num_wr_speed_des; index_des++){
	speed_kbs = Get2bytes(wr_speed[index_des].wr_speed_supp);
	if(option->flags & OPFLG_DVD){
	  option->writable_speed[index_des] = (BYTE)(speed_kbs/1385);
	}
	else{
	  option->writable_speed[index_des] = (BYTE)((speed_kbs+0.5)/176.4);
	}
      }
      option->num_writable_speed = num_wr_speed_des;
    }
  }
  if(option->num_writable_speed==0){
    /* T|[gx擾łȂꍇ */
    option->writable_speed = (BYTE *)MemNew(sizeof(speeds));
    if(option->writable_speed == NULL){
      UIDispMessage(MSG_MEM_ALLOC_ERROR
		    /*"mۂɎs܂B"*/, UIDMT_ERROR);
      return RET_NG;
    }
    for(index_des=0; index_des<sizeof(speeds)/sizeof(BYTE); index_des++){
      /* xݒ肵Ă݂ */
      ret = SetSpeed(drive, 0, speeds[index_des]);
      if(ret == RET_OK){
	if(GetCurrentWriteSpeed(drive, option) == speeds[index_des]){
	  /* ݒ\ */
	  option->writable_speed[option->num_writable_speed] = speeds[index_des];
	  option->num_writable_speed++;
	}
      }
    }
    if(option->num_writable_speed == 0){
      option->num_writable_speed = sizeof(speeds)/sizeof(BYTE);
      memcpy(option->writable_speed, speeds, sizeof(speeds));
    }
  }

  return RET_OK;
}

/**
 * 1gbNISOC[WǂmF
 * @param[in]	drive	u
 * @retval	TRUE	1gbNISȌꍇ
 * @retval	FALSE	ł͂Ȃꍇ
 */
static BOOL Check1TrackISO(CMDDRIVE *drive)
{
  struct _DISCINFO *di;
  int ret;
  WORD track_num;

  if(!REALDRIVE(drive)){
    return drive->type == CMDDRVTYPE_ISO;
  }

  if(DT_DVD_FAMILY(drive->disc_type)){
    /* CD̂ݑΉ */
    return FALSE;
  }

  ret = SendReadDiscInfo(drive);
  if(ret != RET_OK){
    return FALSE;
  }
  di = (struct _DISCINFO *)drive->data_buf;
  track_num = (WORD)di->last_track_ls_msb<<8 | di->last_track_ls_lsb;
  if(track_num != 1){
    return FALSE;
  }

  ret = SendRead10(drive, 0x10, 1, 2048);
  if(ret != RET_OK){
    return FALSE;
  }
  if(strncmp((char *)(drive->data_buf+1), "CD001", 5) != 0){
    return FALSE;
  }
  
  return TRUE;
}


#if defined(WIN32)

void GetRegString(const char *key, char *string_ret, DWORD size)
{
	LONG lRet;
	HKEY hKey;
	DWORD dwCount;
	DWORD dwType;

	if(size==0)
		return;
	if(string_ret==NULL)
		return;
	if(key==NULL)
		return;

	lRet = RegCreateKeyEx(HKEY_CURRENT_USER, "SOFTWARE\\EnbanFukusyaYa", 0, NULL,
						REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL);
	if(lRet!=ERROR_SUCCESS)
		return;
	dwCount = size;
	dwType = REG_SZ;
	lRet = RegQueryValueEx(hKey, key, NULL, &dwType, string_ret, &dwCount);
	if(lRet!=ERROR_SUCCESS){
		RegCloseKey(hKey);
		return;
	}
	RegCloseKey(hKey);
	string_ret[size-1]='\0';
}

void WriteRegString(const char *key, const char *string)
{
	LONG lRet;
	HKEY hKey;

	if(key==NULL)
		return;
	if(string==NULL)
		string="";
	lRet = RegCreateKeyEx(HKEY_CURRENT_USER, "SOFTWARE\\EnbanFukusyaYa", 0, NULL,
						REG_OPTION_NON_VOLATILE, KEY_ALL_ACCESS, NULL, &hKey, NULL);
	if(lRet!=ERROR_SUCCESS)
		return;
	lRet = RegSetValueEx(hKey, key, 0, REG_SZ, string, strlen(string));
	if(lRet!=ERROR_SUCCESS){
		RegCloseKey(hKey);
		return;
	}
	RegCloseKey(hKey);
}

static void LoadOption()
{
	char buf[32];
	GetRegString("imagedir", g_Option.temppath, _MAX_PATH);
	GetRegString("readspeed", buf, sizeof(buf));
	g_Option.read_speed = atoi(buf);
	GetRegString("writespeed", buf, sizeof(buf));
	g_Option.write_speed = atoi(buf);
}

static void SaveOption()
{
	char buf[32];
	WriteRegString("imagedir", g_Option.temppath);
	sprintf(buf, "%d", g_Option.read_speed);
	WriteRegString("readspeed", buf);
	sprintf(buf, "%d", g_Option.write_speed);
	WriteRegString("writespeed", buf);
}
#else	/* WIN32 */

#define OPTFNAME ".enbanrc"
static char *GetOptionFilename()
{
	char *fname;
	struct passwd *pwent;

	pwent = getpwuid(getuid());
	fname = (char *)MemNew(strlen(pwent->pw_dir)+1+strlen(OPTFNAME)+1);
	if(fname==NULL)
		return NULL;
	sprintf(fname, "%s/%s", pwent->pw_dir, OPTFNAME);
	return fname;
}

static void DeleteSpaces(char *buf)
{
	int qflag=0;
	
	while(*buf){
		if(*buf>0 && *buf<=0x20 && !qflag){
			memmove(buf, buf+1, strlen(buf));
		}
		else if(*buf==0x22){	/* " */
			qflag ^= 1;
			buf++;
		}
		else{
			buf++;
		}
	}
}

static void DeleteQuotation(char *buf)
{
	if(*buf=='\"'){
		if(buf[strlen(buf)-1]=='\"'){
			memmove(buf, buf+1, strlen(buf));
			buf[strlen(buf)-1]='\0';
		}
	}	
}


static void LoadOption()
{
	char *fname;
	char buf[80];
	FILE *fp;

	fname = GetOptionFilename();
	if(fname==NULL)
		return;
	fp = fopen(fname, "r");
	if(fp==NULL){
		MemFree(fname);
		return;
	}

	while(fgets(buf, sizeof(buf), fp)){
		if(buf[0]=='\0')
			continue;
		if(buf[0]=='#')
			continue;
		DeleteSpaces(buf);
		if(!strncmp(buf, "imagedir=", 9)){
			DeleteQuotation(buf+9);
			strncpy(g_Option.temppath, buf+9, _MAX_PATH);
			g_Option.temppath[_MAX_PATH] = '\0';
		}
		else if(!strncmp(buf, "readspeed=", 10)){
			DeleteQuotation(buf+10);
			g_Option.read_speed = atoi(buf+10);
		}
		else if(!strncmp(buf, "writespeed=", 11)){
			DeleteQuotation(buf+11);
			g_Option.write_speed = atoi(buf+11);
		}
	}
	fclose(fp);

	MemFree(fname);
}

static void SaveOption()
{
	char *fname;
	FILE *fp;

	fname = GetOptionFilename();
	if(fname==NULL)
		return;
	fp = fopen(fname, "w");
	if(fp==NULL){
		MemFree(fname);
		return;
	}

	fprintf(fp, "imagedir=\"%s\"\n", g_Option.temppath);
	fprintf(fp, "readspeed=%d\n", g_Option.read_speed);
	fprintf(fp, "writespeed=%d\n", g_Option.write_speed);
	fclose(fp);
	
	MemFree(fname);
}
#endif /* WIN32 */


int SetOption(CMDDRIVE *reader, CMDDRIVE *writer, int disc_type)
{
  int ret;
  struct _MODEPAGE05 *mp05;

  memset(&g_Option, 0, sizeof(OPTIONS));

  /* ꎞt@CfBNg߂ */
#ifdef WIN32
  if(GetTempPath(sizeof(g_Option.temppath), g_Option.temppath)==0){
    g_Option.temppath[0] = '\0';
  }
#else
  strcpy(g_Option.temppath, "/tmp");
#endif
  g_Option.flags |= OPFLG_TEMPPATH;

  if(writer->disc_type==DT_DVDPR || writer->disc_type==DT_DVDPRW ||
	 writer->disc_type==DT_DVDPRDL || writer->disc_type==DT_DVDPRWDL){
    /* WriteParametersPage ݒ肪̂ */
    g_Option.bufe = TRUE;
    g_Option.test_write = FALSE;
  }
  else{
    g_Option.bufe = FALSE;
    g_Option.test_write = FALSE;
    if(writer!=NULL){
      if((writer->type == CMDDRVTYPE_DRIVE) || (writer->type == CMDDRVTYPE_NET)){
	ret = SendModeSense(writer, MSPC_CHANGEABLE, 5);
	if(ret!=RET_OK){
	  DispCommandError(writer);
	  return ret;
	}
	mp05 = (struct _MODEPAGE05 *)
	  (writer->data_buf + (writer->cmd_type==CMDDRVCTYPE_ATAPI ? 8:16));
	if(mp05->BUFE){
	  g_Option.bufe = TRUE;
	  g_Option.flags |= OPFLG_BUFE;
	}
	if(mp05->test_write){
	  g_Option.test_write = FALSE;
	  g_Option.flags |= OPFLG_TESTWRITE;
	}
      }
    }
  }

  if(DT_DVD_FAMILY(disc_type)){
	  g_Option.flags |= OPFLG_DVD;
	  if(writer->disc_type!=DT_DVDPR && writer->disc_type!=DT_DVDPRW &&
		 writer->disc_type!=DT_DVDPRDL && writer->disc_type!=DT_DVDPRWDL){
		  g_Option.dao = TRUE;
		  g_Option.flags |= OPFLG_DAO;
	  }
  }

  if(reader!=NULL && writer!=NULL){
	  if(reader->type==CMDDRVTYPE_DRIVE && writer->type==CMDDRVTYPE_DRIVE){
		  if(reader->u.drive.hid != writer->u.drive.hid ||
			 reader->u.drive.tid != writer->u.drive.tid){
			  g_Option.on_the_fly = TRUE;
			  g_Option.flags |= OPFLG_ONTHEFLY;
		  }
	  }
	  else{
		  g_Option.on_the_fly = TRUE;
		  g_Option.flags |= OPFLG_ONTHEFLY;
		  g_Option.flags &= ~OPFLG_DAO;
	  }
  }
  else{
	  g_Option.on_the_fly = TRUE;
  }

  ret = GetReadableSpeed(reader, &g_Option);
  if(ret != RET_OK){
    return ret;
  }

  ret = GetWritableSpeed(writer, &g_Option);
  if(ret != RET_OK){
    MemFree(g_Option.readable_speed);
    g_Option.readable_speed=NULL;
    g_Option.num_readable_speed=0;
    return ret;
  }

  if(Check1TrackISO(reader)){
    g_Option.flags |= OPFLG_OUTSIDE;
  }

  LoadOption();
  ret = UISetting(&g_Option);
  SaveOption();

  MemFree(g_Option.readable_speed);
  g_Option.readable_speed=NULL;
  g_Option.num_readable_speed=0;
  MemFree(g_Option.writable_speed);
  g_Option.writable_speed=NULL;
  g_Option.num_writable_speed=0;
  return ret;
}

OPTIONS *GetOption()
{
  return &g_Option;
}


