/*
 * @file text.c
 * @brief ϊ
 * @author BananaJinn
 * @version $Id: text.c,v 1.7 2008/06/29 04:07:31 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#if defined(linux) || defined(__MINGW32__)
# include <stdio.h>
# include <libintl.h>
#elif defined(WIN32)
# include <windows.h>
static char stringBuffer[1024];
#elif defined(MACOSX)
# import <Cocoa/Cocoa.h>
#endif

#if defined(linux) || defined(__MINGW32__)
char *GetText(const char *string)
{
  return gettext(string);
}
#endif

#if defined(WIN32) && !defined(__MINGW32__)
char *GetText(int string_id)
{
  stringBuffer[0] = '\0';
  LoadString(NULL, string_id, stringBuffer, sizeof(stringBuffer));
  return stringBuffer;
}
#endif

#if defined(MACOSX)
const char *GetText(const char *string)
{
	NSString *nsString = [NSString stringWithCString: string];
	return [NSLocalizedString(nsString, @"") cString];
}
#endif

