/*
 * @file text.h
 * @brief ϊ
 * @author BananaJinn
 * @version $Id: text.h,v 1.12 2007/02/01 14:28:04 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __TEXT_H__
#define __TEXT_H__

#if defined(linux) || defined(__MINGW32__)
extern char *GetText(const char *string);
#elif defined(WIN32)
extern char *GetText(int string_id);
#elif defined(MACOSX)
extern const char *GetText(const char *string);
#endif

#define GT(s) GetText(s)

#if defined(linux) || defined(__MINGW32__) || defined(MACOSX)
# define MSG_WAITING_READY GT("Waiting ready")
# define MSG_INSERT_DISC GT("Insert disc")
# define MSG_QUICK_BLANK GT("Quick blank")
# define MSG_COMMAND_ERROR GT("Command error(%02Xh : %X/%02X/%02X)")
# define MSG_READER_ GT("Reader : ")
# define MSG_WRITER_ GT("Writer%d : ")
# define MSG_SPEED_ GT("%.1fx")
# define MSG_REMAINS_ GT(" remains=%d:%02d")
# define MSG_TOTAL_REMAINS_ GT(" total_remains=%d:%02d")
# define MSG_BUFFER_ GT(" buffer=%.1f%%")
# define MSG_CANT_GET_DISC_TYPE GT("Cannot get the disc type.")
# define MSG_CANT_CREATE_MULTITRACK_ISO GT("Cannot create ISO image of multi track.")
# define MSG_READING GT("Reading")
# define MSG_CANT_DAO GT("Because two or more tracks exist, it is not possible to record by DAO.\nDo you switch to the record by TAO?")
# define MSG_MIN_FORMAT GT("Min format")
# define MSG_FORMATTING GT("Formatting")
# define MSG_NOT_BLANK GT("It is not a blank disc.")
# define MSG_NOT_BLANK_QUICK_BLANK GT("It is not a blank disc. Execute quick blanking?")
# define MSG_CLOSE_SESSION GT("Close Session")
# define MSG_CLOSE_TRACK GT("Close Track")
# define MSG_SPINUP GT("spin up")
# define MSG_RETRY_ GT("retry:%d")
# define MSG_TRACK_ GT("track%d")
# define MSG_WRITING_LEAD_IN GT("Writing lead-in")
# define MSG_WRITING_CDTEXT GT("Writing CD-TEXT")
# define MSG_CANT_WRITE_CD_DAO GT("Sorry. Cannot write to CD by DAO.")
# define MSG_SOURCE_IS_BLANK GT("Source disc is a blank disc.")
# define MSG_CAPACITY_IS_INSUFFICIENT GT("Capacity is insufficient. Continue?")
# define MSG_TOTAL GT("Total")
# define MSG_NETWORK_ERROR_ GT("Network error %ld :")
# define MSG_ABORTED GT("Aborted.")
# define MSG_COMPLETE_SUCCESS_AND_EJECT GT("Process was complete successfully. Eject the disc?")
# define MSG_COMPLETE_SUCCESS GT("Process was complete successfully.")
# define MSG_ERROR_OCCURRED GT("Error occurred.")
# define MSG_ERROR_OCCURRED_CMDLOG GT("Error occurred. Create command log?")
# define MSG_MEM_ALLOC_ERROR GT("Memory allocation error.")
# define MSG_CANT_COPY_DIFFERENT_TYPE GT("Cannot copy onto a different disc type.")
# define MSG_CANT_OPEN_IMAGE GT("Cannot open image file.")
# define MSG_CANT_READ_IMAGE GT("Cannot read image file.")
# define MSG_CANT_WRITE_IMAGE GT("Cannot write image file.")
# define MSG_CODE_CONV_ERROR GT("Code convert error.")
# define MSG_UNKNOWN_COMMAND GT("Unknown command was received.")
# define MSG_INVALID_IMAGE_FILE GT("Invalid image file.")
#elif defined(WIN32)
# include "resource.h"
# define MSG_WAITING_READY GT(IDS_WAITING_READY)
# define MSG_INSERT_DISC GT(IDS_INSERT_DISC)
# define MSG_QUICK_BLANK GT(IDS_QUICK_BLANK)
# define MSG_COMMAND_ERROR GT(IDS_COMMAND_ERROR)
# define MSG_READER_ GT(IDS_READER_)
# define MSG_WRITER_ GT(IDS_WRITER_)
# define MSG_SPEED_ GT(IDS_SPEED_)
# define MSG_REMAINS_ GT(IDS_REMAINS_)
# define MSG_TOTAL_REMAINS_ GT(IDS_TOTAL_REMAINS_)
# define MSG_BUFFER_ GT(IDS_BUFFER_)
# define MSG_CANT_GET_DISC_TYPE GT(IDS_CANT_GET_DISC_TYPE)
# define MSG_CANT_CREATE_MULTITRACK_ISO GT(IDS_CANT_CREATE_MULTITRACK_ISO)
# define MSG_READING GT(IDS_READING)
# define MSG_CANT_DAO GT(IDS_CANT_DAO)
# define MSG_MIN_FORMAT GT(IDS_MIN_FORMAT)
# define MSG_FORMATTING GT(IDS_FORMATTING)
# define MSG_NOT_BLANK GT(IDS_NOT_BLANK)
# define MSG_NOT_BLANK_QUICK_BLANK GT(IDS_NOT_BLANK_QUICK_BLANK)
# define MSG_CLOSE_SESSION GT(IDS_CLOSE_SESSION)
# define MSG_CLOSE_TRACK GT(IDS_CLOSE_TRACK)
# define MSG_SPINUP GT(IDS_SPINUP)
# define MSG_RETRY_ GT(IDS_RETRY_)
# define MSG_TRACK_ GT(IDS_TRACK_)
# define MSG_WRITING_LEAD_IN GT(IDS_WRITING_LEAD_IN)
# define MSG_WRITING_CDTEXT GT(IDS_WRITING_CDTEXT)
# define MSG_CANT_WRITE_CD_DAO GT(IDS_CANT_WRITE_CD_DAO)
# define MSG_SOURCE_IS_BLANK GT(IDS_SOURCE_IS_BLANK)
# define MSG_CAPACITY_IS_INSUFFICIENT GT(IDS_CAPACITY_IS_INSUFFICIENT)
# define MSG_TOTAL GT(IDS_TOTAL)
# define MSG_NETWORK_ERROR_ GT(IDS_NETWORK_ERROR_)
# define MSG_ABORTED GT(IDS_ABORTED)
# define MSG_COMPLETE_SUCCESS_AND_EJECT GT(IDS_COMPLETE_SUCCESS_AND_EJECT)
# define MSG_COMPLETE_SUCCESS GT(IDS_COMPLETE_SUCCESS)
# define MSG_ERROR_OCCURRED GT(IDS_ERROR_OCCURRED)
# define MSG_ERROR_OCCURRED_CMDLOG GT(IDS_ERROR_OCCURRED_CMDLOG)
# define MSG_MEM_ALLOC_ERROR GT(IDS_MEM_ALLOC_ERROR)
# define MSG_CANT_COPY_DIFFERENT_TYPE GT(IDS_CANT_COPY_DIFFERENT_TYPE)
# define MSG_CANT_OPEN_IMAGE GT(IDS_CANT_OPEN_IMAGE)
# define MSG_CANT_READ_IMAGE GT(IDS_CANT_READ_IMAGE)
# define MSG_CANT_WRITE_IMAGE GT(IDS_CANT_WRITE_IMAGE)
# define MSG_CODE_CONV_ERROR GT(IDS_CODE_CONV_ERROR)
# define MSG_UNKNOWN_COMMAND GT(IDS_UNKNOWN_COMMAND)
# define MSG_INVALID_IMAGE_FILE GT(IDS_INVALID_IMAGE_FILE)
#endif

#endif /* !__TEXT_H__ */
