/**
 * @file main.c
 * @brief Linux󥽡ǥᥤ
 * @author BananaJinn
 * @version $Id: main.c,v 1.5 2008/06/17 15:22:21 bananajinn Exp $
 * ʣ̲
 * Copyright (c) 2004-2007 Kagetani Hideto(BananaJinn)
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <unistd.h>
#include <malloc.h>
#include <getopt.h>

#include "aspi.h"
#include "scan.h"
#include "cmd.h"
#include "cmdlog.h"
#include "ui.h"
#include "copydisc.h"
#include "messagebox.h"
#include <libintl.h>
#include "text.h"

static const char *g_argReader = NULL;
static const char *g_argWriter = NULL;
static int g_readSpeed = -1;
static int g_writeSpeed = -1;
static int g_testWrite = -1;
static int g_bufe = -1;
static int g_onTheFly = -1;
static int g_outside = -1;
static int g_dao = -1;
static const char *g_tmpDir = NULL;
static int g_batch = -1;

/**
 * @brief ֥Ԥ桼򤷤֤֤
 * @param[out] ppDrives ̤Υɥ饤
 * @param[out] pNum ̤Υɥ饤ֿ(֤ξʣˤʤ)
 * @param[in] writer Ͽ֤Υ󤫤ɤ(Ͽξ0ʳ)
 * @param[in] pReader Ͽ֥ξɼ֤뤿ɼ֤ꤹ
 * @retval RET_OK 
 * @retval RET_NG 顼ȯ
 */
static int scan_drive(DRIVEID **ppDrives, int *pNum, BOOL writer,
					  DRIVEID *pReader)
{
	SCAN_t *drives;
	int count;
	int index;
	char buf[8];
	int num_drive=0;

	drives = ScanDrive(writer);
	if(drives==NULL){
		return RET_NG;
	}

	for(count=0; strlen((char *)drives[count].inqdata)!=0; count++){
		printf("%d : %s\n", count+1, drives[count].inqdata);
	}

	if(writer){
		printf("A : %s\n", GT("All devices that have inserted disc for record"));
		/*"ϿѥǥѤ"*/
	}
	printf("I : %s\n", GT("ISO image file"));
	/*"ISO᡼ե"*/
	printf("E : %s\n", GT("Enban image file"));
	/*"ץ᡼ե"*/
	printf("N : %s\n", GT("Network"));	/* ͥåȥ */

	buf[0] = '\0';
	while(1){
		if(writer){
			printf("%s=", GT("Writer"));  /*  */
		}
		else{
			printf("%s=", GT("Reader"));  /* ɼ */
		}

		fgets(buf, sizeof(buf), stdin);
		if(writer && buf[0]=='A'){
			break;
		}
		if(buf[0]=='N' || buf[0]=='E' || buf[0]=='I'){
			break;
		}
		if(atoi(buf) > 0){
			break;
		}
	}

	if(buf[0] == 'A'){
		*ppDrives = NULL;
		for(count=0; strlen((char *)drives[count].inqdata)!=0; count++){
			if(pReader != NULL){
				if(drives[count].hid == pReader->hid  &&
				   drives[count].tid == pReader->tid){
					/* ɼ̵֤ */
					continue;
				}
			}
			*ppDrives = (DRIVEID *)realloc(*ppDrives,
										   (num_drive+1)*sizeof(DRIVEID));
			if(*ppDrives == NULL){
				free(drives);
				return RET_NG;
			}
			(*ppDrives[num_drive]).hid = drives[count].hid;
			(*ppDrives[num_drive]).tid = drives[count].tid;
			num_drive++;
		}
	}
	else{
		*ppDrives = (DRIVEID *)malloc(sizeof(DRIVEID));
		if(*ppDrives == NULL){
			free(drives);
			return RET_NG;
		}
		if(buf[0] == 'I'){
			/* ISO᡼ */
			(*ppDrives)->hid = HID_VIRTUAL;
			(*ppDrives)->tid = CMDDRVTYPE_ISO;
			num_drive = 1;
		}
		else if(buf[0] == 'E'){
			/* ץ᡼ */
			(*ppDrives)->hid = HID_VIRTUAL;
			(*ppDrives)->tid = CMDDRVTYPE_IMAGE;
			num_drive = 1;
		}
		else if(buf[0] == 'N'){
			/* ͥåȥ */
			(*ppDrives)->hid = HID_VIRTUAL;
			(*ppDrives)->tid = CMDDRVTYPE_NET;
			num_drive = 1;
		}
		else{
			/* ̾Υɥ饤 */
			index = atoi(buf)-1;
			if((index >= 0) && (index < count)){
				(*ppDrives)->hid = drives[index].hid;
				(*ppDrives)->tid = drives[index].tid;
				num_drive = 1;
			}
			else{
				free(drives);
				return RET_NG;
			}
		}
	}

	*pNum = num_drive;
	free(drives);

	return RET_OK;
}

/**
 * @brief ǥХʸ󤫤DRIVEID
 * @param[in] dev ǥХʸ
 * @return DRIVEIDΥݥ󥿤ݤ֤
 */
DRIVEID *GetDriveIDFromDeviceString(const char *dev)
{
	if(dev == NULL){
		return NULL;
	}

	DRIVEID *id = malloc(sizeof(DRIVEID));
	if(id == NULL){
		return NULL;
	}
	if(!strncmp(dev, "/dev/", 5)){
		if(GetDeviceIDByName(dev, &id->hid, &id->tid) != RET_OK){
			return NULL;
		}
		return id;
	}
	if(strchr(dev, ':') != NULL){
		/* ͥåȥ */
		id->hid = HID_VIRTUAL;
		id->tid = CMDDRVTYPE_NET;
		return id;
	}
	if(strlen(dev) >= 4){
		if(!strcmp(dev+strlen(dev)-4, ".emg")){
			id->hid = HID_VIRTUAL;
			id->tid = CMDDRVTYPE_IMAGE;
			return id;
		}
		if(!strcmp(dev+strlen(dev)-4, ".iso")){
			id->hid = HID_VIRTUAL;
			id->tid = CMDDRVTYPE_ISO;
			return id;
		}
	}

	free(id);
	return NULL;
}

/**
 * @brief ʣ̳
 * @param[in] arg_reader ɼֻ
 * @param[in] arg_writer ֻ
 */
void start_copy(const char *arg_reader, const char *arg_writer)
{
	DRIVEID *pReader=NULL, *pWriter=NULL;
	int ret;
	int reader_num=1, writer_num=1;

	if(arg_reader != NULL){
		pReader = GetDriveIDFromDeviceString(arg_reader);
		if(pReader == NULL){
			printf("%s : %s\n", GT("invalid device"), arg_reader);
		}
		else{
			g_argReader = arg_reader;
		}
	}
	if(pReader == NULL){
		/* ɼ */
		if(scan_drive(&pReader, &reader_num, FALSE, NULL) != RET_OK){
			printf("%s\n", GT("Error in the initialization of the drive."));
			return;
		}
	}

	if(arg_writer != NULL){
		pWriter = GetDriveIDFromDeviceString(arg_writer);
		if(pWriter == NULL){
			printf("%s : %s\n", GT("invalid device"), arg_writer);
		}
		else{
			g_argWriter = arg_writer;
		}
	}
	if(pWriter == NULL){
		/*  */
		if(scan_drive(&pWriter, &writer_num, TRUE, pReader) != RET_OK){
			printf("%s\n", GT("Error in the initialization of then writer drive."));
			free(pReader);
			return;
		}
	}

	/* ʣ̼¹ */
	ret = CopyDisc(pReader, pWriter, writer_num);
  
	free(pReader);
	free(pWriter);

	UIMeter1Initialize(NULL);
	UIMeter2Initialize(NULL);
}

static void initial_display(void)
{
	printf("%s version %s\n",
		   GT("EnbanFukusyaYa"), VERSION);
}

static int get_arg_yesno(const char *arg)
{
	if(arg == NULL){
		return -1;
	}
	if(!strcmp(arg, "yes") || !strcmp(arg, "1")){
		return 1;
	}
	if(!strcmp(arg, "no") || !strcmp(arg, "0")){
		return 0;
	}
	return -1;
}


int
main (int argc, char *argv[])
{
	struct option opt[] = {
		{ "help", no_argument, NULL, 'h' },
		{ "read-speed", required_argument, NULL, 'r' },
		{ "write-speed", required_argument, NULL, 'w' },
		{ "test", no_argument, NULL, 't' },
		{ "bufe", required_argument, NULL, 'b' },
		{ "on-the-fly", required_argument, NULL, 'f' },
		{ "outside", no_argument, NULL, 'o' },
		{ "dao", required_argument, NULL, 'd' },
		{ "tmp", required_argument, NULL, 'T' },
		{ "batch", no_argument, NULL, 'B' },
	};
	int opt_index;
	int ret;
	int help=0;
	const char *reader=NULL, *writer=NULL;

	setlocale(LC_ALL, "");
	bind_textdomain_codeset("EnbanFukusyaYa", NULL);
	textdomain("EnbanFukusyaYa");

	while(1){
		ret = getopt_long(argc, argv, "hr:w:tb:f:od:T:B", opt, &opt_index);
		if(ret < 0){
			break;
		}
		switch(ret){
		case 'r':
			if(optarg)
				g_readSpeed = atoi(optarg);
			break;
		case 'w':
			if(optarg)
				g_writeSpeed = atoi(optarg);
			break;
		case 't':
			g_testWrite = 1;
			break;
		case 'b':
			if(optarg){
				if((g_bufe = get_arg_yesno(optarg)) < 0)
					help = 1;
			}
			break;
		case 'f':
			if(optarg){
				if((g_onTheFly = get_arg_yesno(optarg)) < 0)
					help = 1;
			}
			break;
		case 'o':
			g_outside = 1;
			break;
		case 'd':
			if(optarg){
				if((g_dao = get_arg_yesno(optarg)) < 0)
					help = 1;
			}
			break;
		case 'T':
			g_tmpDir = optarg;
			break;
		case 'B':
			g_batch = 1;
			break;
		case 'h':
		default:
			help = 1;
		}
	}
	while(optind<argc){
		if(reader == NULL){
			reader = argv[optind];
		}
		else if(writer == NULL){
			writer = argv[optind];
		}
		optind++;
	}

	if(help){
		printf("usage: %s [option] read-device write-device\n", argv[0]);
		printf("\ndevice:\n");
		printf("\t/dev/hd?          IDE device.\n");
		printf("\t/dev/scd?         SCSI device.\n");
		printf("\tfile path(*.iso)  ISO image file.\n");
		printf("\tfile path(*.emg)  Enban image file.\n");
		printf("\t[hostname]:port   Network device.\n");
		printf("\noption:\n");
		printf("\t-h,--help                display this help message.\n");
		printf("\t-r,--read-speed=n        set read speed to n.\n");
		printf("\t-w,--write-speed=n       set write speed to n.\n");
		printf("\t-t,--test                test write mode.\n");
		printf("\t-b,--bufe={yes|no}       Buffer Underrun Free Enable.\n");
		printf("\t-f,--on-the-fly={yes|no} on-the-fly mode.\n");
		printf("\t-o,--outside             write to outside.(ISO image only)\n");
		printf("\t-d,--dao={yes|no}        disc at once.(DVD)\n");
		printf("\t-T,--tmp=dir             temporary directory.\n");
		printf("\t-B,--batch               non-interactive mode.\n");
		return 1;
	}

	OpenAspi();
	initial_display();
	start_copy(reader, writer);

	CloseAspi();

	return 0;
}


/**
 * ؿ
 */

/**
 * @brief ǻꤵ줿ɼ̾
 */
const char *GetArgReader()
{
	return g_argReader;
}

/**
 * @brief ǻꤵ줿̾
 */
const char *GetArgWriter()
{
	return g_argWriter;
}

/**
 * @brief ǻꤵ줿ɹ®٤
 */
int GetArgReadSpeed()
{
	return g_readSpeed;
}

/**
 * @brief ǻꤵ줿®٤
 */
int GetArgWriteSpeed()
{
	return g_writeSpeed;
}

/**
 * @brief ǻꤵ줿ƥȵϿ
 */
int GetArgTestWrite()
{
	return g_testWrite;
}

/**
 * @brief ǻꤵ줿BUFE
 */
int GetArgBUFE()
{
	return g_bufe;
}

/**
 * @brief ǻꤵ줿OnTheFly
 */
int GetArgOnTheFly()
{
	return g_onTheFly;
}

/**
 * @brief ǻꤵ줿¦Ͽ⡼ɻ
 */
int GetArgOutside()
{
	return g_outside;
}

/**
 * @brief ǻꤵ줿DAO
 */
int GetArgDAO()
{
	return g_dao;
}

/**
 * @brief ǻꤵ줿ǥ쥯ȥ
 */
const char *GetArgTempDirectory()
{
	return g_tmpDir;
}

/**
 * @brief ǻꤵ줿Хå⡼ɻ
 */
int GetArgBatchMode()
{
	return g_batch;
}
