/**
 * @file messagebox.c
 * @brief Linux󥽡ǥå
 * @author BananaJinn
 * @version $Id: messagebox.c,v 1.3 2007/10/02 16:51:47 bananajinn Exp $
 * ʣ̲
 * Copyright (c) 2004-2007 Kagetani Hideto(BananaJinn)
 */
#include <stdio.h>
#include <string.h>

#include "messagebox.h"
#include "text.h"
#include "main.h"

static void InputStdin(char *buf, int bufsize)
{
  char *wp;

  memset(buf, 0, bufsize);
  fgets(buf, bufsize, stdin);
  wp = strchr(buf, '\n');
  if(wp != NULL){
    *wp = '\0';
    return;
  }
  while(getchar() != '\n');
}

static int MessageBoxWithAbortRetryIgnore(const char *message,
					  const char *title,
					  int flags)
{
  char buf[8];

  while(1){
    printf("%s (Abort/Retry/Ignore)=", message);
    InputStdin(buf, sizeof(buf));
    switch(buf[0]){
    case 'A':
      return MBR_ABORT;
    case 'R':
      return MBR_RETRY;
    case 'I':
      return MBR_IGNORE;
    }
  }
}

static int MessageBoxWithOKCancel(const char *message,
				  const char *title,
				  int flags)
{
  char buf[8];

  while(1){
    printf("%s ([Ok]/Cancel)=", message);
    InputStdin(buf, sizeof(buf));
    switch(buf[0]){
    case '\0':
    case 'O':
      return MBR_OK;
    case 'C':
      return MBR_CANCEL;
    }
  }
}

static int MessageBoxWithRetryCancel(const char *message,
				     const char *title,
				     int flags)
{
  char buf[8];

  while(1){
    printf("%s (Retry/Cancel)=", message);
    InputStdin(buf, sizeof(buf));
    switch(buf[0]){
    case 'R':
      return MBR_RETRY;
    case 'C':
      return MBR_CANCEL;
    }
  }
}

static int MessageBoxWithYesNo(const char *message,
			       const char *title,
			       int flags)
{
  char buf[8];

  while(1){
    printf("%s ([Y]/N)=", message);
    InputStdin(buf, sizeof(buf));
    switch(buf[0]){
    case '\0':
    case 'Y':
      return MBR_YES;
    case 'N':
      return MBR_NO;
    }
  }
}

static int MessageBoxWithYesNoCancel(const char *message,
				     const char *title,
				     int flags)
{
  char buf[8];

  while(1){
    printf("%s ([Y]/N/Cancel)=", message);
    InputStdin(buf, sizeof(buf));
    switch(buf[0]){
    case '\0':
    case 'Y':
      return MBR_YES;
    case 'N':
      return MBR_NO;
    case 'C':
      return MBR_CANCEL;
    }
  }
}


static int MessageBoxWithOK(const char *message,
			    const char *title,
			    int flags)
{
  char buf[8];

  printf("%s", message);
  InputStdin(buf, sizeof(buf));
  return MBR_OK;
}



int MessageBoxDlg(const char *message, const char *title, int flags)
{
	int ret = MBR_CANCEL;
	int batch = GetArgBatchMode()==1;

	if(title==NULL)
		title=GT("EnbanFukusyaYa")/*"ʣ̲"*/;

	switch(flags & MBF_TYPEMASK){
	case MBF_TYPEABORTRETRYIGNORE:
		if(batch)
			ret = MBR_ABORT;
		else
			ret = MessageBoxWithAbortRetryIgnore(message, title, flags);
		break;
	case MBF_TYPEOKCANCEL:
		if(batch)
			ret = MBR_OK;
		else
			ret = MessageBoxWithOKCancel(message, title, flags);
		break;
	case MBF_TYPERETRYCANCEL:
		if(batch)
			ret = MBR_CANCEL;
		else
			ret = MessageBoxWithRetryCancel(message, title, flags);
		break;
	case MBF_TYPEYESNO:
		if(batch)
			ret = MBR_YES;
		else
			ret = MessageBoxWithYesNo(message, title, flags);
		break;
	case MBF_TYPEYESNOCANCEL:
		if(batch)
			ret = MBR_YES;
		else
			ret = MessageBoxWithYesNoCancel(message, title, flags);
		break;
	case MBF_TYPEOK:
		if(batch)
			ret = MBR_OK;
		else
			ret = MessageBoxWithOK(message, title, flags);
		break;
	}
	return ret;
}

