/**
 * @file ui.c
 * @brief Linux󥽡ǥ桼󥿡ե
 * @author BananaJinn
 * @version $Id: ui.c,v 1.3 2007/10/02 16:51:47 bananajinn Exp $
 * ʣ̲
 * Copyright (C) 2004-2007 Kagetani Hideto(BananaJinn)
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include "ui.h"
#include "messagebox.h"
#include "settingdlg.h"
#include "filedlg.h"
#include "netdlg.h"

BOOL UICheckAbort()
{
  return FALSE;
}

void UISetAbort()
{
}
void UIClearAbort()
{
}

int UIDispMessage(const char *message, int type)
{
	int ret = UIDMRET_OK;
	char buf[8];
	int batch = GetArgBatchMode()==1;

	if(type == UIDMT_ERROR){
		fputs("ERROR : ", stdout);
	}
	fputs(message, stdout);
	if(type == UIDMT_QUESTION){
		if(batch){
			fputs("(y/n)=y\n", stdout);
		}
		else{
			fputs("(y/n)=", stdout);
			fgets(buf, sizeof(buf), stdin);
			if((buf[0] != 'y') && (buf[0] != '\n')){
				ret = UIDMRET_CANCEL;
			}
		}
	}
	else{
		if(batch){
			fputs("\n", stdout);
		}
		else{
			fgets(buf, sizeof(buf), stdin);
		}
	}
	return ret;
}

void UIMeter1Initialize(const char *message)
{
}

void UIMeter2Initialize(const char *message)
{
}

void UIMeter1Update(float percentage)
{
}

void UIMeter2Update(float percentage)
{
}

void UIDispInfo(const char *message)
{
	if(message==NULL)
		message="";
	printf("\033[2K\033[1G%s", message);
	fflush(stdout);
}


int UISetting(OPTIONS *option)
{
	return SettingDlg(option);
}

int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix)
{
	int ret;

	ret=FileDialog(bOpen, filename, size, suffix);
	return ret==FDR_OK ? UIDMRET_OK : UIDMRET_CANCEL;
}

int UINetDialog(BOOL bServer, char *remote, int size, int *port_number)
{
	int ret;

	ret=NetDialog(bServer, remote, size, port_number);
	return ret==NDR_OK ? UIDMRET_OK : UIDMRET_CANCEL;
}

