/**
 * @file log.c
 * @brief ログ関係
 * @author BananaJinn
 * @version $Id: log.c,v 1.5 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#include <stdio.h>
#include <string.h>
#include <stdarg.h>
#if defined(WIN32)
# include <io.h>
#else
# include <pwd.h>
# include <unistd.h>
#endif
#ifdef linux
# include <fcntl.h>
#endif
#include <time.h>
#include "aspi.h"

#if defined(WIN32)
# define vsnprintf _vsnprintf
#endif

#if defined(WIN32)
# define FILENAME "\\enban-debug.log"
#else
# define FILENAME "/enban-debug.log"
#endif

static char *GetDebugLogPath()
{
	static char path[_MAX_PATH]="";
#if !defined(WIN32)
	struct passwd *pwent;
#endif

	if(strlen(path)==0){
#if defined(WIN32)
		GetCurrentDirectory(sizeof(path), path);
#else
		pwent = getpwuid(getuid());
		strncpy(path, pwent->pw_dir, sizeof(path));
		path[sizeof(path)-1] = '\0';
#endif
		if(strlen(path)+strlen(FILENAME)+1 >= sizeof(path)){
			return NULL;
		}
		strcat(path, FILENAME);
	}
	return path;
}

static FILE *OpenDebugFile()
{
	const char *fname = GetDebugLogPath();
	if(fname == NULL){
		return NULL;
	}
	return fopen(fname, "a");
}

void DebugLog(char *fmt, ...)
{
#ifdef DEBUGLOG
	va_list args;
	char str[512];
	time_t now;
	FILE *fp = OpenDebugFile();

	if(fp == NULL){
		return;
	}
	time(&now);
	strftime(str, sizeof(str)-1, "%Y/%m/%d %H:%M:%S : ", localtime(&now));
	fputs(str, fp);
	
	va_start(args, fmt);
	vsnprintf(str, sizeof(str), fmt, args);
	
	fputs(str, fp);
	fclose(fp);
#endif
}

void DebugDump(void *ptr, size_t size, const char *message)
{
	size_t index, index16;
	unsigned char *bytep = (unsigned char *)ptr;
	FILE *fp = OpenDebugFile();

	if(fp == NULL){
		return;
	}

	if(message != NULL){
		DebugLog("%s\n", message);
	}
	for(index=0; index<size; index++){
		index16 = index & 15;
		if(index16 == 0){
			fprintf(fp, "0x%08lX ", (long)(bytep+index));
		}
		else if(index16 == 8){
			fputs(" ", fp);
		}
		fprintf(fp, "%02X ", bytep[index]);
		if(index16 == 15){
			fputs("\n", fp);
		}
	}

	index16 = index & 15;
	if(index16 != 0){
		fputs("\n", fp);
	}
	fclose(fp);
}
