/**
 * @file mkisofs.h
 * @brief mkisofsによるISOイメージ作成
 * @auther BananaJinn
 * @version $Id: mkisofs.h,v 1.4 2010/11/09 15:32:27 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __MKISOFS_H__
#define __MKISOFS_H__

#include "aspi.h"
#include "osdepend.h"
#if defined(WIN32)
# include <windows.h>
#endif

typedef struct {
	BOOL started;		/**< 開始済みかどうか */
	OSD_PID fd_stdout;	/**< 標準出力 */
	OSD_PID fd_stderr;	/**< 標準エラー出力 */
	OSD_PID pid;		/**< プロセスID */
	BOOL video;			/**< DVD-videoかどうか */
	char *src_path;		/**< ISO作成ルートパス */
	char *volume;		/**< ボリュームラベル */
	char *error_message;	/**< エラーメッセージ */
} MKISOFS;

extern int MIFInitialize(MKISOFS *mif);
extern int MIFFree(MKISOFS *mif);
extern int MIFSetSrcPath(MKISOFS *mif, const char *src_path);
extern DWORD MIFGetBlockCount(MKISOFS *mif);
extern int MIFRead(MKISOFS *mif, BYTE *buff, DWORD len);
extern const char *MIFGetErrorMessage(MKISOFS *mif);

#endif /* !__MKISOFS_H__ */
