/**
 * @file option.h
 * @brief 複写設定
 * @author BananaJinn
 * @version $Id: option.h,v 1.14 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */
#ifndef __OPTION_H__
#define __OPTION_H__

#include <aspi.h>
#include "cmd.h"

typedef struct {
  int read_speed;	/* 0 で最大速/標準速 */
  int write_speed;	/* 0 で最大速/標準速 */
  BOOL bufe;		/* Buffer Underrun Free Enable */
  BOOL test_write;	/* Test write */
  BOOL on_the_fly;	/* on-the-fly */
  BOOL dao;		/* Disc at once */
  BYTE *readable_speed;	/* 読込可能速度配列 */
  int num_readable_speed;
  BYTE *writable_speed;	/* 書込可能速度配列 */
  int num_writable_speed;
  WORD flags;		/* 有効な項目を示す */
  char temppath[_MAX_PATH];
  BOOL outside;
} OPTIONS;

/* flags value */
#define OPFLG_BUFE	(1<<0)
#define OPFLG_TESTWRITE	(1<<1)
#define OPFLG_ONTHEFLY	(1<<2)
#define OPFLG_DAO	(1<<3)
#define OPFLG_TEMPPATH	(1<<4)
#define OPFLG_DVD	(1<<5)	// DVD系かどうか
#define OPFLG_BD	(1<<6)	// BD系かどうか
#define OPFLG_OUTSIDE	(1<<7)

#ifdef __cplusplus
extern "C" {
#endif
	
extern int SetOption(CMDDRIVE *reader, CMDDRIVE *writer, int disc_type);
extern OPTIONS *GetOption();

#if defined(WIN32)
void GetRegString(const char *key, char *string_ret, DWORD size);
void WriteRegString(const char *key, const char *string);
#endif /* WIN32 */

#ifdef __cplusplus
}
#endif


#endif /* !__OPTION_H__ */
