/**
 * @file text.c
 * @brief 文字列変換
 * @author BananaJinn
 * @version $Id: text.c,v 1.8 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2006 BananaJinn<banana@mxh.mesh.ne.jp>.
 */

#if defined(linux) || defined(__MINGW32__)
# include <stdio.h>
# include <libintl.h>
#elif defined(WIN32)
# include <windows.h>
static char stringBuffer[1024];
#elif defined(MACOSX)
# import <Cocoa/Cocoa.h>
#endif

#if defined(linux) || defined(__MINGW32__)
char *GetText(const char *string)
{
  return gettext(string);
}
#endif

#if defined(WIN32) && !defined(__MINGW32__)
char *GetText(int string_id)
{
  stringBuffer[0] = '\0';
  LoadString(NULL, string_id, stringBuffer, sizeof(stringBuffer));
  return stringBuffer;
}
#endif

#if defined(MACOSX)
const char *GetText(const char *string)
{
	NSString *nsString = [NSString stringWithCString: string];
	return [NSLocalizedString(nsString, @"") cString];
}
#endif

