/**
 * @file filedlg.c
 * @brief Linuxコンソール版ファイル選択入力
 * @author BananaJinn
 * @version $Id: filedlg.c,v 1.5 2010/11/01 14:58:33 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "text.h"
#include "typedefs.h"
#include "common.h"
#include "filedlg.h"
#include "main.h"

/**
 * @brief ファイル名選択入力
 * @param[in] bOpen ファイルを開くための選択の場合はTRUE、保存の場合はFALSE
 * @param[out] filename 選択入力したファイル名
 * @param[in] size ファイル名を格納するバッファのサイズ
 * @param[in] suffix ファイルマスクとする拡張子
 * @retval FDR_OK 選択完了
 * @retval FDR_CANCEL キャンセル
 * @note 現在は選択はできない。入力のみ。
 */
int FileDialog(int bOpen, char *filename, int size, const char *suffix)
{
  const char *title = bOpen ? GT("open file") : GT("save file");
  const char *a = NULL;

  a = bOpen ? GetArgReader() : GetArgWriter();
  if(a != NULL){
	  strncpy(filename, a, size-1);
	  filename[size-1] = '\0';
	  printf("%s : %s\n", title, filename);
	  return FDR_OK;
  }
#if 0
  char *mask=NULL;

  if(bOpen && suffix!=NULL){
    mask=(char *)malloc(strlen(suffix)+1+2);
  }
  if(mask!=NULL){
    strcpy(mask, "*.");
    strcat(mask, suffix);
  }
#endif
  InputString(title, filename, size);
  return FDR_OK;
}

/**
 * @brief フォルダ名入力
 * @param[out] filename 入力したフォルダ名
 * @param[in] size フォルダ名を格納するバッファのサイズ
 * @retval FDR_OK 入力完了
 * @retval FDR_CANCEL キャンセル
 */
int FolderDialog(char *filename, int size)
{
	const char *title = GT("select folder");
	InputString(title, filename, size);
	return FDR_OK;
}
