/**
 * @file netdlg.h
 * @brief ネットワーク設定入力
 * @author BananaJinn
 * @version $Id: netdlg.c,v 1.5 2010/11/01 14:58:33 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "cmd.h"
#include "netdlg.h"
#include "common.h"
#include "text.h"
#include "main.h"

#define DEFAULT_PORTNUMBER 11877

int NetDialog(int bServer, char *remote, int size, int *port_number)
{
  const char *a = NULL;

  printf("=== %s ===\n", GT("netdlg"));
  
  *remote = '\0';
  *port_number = DEFAULT_PORTNUMBER;

  a = bServer ? GetArgWriter() : GetArgReader();
  if(a != NULL){
	  const char *wp = strchr(a, ':');
	  if(wp == NULL){
		  if(!bServer){
			  strncpy(remote, a, size-1);
			  remote[size-1] = '\0';
		  }
	  }
	  else{
		  if(!bServer){
			  int remlen = wp-a;
			  if(size-1 < remlen){
				  remlen = size-1;
			  }
			  strncpy(remote, a, remlen);
			  remote[remlen] = '\0';
		  }
		  int p = atoi(wp+1);
		  if(p > 0){
			  *port_number = p;
		  }
	  }
	  if(!bServer){
		  printf("%s : %s\n", GT("Connect host"), remote);
	  }
	  printf("%s : %d\n", GT("Port number"), *port_number);
	  return NDR_OK;
  }

  if(!bServer){
	  InputString(GT("Connect host") /* 接続先アドレス */,
				  remote, size);
  }
  InputNumber(GT("Port number") /* ポート番号 */,
	      port_number);

  return NDR_OK;
}
