/**
 * @file settingdlg.c
 * @brief Linuxコンソール版オプション設定
 * @author BananaJinn
 * @version $Id: settingdlg.c,v 1.4 2010/11/01 14:58:33 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#include <stdlib.h>
#include <string.h>
#include "option.h"
#include "settingdlg.h"
#include "text.h"
#include "common.h"
#include "main.h"

static void PrintSettingInt(const char *name, int value)
{
	printf("%s:%d\n", name, value);
}

static void PrintSettingBool(const char *name, int value)
{
	printf("%s:%s\n", name, value ? "yes":"no");
}

static void PrintSettingString(const char *name, const char *value)
{
	printf("%s:%s\n", name, value);
}

static void InputSpeed(const char *name, int *value, BOOL dvd, BYTE *speeds, int num_speed)
{
  int i;
  char buf[5];

  printf("%s(", name);
  for(i=0; i<num_speed; i++){
    if(i>0){
      printf("/");
    }
    printf("%d%s", speeds[i], GT("x"));
  }
  printf("[0]=%s):", dvd ? GT("Normal Speed"):GT("Max Speed"));
  InputFromStdin(buf, sizeof(buf));
  *value = atoi(buf);
  return;
}

int SettingDlg(OPTIONS *option)
{
	int n;
	const char *p;
	int batch = GetArgBatchMode()==1;

	printf("=== %s ===\n", GT("Setting"));
	n = GetArgReadSpeed();
	if(n >= 0){
		option->read_speed = n;
		PrintSettingInt(GT("Read speed"), option->read_speed);
	}
	else if(batch){
		PrintSettingInt(GT("Read speed"), option->read_speed);
	}
	else{
		InputSpeed(GT("Read speed"),
				   &option->read_speed, option->flags & OPFLG_DVD,
				   option->readable_speed, option->num_readable_speed);
	}
	n = GetArgWriteSpeed();
	if(n >= 0){
		option->write_speed = n;
		PrintSettingInt(GT("Write speed"), option->write_speed);
	}
	else if(batch){
		PrintSettingInt(GT("Write speed"), option->write_speed);
	}
	else{
		InputSpeed(GT("Write speed"),
				   &option->write_speed, option->flags & OPFLG_DVD,
				   option->writable_speed, option->num_writable_speed);
	}
	if(option->flags & OPFLG_TESTWRITE){
		n = GetArgTestWrite();
		if(n >= 0){
			option->test_write = n==1;
			PrintSettingBool(GT("Test write"), option->test_write);
		}
		else if(batch){
			PrintSettingBool(GT("Test write"), option->test_write);
		}
		else{
			InputYesNo(GT("Test write"), &option->test_write);
		}
	}
	if(option->flags & OPFLG_BUFE){
		n = GetArgBUFE();
		if(n >= 0){
			option->bufe = n==1;
			PrintSettingBool(GT("Buffer underrun free enable"), option->bufe);
		}
		else if(batch){
			PrintSettingBool(GT("Buffer underrun free enable"), option->bufe);
		}
		else{
			InputYesNo(GT("Buffer underrun free enable"), &option->bufe);
		}
	}
	if(option->flags & OPFLG_ONTHEFLY){
		n = GetArgOnTheFly();
		if(n >= 0){
			option->on_the_fly = n==1;
			PrintSettingBool(GT("On the fly"), option->on_the_fly);
		}
		else if(batch){
			PrintSettingBool(GT("On the fly"), option->on_the_fly);
		}
		else{
			InputYesNo(GT("On the fly"), &option->on_the_fly);
		}
	}
	if(option->flags & OPFLG_DAO){
		n = GetArgDAO();
		if(n >= 0){
			option->dao = n==1;
			PrintSettingBool(GT("Disc at once"), option->dao);
		}
		else if(batch){
			PrintSettingBool(GT("Disc at once"), option->dao);
		}
		else{
			InputYesNo(GT("Disc at once"), &option->dao);
		}
	}
	if(option->flags & OPFLG_OUTSIDE){
		n = GetArgOutside();
		if(n >= 0){
			option->outside = n==1;
			PrintSettingBool(GT("Write to outside"), option->outside);
		}
		else if(batch){
			PrintSettingBool(GT("Write to outside"), option->outside);
		}
		else{
			InputYesNo(GT("Write to outside"), &option->outside);
		}
	}
	if(option->flags & OPFLG_TEMPPATH){
		p = GetArgTempDirectory();
		if(p != NULL){
			strncpy(option->temppath, p, sizeof(option->temppath)-1);
			option->temppath[sizeof(option->temppath)-1] = '\0';
			PrintSettingString(GT("Temporary directory"),
							   option->temppath);
		}
		else if(batch){
			PrintSettingString(GT("Temporary directory"),
							   option->temppath);
		}
		else{
			InputString(GT("Temporary directory"),
						option->temppath, sizeof(option->temppath));
		}
	}

	return RET_OK;
}

