/**
 * @file ui.h
 * @brief Linuxコンソール版ユーザインターフェース
 * @author BananaJinn
 * @version $Id: ui.h,v 1.3 2010/11/01 14:58:33 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */

#ifndef __UI_H__
#define __UI_H__

#include "option.h"

BOOL UICheckAbort();
void UISetAbort();
void UIClearAbort();
int UIDispMessage(const char *message, int type);
/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

extern void UIMeter1Initialize(const char *message);
extern void UIMeter2Initialize(const char *message);
extern void UIMeter1Update(float percentage);
extern void UIMeter2Update(float percentage);
extern void UIDispInfo(const char *message);
extern int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix);
extern int UIFolderDialog(char *filename, int size);
extern int UINetDialog(BOOL bServer, char *remote, int size, int *port_number);
extern int UISetting(OPTIONS *option);

#endif /* !__UI_H__ */
