/**
 * @file messagebox.h
 * @author BananaJinn
 * @version $Id: messagebox.h,v 1.2 2010/11/01 14:34:11 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#ifndef __MESSAGEBOX_H__
#define __MESSAGEBOX_H__

/* Return value */
#define MBR_OK		0
#define MBR_CANCEL	1
#define MBR_YES		2
#define MBR_NO		3
#define MBR_ABORT	4
#define MBR_RETRY	5
#define MBR_IGNORE	6

/* Flags */
#define MBF_TYPEMASK		0x000f
#define MBF_TYPEABORTRETRYIGNORE 0x0001	/* 中止/再試行/無視 */
#define MBF_TYPEOKCANCEL	0x0002  /* OK/キャンセル */
#define MBF_TYPERETRYCANCEL	0x0003  /* 再試行/キャンセル */
#define MBF_TYPEYESNO		0x0004  /* はい/いいえ */
#define MBF_TYPEYESNOCANCEL	0x0005  /* はい/いいえ/キャンセル */
#define MBF_TYPEOK		0x0006  /* OK */

#define MBF_ICONMASK		0x00f0
#define MBF_ICONEXCLAMATION	0x0010
#define MBF_ICONINFORMATION	0x0020
#define MBF_ICONQUESTION	0x0030
#define MBF_ICONSTOP		0x0040

extern gint16 MessageBoxDlg(const char *message, const char *title, guint16 flags);

#endif /* !__MESSAGEBOX_H__ */
