/**
 * @file osdepend.h
 * @brief OS依存処理
 * @author BananaJinn
 * @version $Id: osdepend.h,v 1.3 2010/11/05 17:24:03 bananajinn Exp $
 * 円盤複写屋
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#ifndef __OSDEPEND_H__
#define __OSDEPEND_H__

#include <unistd.h>
#include "aspi.h"

#define OSD_FD int
#define OSD_PID pid_t

extern BOOL OSDCreateProcess(const char *cmdline, OSD_PID *pid_ret,
							 OSD_FD *stdin_ret, OSD_FD *stdout_ret,
							 OSD_FD *stderr_ret);
extern BOOL OSDTerminateProcess(OSD_PID pid);
extern BOOL OSDWaitProcess(OSD_PID pid, int *exitcode_ret);
extern int OSDRead(OSD_FD fd_stdout, OSD_FD fd_stderr,
				   unsigned char *buff_stdout, int size_stdout,
				   char **stderr_ret);
extern void OSDFDClose(OSD_FD fd);

#endif /** !__OSDEPEND_H__ */
