/**
 * @file ui.cpp
 * @brief [U[C^[tF[X
 * @author BananaJinn
 * @version $Id: ui.cpp,v 1.6 2010/11/05 17:24:03 bananajinn Exp $
 * ~Օʉ
 * Copyright (C) 2004-2010 BananaJinn<banana@mxh.mesh.ne.jp>
 */
#include "stdafx.h"
#include <Shlobj.h>
#include "ui.h"
#include "ThemeMessageDlg.h"
#include "RemoteDlg.h"
#include "EnbanFukusya.h"

static BOOL g_bAbort=FALSE;
static HWND g_hWnd=NULL;

static void UIFlushMessage()
{
	MSG msg;
	while( PeekMessage( &msg, NULL, 0, 0, PM_REMOVE ) != 0 ){
		TranslateMessage( &msg );
		DispatchMessage( &msg );
	}
}

void UISetHWND(HWND hWnd)
{
	g_hWnd = hWnd;
}

BOOL UICheckAbort()
{
	UIFlushMessage();
	return g_bAbort;
}

void UISetAbort()
{
	g_bAbort=TRUE;
}

void UIClearAbort()
{
	g_bAbort=FALSE;
}


int UIDispMessage(const char *message, int type)
{
	CThemeSet *pThemeClass = ((CEnbanFukusyaApp *)AfxGetApp())->GetThemeClass();
	CThemeMessageDlg *pDlg;
	UINT nFlags=0;
	int ret;

	switch(type){
	case UIDMT_ERROR:
		nFlags = MB_ICONSTOP|MB_OK;
		break;
	case UIDMT_QUESTION:
		nFlags = MB_ICONQUESTION|MB_YESNO;
		break;
	default:
		nFlags = MB_OK;
	}
	pDlg = new CThemeMessageDlg;
	pDlg->SetTheme(pThemeClass);
	ret = pDlg->Disp(message, NULL, nFlags);

	delete pDlg;

	return (ret==IDOK||ret==IDYES) ? UIDMRET_OK : UIDMRET_CANCEL;
}

void UIMeter1Initialize(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER1INIT, (LPARAM)message);
}

void UIMeter2Initialize(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER2INIT, (LPARAM)message);
}

void UIMeter1Update(float percentage)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER1SETPOS,
				  (LPARAM)(percentage*10));
}

void UIMeter2Update(float percentage)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_METER2SETPOS,
				  (LPARAM)(percentage*10));
}

void UIDispInfo(const char *message)
{
	::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_DISPINFO, (LPARAM)message);
}


int UISetting(OPTIONS *option)
{
	return ::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_SETTING, (LPARAM)option);
}

int UIFileDialog(BOOL bOpen, char *filename, int size, const char *suffix)
{
	LPCTSTR lpszArg = NULL;

	/*
	 * R}hCł̎wmF
	 */
	if(bOpen){
		lpszArg = (LPCTSTR)::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_GETARGREADER, 0);
	}
	else{
		lpszArg = (LPCTSTR)::SendMessage(g_hWnd, WM_USER_UICTL, UICTL_GETARGWRITER, 0);
	}
	if(lpszArg != NULL){
		if(strlen(lpszArg) > 0){
			/* w肳Ă΂t@CƂĕԂ */
			strncpy(filename, lpszArg, size);
			filename[size-1] = '\0';
			return UIDMRET_OK;
		}
	}

	CString csFilter;
	if(suffix != NULL){
		csFilter.Format("%s files (*.%s)|*.%s|All Files (*.*)|*.*||", suffix, suffix, suffix);
	}
	else{
		csFilter = "All Files (*.*)|*.*||";
	}
	CFileDialog dlg(bOpen, suffix, filename, OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT,
					csFilter, NULL);
	if(dlg.DoModal()==IDOK){
		CString csFullPath = dlg.GetPathName();
		strncpy(filename, (LPCTSTR)csFullPath, size);
		filename[size-1] = '\0';
		return UIDMRET_OK;
	}
	return UIDMRET_CANCEL;				
}


int UIFolderDialog(char *filename, int size)
{
	BROWSEINFO bi;
	char buff[MAX_PATH];
	LPITEMIDLIST idList;
	BOOL bRet;
	
	ZeroMemory(&bi, sizeof(bi));
	bi.hwndOwner = AfxGetMainWnd()->m_hWnd;
	bi.pszDisplayName = buff;
	bi.lpszTitle = "tH_I";
	bi.ulFlags = BIF_RETURNONLYFSDIRS;
	idList = SHBrowseForFolder(&bi);
	if(idList != NULL){
		bRet = SHGetPathFromIDList(idList, buff);
		if(bRet != FALSE){
			strncpy(filename, buff, size);
			filename[size-1] = '\0';
			return UIDMRET_OK;
		}
	}
	return UIDMRET_CANCEL;
}


int UINetDialog(BOOL bServer, char *remote, int size, int *port_number)
{
	int nRetValue = UIDMRET_CANCEL;
	CThemeSet *pThemeClass = ((CEnbanFukusyaApp *)AfxGetApp())->GetThemeClass();
	CRemoteDlg *pDlg = new CRemoteDlg();
	pDlg->SetTheme(pThemeClass);
	pDlg->SetServerMode(bServer);
	int nRet = pDlg->DoModal();
	if(nRet == IDOK){
		nRetValue = UIDMRET_OK;
		if(bServer){
			*port_number = pDlg->GetPortNumber();
		}
		else{
			strncpy(remote, pDlg->GetRemoteAddress(), size);
			remote[size-1] = '\0';
			*port_number = pDlg->GetPortNumber();
		}
	}
	delete pDlg;
	return nRetValue;
}
