/**
 * ~Օʉ - EnbanKensa
 * Copyright (C) 2005 Kagetani Hideto
 * drive.h - fBXNnhCuANZX֘A`
 * $Date: 2005/12/11 15:25:30 $
 * $Revision: 1.5 $
 */
#ifndef __DRIVE_H__
#define __DRIVE_H__

#include "aspi.h"

#define CMDDRVCTYPE_UNKNOWN		-1
#define CMDDRVCTYPE_CHECKING	0
#define CMDDRVCTYPE_ATAPI		1
#define CMDDRVCTYPE_SCSI		2

#define SD_SENSEKEY(d)	(d->sense_data[2] & 0x0f)
#define SD_ASC(d)		(d->sense_data[12])
#define SD_ASCQ(d)		(d->sense_data[13])

/* return value */
#define RET_OK		0
#define RET_ABORT	1
#define RET_READFD	2
#define RET_COMPLETE	3
#define RET_NG		-1
#define RET_TIMEOUT -2
#define RET_CMDERR	-3
#define RET_MEMERR	-4
#define RET_SOCKET	-5

/* reqflag */
#define REQ_NODATA	0x18
#define REQ_DATAOUT	0x10
#define REQ_DATAIN	0x08

#define SENSEDATA_SIZE		0x20

typedef struct {
  DRIVE drive;
  BOOL own_alloc;	/* ̍\̂Ńobt@Ǘ */
  BYTE *data_buf;
  int bufsize;
  BYTE sense_data[SENSEDATA_SIZE];
  int cmd_type;		/* CMDDRVCTYPE_* */
  BYTE cmdcode;
  int disc_type;
} CMDDRIVE;


#ifdef __cplusplus
extern "C" {
#endif

extern int SendCmd(CMDDRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag);
extern int InitializeCmdDrive(CMDDRIVE *drive, int bufsize);
extern void FreeCmdDrive(CMDDRIVE *drive);
extern void CheckAtapi(CMDDRIVE *drive);
extern int SetDriveAspiSetting(CMDDRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern void SetDriveBuffer(CMDDRIVE *drive, char *data_buf, int bufsize);

#ifdef __cplusplus
}
#endif

#endif /* !__DRIVE_H__ */
