/* ~Ռ - EnbanKensa
 * Copyright (C) 2005-2006 Kagetani Hideto
 */

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <stdarg.h>
#include "ebstring.h"

char *EbStringNew(const char *string)
{
  return strdup(string);
}

char *EbStringNewWithFormat(const char *format, ...)
{
  va_list args;
  int bufsize=80;
  char *ret_string=NULL, *new_ptr;
  int ret;

  while(1){
    new_ptr = realloc(ret_string, bufsize);
    if(new_ptr == NULL){
      if(ret_string != NULL){
	free(ret_string);
      }
      return NULL;
    }
    ret_string = new_ptr;
    va_start(args, format);
#if defined(WIN32)
    ret = _vsnprintf(ret_string, bufsize, format, args);
#else
    ret = vsnprintf(ret_string, bufsize, format, args);
#endif
    va_end(args);
    if((ret > -1) && (ret < bufsize)){
      break;
    }
    if(ret > -1){
      bufsize = ret+1;
    }
    else{
      bufsize *= 2;
    }
  }
  return ret_string;
}

char *EbStringAppend(char *ebstring, const char *append_string)
{
  char *ret;
  int len;

  if(ebstring == NULL){
    return EbStringNew(append_string);
  }
  len = strlen(ebstring);
  ret = (char *)realloc(ebstring, len+strlen(append_string)+1);
  if(ret == NULL){
    return ebstring;
  }

  strcpy(ret+len, append_string);
  return ret;
}

char *EbStringAppendWithFormat(char *ebstring, const char *format, ...)
{
  va_list args;
  int offset=0;
  int bufsize=80;
  char *ret_string=ebstring, *new_ptr;
  int ret;

  if(ebstring != NULL){
    offset=strlen(ebstring);
    bufsize=strlen(ebstring)+80;
  }
  while(1){
    new_ptr = realloc(ret_string, bufsize);
    if(new_ptr == NULL){
      if(ret_string != NULL){
	free(ret_string);
      }
      return NULL;
    }
    ret_string = new_ptr;
    va_start(args, format);
#if defined(WIN32)
    ret = _vsnprintf(ret_string+offset, bufsize-offset, format, args);
#else
    ret = vsnprintf(ret_string+offset, bufsize-offset, format, args);
#endif
    va_end(args);
    if((ret > -1) && (ret < bufsize)){
      break;
    }
    if(ret > -1){
      bufsize = ret+1;
    }
    else{
      bufsize *= 2;
    }
  }
  return ret_string;
}

char *EbStringFree(char *ebstring)
{
  free(ebstring);
  return NULL;
}

char *EbStringGetString(const char *string, int len, char trim)
{
  char *ret_string = (char *)malloc(len+1);
  int i;

  strncpy(ret_string, string, len);
  ret_string[len] = '\0';

  if(trim != '\0'){
    for(i=len-1; i>=0; i--){
      if(ret_string[i] != trim){
	break;
      }
      ret_string[i] = '\0';
    }
  }

  return ret_string;
}
