#!/bin/bash
PROG=EnbanKensa
TMPDIR=/tmp/$PROG
if [ -e /etc/vine-release ]; then
  RPMTOP=/usr/src/vine
  RPMBUILD=rpmbuild
  SPECFILE=$PROG-vl.spec
else
  RPMTOP=/usr/src/redhat
  RPMBUILD=rpmbuild
  SPECFILE=$PROG-fc.spec
fi

if [ -f $HOME/.rpmmacros ]; then
  _RPMTOP=$(grep ^%_topdir $HOME/.rpmmacros)
  _RPMTOP=${_RPMTOP#*\ }
  eval _RPMTOP=$_RPMTOP
  if [ "$_RPMTOP" != "" ] && [ -d $_RPMTOP ]; then
    RPMTOP=$_RPMTOP
  fi
fi

SOURCE=`grep ^Source: $SPECFILE`
SOURCEFILE=${SOURCE##*:\ }
VERSION=`grep ^Version: $SPECFILE`
VERNUM=${VERSION##*:\ }
PROGDIR=$PROG"-"$VERNUM

make clean
rm -rf $TMPDIR
mkdir $TMPDIR
cp -pr ../../$PROG $TMPDIR/$PROGDIR
find $TMPDIR/$PROG"-"$VERNUM \( -name CVS -o -name '*~' \) -exec rm -rf {} \; \
	> /dev/null 2>&1
pushd $TMPDIR > /dev/null
tar zcf $SOURCEFILE $PROGDIR
rm -rf $PROGDIR
popd > /dev/null

cp $SPECFILE $RPMTOP/SPECS/
mv $TMPDIR/$SOURCEFILE $RPMTOP/SOURCES/

$RPMBUILD -ba $RPMTOP/SPECS/$SPECFILE
#$RPMBUILD --target i386 -ba $RPMTOP/SPECS/$SPECFILE
