/* ʣ̲ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * mainwindow.c - 祦ɥ
 * $Date: 2006/12/02 14:00:19 $
 * $Revision: 1.6 $
 */

#include <stdio.h>
#include <string.h>
#include <unistd.h>
#include <malloc.h>

#include "aspi.h"
#include "TitleLogo.xpm"
#include "scan.h"
#include "cmd.h"
#include "check.h"
#include "ui.h"
#include "messagebox.h"
#include "text.h"

#define DRAWAREA_WIDTH 640
#define DRAWAREA_HEIGHT 400

#if defined(USE_GTK2)
/*# define PANGOFONTNAME "gothic"*/
# define PANGOFONTNAME "sans"
#else
# define FIXED16FONTSET "-*-fixed-medium-r-normal--16--*"
#endif

static GtkWidget *g_MainWindow=NULL;
static GtkWidget *g_table=NULL;
static GtkWidget *g_btnStartKensa=NULL;
static GtkWidget *g_btnDiscInfo=NULL;
static GtkWidget *g_optMenu1=NULL;
static GtkWidget *g_labelInfo=NULL;
static GtkWidget *g_tableDiscInfo=NULL;
static GtkWidget *g_textDiscInfo=NULL;
static GtkWidget *g_drawArea=NULL;
static GdkPixmap *g_pixmapDrawArea=NULL;
static GdkGC *g_gc=NULL;
#if defined(USE_GTK2)
static PangoFontDescription *g_pangoDesc=NULL;
static PangoLayout *g_pangoLayout=NULL;
#endif
static GdkFont *g_fontSet=NULL;
static SCAN_t *g_ReaderList=NULL;
static BOOL g_bRunningCheck=FALSE;
UIWIDGETINFO g_widgetInfo;
static gint g_tableLeft=0;
static gint g_tableRight=0;
static gint g_tableTop=0;
static gint g_tableBottom=0;
static gchar **g_comments=NULL;
static gint g_numComment=0;

static void destroy_disc_info();

static int scan_drive(GtkWidget *optmenu)
{
  GtkWidget *menu;
  GtkWidget *menuitem;
  SCAN_t *drives;
  int count;

  drives = ScanDrive(FALSE);
  if(drives==NULL){
    return RET_NG;
  }

  gtk_option_menu_remove_menu(GTK_OPTION_MENU(optmenu));
  menu = gtk_menu_new();

  for(count=0; strlen(drives[count].inqdata)!=0; count++){
    menuitem = gtk_menu_item_new_with_label(drives[count].inqdata);
    gtk_object_set_user_data(GTK_OBJECT(menuitem), GINT_TO_POINTER(count));
    gtk_menu_append(GTK_MENU(menu), menuitem);
    gtk_widget_show(menuitem);
  }

  gtk_option_menu_set_menu(GTK_OPTION_MENU(optmenu), menu);

  g_ReaderList = drives;

  return RET_OK;
}

/*
 * Callbacks
 */
void
on_optionmenu1_map(GtkWidget *widget, gpointer user_data)
{
  scan_drive((GtkWidget *)user_data);
}

void
on_button1_clicked(GtkWidget *widget, gpointer user_data)
{
  DRIVEID drive;
  GtkWidget *menu;
  GtkWidget *menuitem;
  int sel_drive;
  int ret;

  if(g_bRunningCheck){
    UISetAbort();
    gtk_widget_set_sensitive(g_btnStartKensa, FALSE);
    return;
  }

  destroy_disc_info();
  
	  /* ɥ饤ּ */
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_optMenu1));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  sel_drive = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));

  drive.hid = g_ReaderList[sel_drive].hid;
  drive.tid = g_ReaderList[sel_drive].tid;

  UIClearAbort();
  g_bRunningCheck = TRUE;
  gtk_widget_set_sensitive(g_optMenu1, FALSE);
  gtk_widget_set_sensitive(g_btnDiscInfo, FALSE);
  /*  */
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnStartKensa)->child), GT("Abort"));

  ret = CheckDisc(&drive);
  
  gtk_widget_set_sensitive(g_btnStartKensa, TRUE);
  gtk_widget_set_sensitive(g_btnDiscInfo, TRUE);
  gtk_widget_set_sensitive(g_optMenu1, TRUE);
  /*  */
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnStartKensa)->child), GT("StartTest"));
  g_bRunningCheck = FALSE;
}

void
on_button2_clicked(GtkWidget *widget, gpointer user_data)
{
  DRIVEID drive;
  GtkWidget *menu;
  GtkWidget *menuitem;
  int sel_drive;
  int ret;

  destroy_disc_info();

  if(g_bRunningCheck){
    UISetAbort();
    gtk_widget_set_sensitive(g_btnDiscInfo, FALSE);
    return;
  }

	  /* ɥ饤ּ */
  menu = gtk_option_menu_get_menu(GTK_OPTION_MENU(g_optMenu1));
  menuitem = gtk_menu_get_active(GTK_MENU(menu));
  sel_drive = GPOINTER_TO_INT(gtk_object_get_user_data(GTK_OBJECT(menuitem)));

  drive.hid = g_ReaderList[sel_drive].hid;
  drive.tid = g_ReaderList[sel_drive].tid;

  UIClearAbort();
  g_bRunningCheck = TRUE;
  gtk_widget_set_sensitive(g_optMenu1, FALSE);
  gtk_widget_set_sensitive(g_btnStartKensa, FALSE);
	  /* "" ˤ */
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnDiscInfo)->child), GT("Abort"));

  ret = DisplayDiscInformation(&drive);
  
  gtk_widget_set_sensitive(g_btnStartKensa, TRUE);
  gtk_widget_set_sensitive(g_btnDiscInfo, TRUE);
  gtk_widget_set_sensitive(g_optMenu1, TRUE);
	  /* "ǥ" ᤹ */
  gtk_label_set_text(GTK_LABEL(GTK_BIN(g_btnDiscInfo)->child), GT("DiscInfo"));
  g_bRunningCheck = FALSE;
}


void
on_btnExit_clicked(GtkWidget *widget, gpointer user_data)
{
  destroy_disc_info();
  gtk_widget_destroy((GtkWidget *)user_data);
}

void
on_mainwindow_destroy(GtkWidget *widget, gpointer user_data)
{
  destroy_disc_info();
  if(g_ReaderList!=NULL){
    free(g_ReaderList);
    g_ReaderList = NULL;
  }
  if(g_gc != NULL){
    gdk_gc_destroy(g_gc);
    g_gc = NULL;
  }
  if(g_comments != NULL){
	gint i;
	for(i=0; i<g_numComment; i++){
	  g_free(g_comments[i]);
	}
	g_free(g_comments);
	g_comments = NULL;
  }
  
#if defined(USE_GTK2)
  if(g_pangoDesc != NULL){
    pango_font_description_free(g_pangoDesc);
    g_pangoDesc = NULL;
  }
#endif
  gtk_main_quit();
}

gboolean
on_drawingarea1_expose_event           (GtkWidget       *widget,
                                        GdkEventExpose  *event,
                                        gpointer         user_data)
{
  gdk_draw_pixmap(g_drawArea->window,
                  g_drawArea->style->fg_gc[GTK_WIDGET_STATE (g_drawArea)],
                  g_pixmapDrawArea,
                  event->area.x, event->area.y,
                  event->area.x, event->area.y,
                  event->area.width, event->area.height);
  return FALSE;
}

gboolean
on_window1_configure_event             (GtkWidget       *widget,
                                        GdkEventConfigure *event,
                                        gpointer         user_data)
{
  if(g_gc == NULL){
		/* GC */
	g_gc = gdk_gc_new(g_drawArea->window);
#if !defined(USE_GTK2)
	g_fontSet = gdk_fontset_load(FIXED16FONTSET);
	gdk_gc_set_font(g_gc, g_fontSet); 
#endif
  }
  
  if(g_pixmapDrawArea == NULL){
		/* ԥޥå */
	g_pixmapDrawArea = gdk_pixmap_new(g_drawArea->window,
									  g_drawArea->allocation.width,
									  g_drawArea->allocation.height,
									  -1);
	gdk_draw_rectangle (g_pixmapDrawArea,
						g_drawArea->style->black_gc,
						TRUE,
						0, 0,
						g_drawArea->allocation.width,
						g_drawArea->allocation.height);
#if defined(USE_GTK2)
	g_pangoLayout = gtk_widget_create_pango_layout(g_drawArea, NULL);
    /*printf("pango layout = %p\n", g_pangoLayout);*/
	g_pangoDesc = pango_font_description_from_string(PANGOFONTNAME);
	/*pango_font_description_set_absolute_size(g_pangoDesc, 16*PANGO_SCALE);*/
	pango_font_description_set_size(g_pangoDesc, 10*PANGO_SCALE);
	pango_layout_set_font_description(g_pangoLayout, g_pangoDesc);
#endif

	g_widgetInfo.label = g_labelInfo;
	g_widgetInfo.draw_area = g_drawArea;
	g_widgetInfo.pixmap_draw_area = g_pixmapDrawArea;
	g_widgetInfo.gc = g_gc;
#if defined(USE_GTK2)
	g_widgetInfo.layout = g_pangoLayout;
#else
	g_widgetInfo.font = g_fontSet;
#endif
  
	UISetWidgetInfo(&g_widgetInfo);
  }

  return TRUE;
}


void
on_list_cursor_changed(GtkWidget *widget, gpointer user_data)
{
	  /*  */
  GtkTreeIter iter;
  GtkTreeModel *model;
  GtkTreeSelection *selection;
  gint i;
  gint sel=-1;

  model = gtk_tree_view_get_model(GTK_TREE_VIEW(widget));
  selection = gtk_tree_view_get_selection(GTK_TREE_VIEW(widget));
  for(i=0; gtk_tree_model_iter_nth_child(model, &iter, NULL, i); i++){
	if(gtk_tree_selection_iter_is_selected(selection, &iter)){
	  sel = i;
	  break;
	}
  }
  if((sel < 0) || (sel >= g_numComment)){
	return;
  }

  GtkWidget *textview=g_textDiscInfo;
  /*printf("comment=%s\n", g_comments[sel]);*/
  
  gtk_text_buffer_set_text(gtk_text_view_get_buffer(GTK_TEXT_VIEW(textview)),
						   g_comments[sel], -1);
}


static void
destroy_disc_info()
{
  if(g_tableDiscInfo != NULL){
	gtk_widget_show(g_drawArea);
	gtk_widget_destroy(g_tableDiscInfo);
	g_tableDiscInfo = NULL;
  }
}


void
display_disc_information(void *trackInfo, int num_track)
{
  char *g_headers[] = {
	GT("Sess"), GT("Track"), GT("TrkStart"), GT("TrkEnd"), GT("TrkSize"),
	GT("PktSize"), GT("Mode") 
  };

  UITRACKINFO *uiTrackInfo = (UITRACKINFO *)trackInfo;
  GtkWidget *table;
  GtkWidget *scrolled;
  GtkWidget *list;
  GtkListStore *store;
  GtkTreeIter iter;
  GtkCellRenderer *cellrenderer;
  GtkWidget *textview;
  int i;

	  /* ΰɽˤ */
  gtk_widget_hide(g_drawArea);

	  /* ǥɽʤ */
  table = gtk_table_new(1, 2, FALSE);
  gtk_widget_ref(table);
  gtk_object_set_data_full(GTK_OBJECT(g_MainWindow), "discinfo_table", table,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(table);
  gtk_table_attach(GTK_TABLE(g_table), table,
				   g_tableLeft, g_tableRight,
				   g_tableTop, g_tableBottom,
				   (GtkAttachOptions)(GTK_EXPAND|GTK_FILL),
				   (GtkAttachOptions)(GTK_EXPAND|GTK_FILL), 0, 0);
  gtk_widget_set_size_request(table, DRAWAREA_WIDTH, DRAWAREA_HEIGHT);

	  /* ꥹ */
  scrolled = gtk_scrolled_window_new(NULL, NULL);
  gtk_widget_show(scrolled);
  gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW(scrolled),
								  GTK_POLICY_AUTOMATIC,
								  GTK_POLICY_AUTOMATIC);
  gtk_container_set_border_width(GTK_CONTAINER(scrolled), 1);
  gtk_table_attach(GTK_TABLE(table), scrolled, 0, 1, 0, 1,
				   (GtkAttachOptions)(GTK_EXPAND|GTK_FILL),
				   (GtkAttachOptions)(GTK_EXPAND|GTK_FILL), 0, 0);
  store = gtk_list_store_new(7,
							 G_TYPE_STRING,
							 G_TYPE_STRING,
							 G_TYPE_STRING,
							 G_TYPE_STRING,
							 G_TYPE_STRING,
							 G_TYPE_STRING,
							 G_TYPE_STRING);
  list = gtk_tree_view_new_with_model(GTK_TREE_MODEL(store));
  gtk_widget_show(list);
  gtk_container_add(GTK_CONTAINER(scrolled), list);
  cellrenderer = gtk_cell_renderer_text_new();
  for(i=0; i<sizeof(g_headers)/sizeof(char *); i++){
	gtk_tree_view_append_column(GTK_TREE_VIEW(list),
								gtk_tree_view_column_new_with_attributes(
								  g_headers[i], cellrenderer,"text", i, NULL));
  }
  gtk_signal_connect(GTK_OBJECT(list), "cursor_changed",
					 GTK_SIGNAL_FUNC(on_list_cursor_changed),
					 NULL);

  g_comments = g_malloc0(sizeof(gchar *)*num_track);
  g_numComment = num_track;
	  /* ǡꤹ */
  for(i=0; i<num_track; i++){
	gchar *str;
	gtk_list_store_append(GTK_LIST_STORE(store), &iter);
		/* session number */
	str = g_strdup_printf("%d", uiTrackInfo[i].session);
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 0, str, -1);
	g_free(str);
		/* track number */
	str = g_strdup_printf("%d", uiTrackInfo[i].track);
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 1, str, -1);
	g_free(str);
		/* start LBA */
	str = g_strdup_printf("0x%08lX", uiTrackInfo[i].start_lba);
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 2, str, -1);
	g_free(str);
		/* end LBA */
	str = g_strdup_printf("0x%08lX", uiTrackInfo[i].end_lba);
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 3, str, -1);
	g_free(str);
		/* track size */
	str = g_strdup_printf("0x%08lX", uiTrackInfo[i].blocks);
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 4, str, -1);
	g_free(str);
		/* packet size */
	str = g_strdup_printf("0x%08lX", uiTrackInfo[i].packet_size);
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 5, str, -1);
	g_free(str);
		/* mode */
	gtk_list_store_set(GTK_LIST_STORE(store), &iter, 6,
					   uiTrackInfo[i].mode, -1);
	g_comments[i] = g_strdup(uiTrackInfo[i].comment);
  }
  g_object_unref(store);

	  /* ƥɽΰ */
  textview = gtk_text_view_new();
  gtk_widget_show(textview);
  gtk_container_set_border_width(GTK_CONTAINER(textview), 1);
  gtk_table_attach(GTK_TABLE(table), textview, 0, 1, 1, 2,
				   (GtkAttachOptions)(GTK_EXPAND|GTK_FILL),
				   (GtkAttachOptions)(GTK_EXPAND|GTK_FILL), 0, 0);
  gtk_text_view_set_editable(GTK_TEXT_VIEW (textview), FALSE);
  gtk_text_view_set_wrap_mode(GTK_TEXT_VIEW (textview), GTK_WRAP_WORD);
  g_tableDiscInfo = table;
  g_textDiscInfo = textview;
}


GtkWidget*
create_mainwindow(void)
{
  GtkWidget *window1;
  GtkWidget *table1;
  GtkWidget *optionmenu1;
  GtkWidget *optionmenu1_menu;
  GtkWidget *label1;
  GtkWidget *label2;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *pixmap1;
  GtkWidget *drawingarea1;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;
  char ver_buf[32];
  gint32 row=0;

	  /* ᥤ󥦥ɥ */
  window1 = gtk_window_new (GTK_WINDOW_TOPLEVEL);
  gtk_object_set_data (GTK_OBJECT (window1), "window1", window1);
	  /* ׸ */
  gtk_window_set_title (GTK_WINDOW (window1), GT("EnbanKensa"));
  gtk_window_set_policy(GTK_WINDOW(window1), FALSE, FALSE, FALSE);

	  /* ѥơ֥ */
  table1 = gtk_table_new(5, 4, FALSE);
  gtk_widget_ref(table1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "table1", table1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(table1);
  gtk_container_add(GTK_CONTAINER(window1), table1);
  gtk_container_set_border_width(GTK_CONTAINER(table1), 10);
  gtk_table_set_row_spacings(GTK_TABLE(table1), 5);
  gtk_table_set_col_spacings(GTK_TABLE(table1), 5);

	  /*  */
  colormap = gtk_widget_get_colormap (window1);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask,
						    NULL, TitleLogo);
  pixmap1 = gtk_pixmap_new (gdkpixmap, mask);
  gdk_pixmap_unref (gdkpixmap);
  gdk_bitmap_unref (mask);

  gtk_widget_ref(pixmap1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "pixmap1", pixmap1,
			   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(pixmap1);
  gtk_table_attach(GTK_TABLE(table1), pixmap1, 4, 5, row, row+2,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  row++;

	  /* ٥ */
  label1 = gtk_label_new(GT("Drive select"));
  gtk_widget_ref(label1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "label1", label1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(label1);
  gtk_table_attach(GTK_TABLE(table1), label1, 0, 1, row, row+1,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

	  /* ץ˥塼 */
  optionmenu1 = gtk_option_menu_new();
  gtk_widget_ref(optionmenu1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "optionmenu1", optionmenu1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(optionmenu1);
  gtk_table_attach(GTK_TABLE(table1), optionmenu1, 1, 2, row, row+1,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_widget_set_usize (optionmenu1, 300, -2);
  optionmenu1_menu = gtk_menu_new();
  gtk_option_menu_set_menu(GTK_OPTION_MENU(optionmenu1), optionmenu1_menu);

	  /* ǥ */
  button2 = gtk_button_new_with_label(GT("DiscInfo"));
  gtk_widget_ref(button2);
  gtk_object_set_data_full(GTK_OBJECT(window1), "button2", button2,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(button2);
  gtk_table_attach(GTK_TABLE(table1), button2, 2, 3, row, row+1,
				   (GtkAttachOptions)GTK_SHRINK,
				   (GtkAttachOptions)(0), 0, 0);
  gtk_widget_set_size_request(button2, 80, -1);
  
	  /* ϥܥ */
  button1 = gtk_button_new_with_label(GT("StartTest"));
  gtk_widget_ref(button1);
  gtk_object_set_data_full(GTK_OBJECT(window1), "button1", button1,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(button1);
  gtk_table_attach(GTK_TABLE(table1), button1, 3, 4, row, row+1,
				   (GtkAttachOptions)GTK_SHRINK,
				   (GtkAttachOptions)(0), 0, 0);
  gtk_widget_set_size_request(button1, 80, -1);
  row++;

	  /* ΰ */
  drawingarea1 = gtk_drawing_area_new ();
  gtk_widget_ref (drawingarea1);
  gtk_object_set_data_full (GTK_OBJECT (window1), "drawingarea1", drawingarea1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (drawingarea1);
  g_tableLeft = 0;
  g_tableRight = 5;
  g_tableTop = row;
  g_tableBottom = row+1;
  gtk_table_attach(GTK_TABLE(table1), drawingarea1,
				   g_tableLeft, g_tableRight,
				   g_tableTop, g_tableBottom,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_widget_set_usize(drawingarea1, DRAWAREA_WIDTH, DRAWAREA_HEIGHT);
  row++;

	  /* åΰ */
  sprintf(ver_buf, "Version %s", VERSION);
  label2 = gtk_label_new (ver_buf);
  gtk_widget_ref (label2);
  gtk_object_set_data_full(GTK_OBJECT (window1), "label2", label2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label2);
  gtk_table_attach(GTK_TABLE(table1), label2, 0, 5, row, row+1,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

  gtk_misc_set_alignment(GTK_MISC(label2), 0.5, 0.5);


  gtk_signal_connect(GTK_OBJECT(optionmenu1), "map",
					 GTK_SIGNAL_FUNC(on_optionmenu1_map),
					 optionmenu1);
  gtk_signal_connect(GTK_OBJECT(button1), "clicked",
					 GTK_SIGNAL_FUNC(on_button1_clicked),
					 NULL);
  gtk_signal_connect(GTK_OBJECT(button2), "clicked",
					 GTK_SIGNAL_FUNC(on_button2_clicked),
					 NULL);
  gtk_signal_connect(GTK_OBJECT(window1), "destroy",
					 GTK_SIGNAL_FUNC(on_mainwindow_destroy),
					 NULL);
  gtk_signal_connect(GTK_OBJECT (drawingarea1), "expose_event",
					 GTK_SIGNAL_FUNC (on_drawingarea1_expose_event),
					 NULL);
  gtk_signal_connect (GTK_OBJECT (window1), "configure_event",
                      GTK_SIGNAL_FUNC (on_window1_configure_event),
                      NULL);

  g_btnStartKensa = button1;
  g_btnDiscInfo = button2;
  g_optMenu1 = optionmenu1;
  g_labelInfo = label2;
  g_MainWindow = window1;
  g_drawArea = drawingarea1;
  g_table = table1;

  return window1;
}


