/* ʣ̲ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * messagebox.c - åɽ
 * $Date: 2006/01/14 15:42:25 $
 * $Revision: 1.3 $
 */
#include <gtk/gtk.h>
#include <stdio.h>

#include "messagebox.h"
#include "appicon.xpm"
#include "exclamation.xpm"
#include "question.xpm"
#include "stop.xpm"
#include "text.h"

static GtkWidget *g_MessageBox = NULL;
static gboolean g_Done = FALSE;
static gint16 g_RetStatus = MBR_OK;
static gint16 g_RetCodes[3];

static GtkWidget* create_MessageBox (const char *message, const char *title, guint16 flags);


gint16 MessageBoxDlg(const char *message, const char *title, guint16 flags)
{
  if(title==NULL)
    title=GT("EnbanKensa");

  g_Done = FALSE;

  g_MessageBox = create_MessageBox(message, title, flags);
  if(g_MessageBox==NULL){
    return MBR_CANCEL;
  }

  while (!g_Done)
    gtk_main_iteration();

  if(g_MessageBox != NULL)
	gtk_widget_destroy(g_MessageBox);
  return g_RetStatus;
}

void MessageBoxOnBtn1(void)
{
  g_RetStatus = g_RetCodes[0];
  g_Done = TRUE;
}

void MessageBoxOnBtn2(void)
{
  g_RetStatus = g_RetCodes[1];
  g_Done = TRUE;
}

void MessageBoxOnBtn3(void)
{
  g_RetStatus = g_RetCodes[2];
  g_Done = TRUE;
}

void MessageBoxOnBtnCancel(void)
{
  g_RetStatus = MBR_CANCEL;
  g_Done = TRUE;
  g_MessageBox = NULL;
}

static GtkWidget*
create_MessageBox (const char *message, const char *title, guint16 flags)
{
  GtkWidget *MessageBox;
  GtkWidget *dialog_vbox1;
  GtkWidget *hbox2;
  GtkWidget *label1;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox3;
  GtkWidget *button1;
  GtkWidget *button2;
  GtkWidget *button3;
  GtkWidget *pixmap1;
  GdkPixmap *gdkpixmap;
  GdkBitmap *mask;
  GdkColormap *colormap;

  char *button1label=NULL;
  char *button2label=NULL;
  char *button3label=NULL;
  char **icondata=NULL;

  switch(flags & MBF_TYPEMASK){
  case MBF_TYPEABORTRETRYIGNORE:
    button1label = GT("Cancel");
    button2label = GT("Retry");
    button3label = GT("Ignore");
    g_RetCodes[0] = MBR_ABORT;
    g_RetCodes[1] = MBR_RETRY;
    g_RetCodes[2] = MBR_IGNORE;
    break;
  case MBF_TYPEOKCANCEL:
    button2label = GT("OK");
    button3label = GT("Cancel");
    g_RetCodes[0] = 0;
    g_RetCodes[1] = MBR_OK;
    g_RetCodes[2] = MBR_CANCEL;
    break;
  case MBF_TYPERETRYCANCEL:
    button2label = GT("Retry");
    button3label = GT("Cancel");
    g_RetCodes[0] = 0;
    g_RetCodes[1] = MBR_RETRY;
    g_RetCodes[2] = MBR_CANCEL;
  case MBF_TYPEYESNO:
    button2label = GT("Yes");
    button3label = GT("No");
    g_RetCodes[0] = 0;
    g_RetCodes[1] = MBR_YES;
    g_RetCodes[2] = MBR_NO;
    break;
  case MBF_TYPEYESNOCANCEL:
    button1label = GT("Yes");
    button2label = GT("No");
    button3label = GT("Cancel");
    g_RetCodes[0] = MBR_YES;
    g_RetCodes[1] = MBR_NO;
    g_RetCodes[2] = MBR_CANCEL;
    break;
  case MBF_TYPEOK:
    button3label = GT("OK");
    g_RetCodes[0] = 0;
    g_RetCodes[1] = 0;
    g_RetCodes[2] = MBR_OK;
    break;
  default:
    return NULL;
  }

  switch(flags & MBF_ICONMASK){
  case MBF_ICONEXCLAMATION:
    icondata = exclamation_xpm;
    break;
  case MBF_ICONINFORMATION:
    icondata = appicon_xpm;
    break;
  case MBF_ICONQUESTION:
    icondata = question_xpm;
    break;
  case MBF_ICONSTOP:
    icondata = stop_xpm;
    break;
  default:
    icondata = appicon_xpm;
  }

  MessageBox = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (MessageBox), "MessageBox", MessageBox);
  gtk_window_set_title (GTK_WINDOW (MessageBox), title);
  gtk_window_set_modal (GTK_WINDOW (MessageBox), TRUE);
  gtk_window_set_policy (GTK_WINDOW (MessageBox), FALSE, FALSE, FALSE);
  gtk_window_set_position (GTK_WINDOW (MessageBox), GTK_WIN_POS_CENTER);

  dialog_vbox1 = GTK_DIALOG (MessageBox)->vbox;
  gtk_object_set_data (GTK_OBJECT (MessageBox), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  hbox2 = gtk_hbox_new (FALSE, 0);
  gtk_widget_ref (hbox2);
  gtk_object_set_data_full (GTK_OBJECT (MessageBox), "hbox2", hbox2,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox2);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), hbox2, TRUE, TRUE, 0);

  /*  */
  colormap = gtk_widget_get_colormap(MessageBox);
  gdkpixmap = gdk_pixmap_colormap_create_from_xpm_d(NULL, colormap, &mask,
						    NULL, icondata);
  pixmap1 = gtk_pixmap_new(gdkpixmap, mask);
  gdk_pixmap_unref(gdkpixmap);
  gdk_bitmap_unref(mask);

  gtk_widget_ref (pixmap1);
  gtk_object_set_data_full (GTK_OBJECT (MessageBox), "pixmap1", pixmap1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (pixmap1);
  gtk_box_pack_start (GTK_BOX (hbox2), pixmap1, FALSE, TRUE, 0);

  label1 = gtk_label_new (message);
  gtk_widget_ref (label1);
  gtk_object_set_data_full (GTK_OBJECT (MessageBox), message, label1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (label1);
  gtk_box_pack_start (GTK_BOX (hbox2), label1, TRUE, TRUE, 10);
  gtk_label_set_line_wrap(GTK_LABEL(label1), TRUE);
  gtk_label_set_justify(GTK_LABEL(label1), GTK_JUSTIFY_LEFT);

  dialog_action_area1 = GTK_DIALOG (MessageBox)->action_area;
  gtk_object_set_data (GTK_OBJECT (MessageBox), "dialog_action_area1", dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox3 = gtk_hbox_new (FALSE, 10);
  gtk_widget_ref (hbox3);
  gtk_object_set_data_full (GTK_OBJECT (MessageBox), "hbox3", hbox3,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox3);
  gtk_box_pack_end (GTK_BOX (dialog_action_area1), hbox3, FALSE, FALSE, 0);

  if(button1label != NULL){
    button1 = gtk_button_new_with_label (button1label);
    gtk_widget_ref (button1);
    gtk_object_set_data_full (GTK_OBJECT (MessageBox), "button1", button1,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (button1);
    gtk_box_pack_start (GTK_BOX (hbox3), button1, FALSE, FALSE, 0);

    gtk_signal_connect (GTK_OBJECT (button1), "clicked",
			GTK_SIGNAL_FUNC (MessageBoxOnBtn1),
			NULL);
  }
  if(button2label != NULL){
    button2 = gtk_button_new_with_label (button2label);
    gtk_widget_ref (button2);
    gtk_object_set_data_full (GTK_OBJECT (MessageBox), "button2", button2,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (button2);
    gtk_box_pack_start (GTK_BOX (hbox3), button2, FALSE, FALSE, 0);

    gtk_signal_connect (GTK_OBJECT (button2), "clicked",
			GTK_SIGNAL_FUNC (MessageBoxOnBtn2),
			NULL);
  }
  if(button3label != NULL){
    button3 = gtk_button_new_with_label (button3label);
    gtk_widget_ref (button3);
    gtk_object_set_data_full (GTK_OBJECT (MessageBox), "button3", button3,
			      (GtkDestroyNotify) gtk_widget_unref);
    gtk_widget_show (button3);
    gtk_box_pack_start (GTK_BOX (hbox3), button3, FALSE, FALSE, 0);

    gtk_signal_connect (GTK_OBJECT (button3), "clicked",
			GTK_SIGNAL_FUNC (MessageBoxOnBtn3),
			NULL);
  }

  gtk_signal_connect(GTK_OBJECT(MessageBox), "destroy",
					 GTK_SIGNAL_FUNC(MessageBoxOnBtnCancel),
					 NULL);

  gtk_widget_show(MessageBox);

  return MessageBox;
}
