/* ʣ̲
 * Copyright (c) 2004 Kagetani Hideto
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "option.h"
#include "settingdlg.h"
#include "common.h"
#include "ok.xpm"
#include "ng.xpm"
#include "text.h"

static BOOL g_Done = FALSE;
static int g_RetCode = RET_OK;
static GtkWidget *g_CheckOut2In = NULL;
static GtkWidget *g_EntryReadRetry = NULL;
static OPTIONS *g_pOption = NULL;

static void
on_defrdretry_clicked(GtkWidget *widget, gpointer user_data)
{
  char buf[8];

  snprintf(buf, sizeof(buf), "%d", g_pOption->default_read_retry);
  gtk_entry_set_text (GTK_ENTRY (g_EntryReadRetry), buf);
}

static void
on_ok_clicked(GtkWidget *widget, gpointer user_data)
{
  g_RetCode = RET_OK;
  g_Done = TRUE;
}

static void
on_cancel_clicked(GtkWidget *widget, gpointer user_data)
{
  if(g_RetCode<0){
	g_RetCode = RET_ABORT;
	g_Done = TRUE;
  }
}

static void
set_options(OPTIONS *option)
{
  char buf[8];
  
  gtk_toggle_button_set_active(GTK_TOGGLE_BUTTON(g_CheckOut2In),
			       option->out2in);
  snprintf(buf, sizeof(buf), "%d", option->read_retry);
  gtk_entry_set_text (GTK_ENTRY (g_EntryReadRetry), buf);
  
  gtk_widget_set_sensitive(g_CheckOut2In,
						   (option->flag & OPFLG_OUT2IN)!=0);
  gtk_widget_set_sensitive(g_EntryReadRetry,
						   (option->flag & OPFLG_RDRETRY)!=0);
}

static void
get_options(OPTIONS *option)
{
  char buf[8];
  
  option->out2in =
	gtk_toggle_button_get_active(GTK_TOGGLE_BUTTON(g_CheckOut2In));

  strncpy(buf, gtk_entry_get_text(GTK_ENTRY(g_EntryReadRetry)), sizeof(buf));
  option->read_retry = (BYTE)atoi(buf);
}

static GtkWidget*
create_setting_dialog (void)
{
  GtkWidget *setting_dlg;
  GtkWidget *dialog_vbox1;
  GtkWidget *table1;
  GtkWidget *label_readretry;
  GtkWidget *entry_readretry;
  GtkWidget *check_out2in;
  GtkWidget *dialog_action_area1;
  GtkWidget *hbox1;
  GtkWidget *button_defrdretry;
  GtkWidget *button_ok;
  GtkWidget *button_cancel;

  setting_dlg = gtk_dialog_new ();
  gtk_object_set_data (GTK_OBJECT (setting_dlg), "setting_dlg", setting_dlg);
  /*  */
  gtk_window_set_title (GTK_WINDOW (setting_dlg), GT("Kensa Setting"));
  /*GTK_WINDOW (setting_dlg)->type = GTK_WINDOW_DIALOG;*/
  gtk_window_set_position (GTK_WINDOW (setting_dlg), GTK_WIN_POS_CENTER);
  gtk_window_set_modal (GTK_WINDOW (setting_dlg), TRUE);
  gtk_window_set_policy (GTK_WINDOW (setting_dlg), FALSE, FALSE, FALSE);

  dialog_vbox1 = GTK_DIALOG (setting_dlg)->vbox;
  gtk_object_set_data (GTK_OBJECT (setting_dlg), "dialog_vbox1", dialog_vbox1);
  gtk_widget_show (dialog_vbox1);

  table1 = gtk_table_new (2, 3, FALSE);
  gtk_widget_ref (table1);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "table1", table1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (table1);
  gtk_box_pack_start (GTK_BOX (dialog_vbox1), table1, TRUE, TRUE, 0);
  gtk_container_set_border_width (GTK_CONTAINER (table1), 10);
  gtk_table_set_row_spacings (GTK_TABLE (table1), 5);
  gtk_table_set_col_spacings (GTK_TABLE (table1), 5);

  /* 鸡 */
  check_out2in = gtk_check_button_new_with_label(GT("Check outside first"));
  gtk_widget_ref(check_out2in);
  gtk_object_set_data_full(GTK_OBJECT(setting_dlg), "check_out2in",
						   check_out2in,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(check_out2in);
  gtk_table_attach(GTK_TABLE(table1), check_out2in, 0, 2, 0, 1,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);

  /* ɼĩ */
  label_readretry = gtk_label_new(GT("Read retry count"));
  gtk_widget_ref(label_readretry);
  gtk_object_set_data_full(GTK_OBJECT(setting_dlg), "label_readretry",
						   label_readretry,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(label_readretry);
  gtk_table_attach(GTK_TABLE(table1), label_readretry, 0, 1, 1, 2,
				   (GtkAttachOptions)(GTK_FILL),
				   (GtkAttachOptions)(0), 0, 0);
  gtk_misc_set_alignment(GTK_MISC(label_readretry), 0, 0.5);

  entry_readretry = gtk_entry_new();
  gtk_widget_ref(entry_readretry);
  gtk_object_set_data_full(GTK_OBJECT(setting_dlg), "entry_readretry",
						   entry_readretry,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(entry_readretry);
  gtk_table_attach(GTK_TABLE(table1), entry_readretry, 1, 2, 1, 2,
				   (GtkAttachOptions) (GTK_EXPAND | GTK_FILL),
				   (GtkAttachOptions) (0), 0, 0);
  /* ִ᤹ͤ */
  button_defrdretry = gtk_button_new_with_label(GT("Restore default of drive"));
  gtk_widget_ref(button_defrdretry);
  gtk_object_set_data_full(GTK_OBJECT(setting_dlg), "button_defrdretry",
						   button_defrdretry,
						   (GtkDestroyNotify)gtk_widget_unref);
  gtk_widget_show(button_defrdretry);
  gtk_table_attach(GTK_TABLE(table1), button_defrdretry, 2, 3, 1, 2,
				   (GtkAttachOptions)GTK_FILL,
				   (GtkAttachOptions) (0), 0, 0);


  dialog_action_area1 = GTK_DIALOG (setting_dlg)->action_area;
  gtk_object_set_data (GTK_OBJECT (setting_dlg), "dialog_action_area1",
		       dialog_action_area1);
  gtk_widget_show (dialog_action_area1);
  gtk_container_set_border_width (GTK_CONTAINER (dialog_action_area1), 10);

  hbox1 = gtk_hbox_new (FALSE, 10);
  gtk_widget_ref (hbox1);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "hbox1", hbox1,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (hbox1);
  gtk_box_pack_end (GTK_BOX (dialog_action_area1), hbox1, FALSE, FALSE, 0);

  /*  */
  button_ok = xpm_button_new (setting_dlg, ok_xpm, GT("Start"));
  gtk_widget_ref (button_ok);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "button_ok",
							button_ok,
                            (GtkDestroyNotify) gtk_widget_unref);
  GTK_WIDGET_SET_FLAGS(button_ok, GTK_CAN_DEFAULT);
  gtk_widget_show (button_ok);
  gtk_box_pack_start (GTK_BOX (hbox1), button_ok, FALSE, FALSE, 0);

  /*  */
  button_cancel = xpm_button_new (setting_dlg, ng_xpm, GT("Cancel"));
  gtk_widget_ref (button_cancel);
  gtk_object_set_data_full (GTK_OBJECT (setting_dlg), "button_cancel",
			    button_cancel,
                            (GtkDestroyNotify) gtk_widget_unref);
  gtk_widget_show (button_cancel);
  gtk_box_pack_start (GTK_BOX (hbox1), button_cancel, FALSE, FALSE, 0);

  gtk_signal_connect(GTK_OBJECT(button_defrdretry), "clicked",
					 GTK_SIGNAL_FUNC(on_defrdretry_clicked),
					 NULL);
  gtk_signal_connect(GTK_OBJECT(button_ok), "clicked",
					 GTK_SIGNAL_FUNC(on_ok_clicked),
					 NULL);
  gtk_signal_connect(GTK_OBJECT(button_cancel), "clicked",
					 GTK_SIGNAL_FUNC(on_cancel_clicked),
					 NULL);
  gtk_signal_connect(GTK_OBJECT(setting_dlg), "destroy",
					 GTK_SIGNAL_FUNC(on_cancel_clicked),
					 NULL);

  gtk_widget_grab_default (button_ok);

  g_CheckOut2In = check_out2in;
  g_EntryReadRetry = entry_readretry;

  return setting_dlg;
}

int SettingDlg(OPTIONS *option)
{
  GtkWidget *setting_dialog;

  g_Done = FALSE;
  g_RetCode = -1;

  g_pOption = option;
  setting_dialog = create_setting_dialog();
  set_options(option);
  gtk_widget_show(setting_dialog);

  while(!g_Done)
    gtk_main_iteration();

  if(GTK_IS_WIDGET(setting_dialog)){
	get_options(option);
	gtk_widget_destroy(setting_dialog);
  }

  return g_RetCode;
}

