/* ʣ̲ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * ui.c - 桼󥿡ե
 * $Date: 2006/12/02 14:00:19 $
 * $Revision: 1.6 $
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include "ui.h"
#include "messagebox.h"
#include "settingdlg.h"
#include "mainwindow.h"

#define min(a,b) (a<b ? a:b)

static BOOL g_bAbort=FALSE;
static UIWIDGETINFO *g_WidgetInfo=NULL;

static void UIFlushMessage()
{
  /*gtk_main_iteration_do(FALSE);*/
    while(gtk_events_pending())
	gtk_main_iteration();
}

BOOL UICheckAbort()
{
    UIFlushMessage();
    return g_bAbort;
}

void UISetAbort()
{
    g_bAbort = TRUE;
}

void UIClearAbort()
{
    g_bAbort = FALSE;
}

int UIDispMessage(const char *message, int type)
{
    gint16 ret;
    guint16 flags;

    switch(type){
    case UIDMT_INFORMATION:
	flags = MBF_TYPEOK | MBF_ICONINFORMATION;
	break;
    case UIDMT_QUESTION:
	flags = MBF_TYPEYESNO | MBF_ICONQUESTION;
	break;
    case UIDMT_ERROR:
	flags = MBF_TYPEOK | MBF_ICONSTOP;
	break;
    default:
	flags = MBF_TYPEOK;
    }

    ret = MessageBoxDlg(message, NULL, flags);
    return (ret==MBR_OK || ret==MBR_YES) ? UIDMRET_OK : UIDMRET_CANCEL;
}

void UISetWidgetInfo(UIWIDGETINFO *widget_info)
{
    g_WidgetInfo = widget_info;
}


void UIDispInfo(const char *message, ...)
{
  va_list args;
  char *buf=NULL;
  int bufsize=80;
  int ret;

  if(message==NULL)
	message="";

  while(1){
    buf = (char *)realloc(buf, bufsize);
    if(buf==NULL){
      return;
    }
    va_start(args, message);
    ret = vsnprintf(buf, bufsize, message, args);
    va_end(args);
    if(ret > -1 && ret < bufsize){
      break;
    }
    if(ret > -1){
      bufsize = ret+1;
    }
    else{
      bufsize += 80;
    }
  }

  if(g_WidgetInfo!=NULL){
    gtk_label_set_text(GTK_LABEL(g_WidgetInfo->label), buf);
  }
  free(buf);
}

void UIDrawLine(int x0, int y0, int x1, int y1, const UICOLOR *color)
{
  GdkColor col;
  GdkRectangle redraw_area;

  if(g_WidgetInfo == NULL)
	return;
  
  col.red = color->red;
  col.green = color->green;
  col.blue = color->blue;
  gdk_color_alloc(gdk_colormap_get_system(), &col);
  gdk_gc_set_foreground(g_WidgetInfo->gc, &col);
  
  gdk_draw_line(g_WidgetInfo->pixmap_draw_area, g_WidgetInfo->gc,
				x0, y0, x1, y1);

  redraw_area.x = min(x0,x1);
  redraw_area.y = min(y0,y1);
  redraw_area.width = abs(x0-x1)+1;
  redraw_area.height = abs(y0-y1)+1;
  gtk_widget_draw(g_WidgetInfo->draw_area, &redraw_area);
}

void UIDrawBox(int x0, int y0, int x1, int y1, const UICOLOR *color, BOOL fill)
{
  GdkColor col;
  GdkRectangle redraw_area;

  if(g_WidgetInfo == NULL)
	return;
  
  col.red = color->red;
  col.green = color->green;
  col.blue = color->blue;
  gdk_color_alloc(gdk_colormap_get_system(), &col);
  gdk_gc_set_foreground(g_WidgetInfo->gc, &col);

  redraw_area.x = min(x0,x1);
  redraw_area.y = min(y0,y1);
  redraw_area.width = abs(x0-x1)+(fill ? 1:0);
  redraw_area.height = abs(y0-y1)+(fill ? 1:0);
  
  gdk_draw_rectangle(g_WidgetInfo->pixmap_draw_area, g_WidgetInfo->gc,
					 fill,
					 redraw_area.x, redraw_area.y,
					 redraw_area.width, redraw_area.height);
  
  gtk_widget_draw(g_WidgetInfo->draw_area, &redraw_area);
}

void UIDrawText(int x0, int y0, const UICOLOR *color, const char *text)
{
  GdkColor col;
  GdkRectangle redraw_area;
#if defined(USE_GTK2)
  int width, height;
#else
  gint lbearing, rbearing, width, ascent, descent;
#endif

  if(g_WidgetInfo == NULL)
	return;
  
  col.red = color->red;
  col.green = color->green;
  col.blue = color->blue;
  gdk_color_alloc(gdk_colormap_get_system(), &col);
  gdk_gc_set_foreground(g_WidgetInfo->gc, &col);

#if defined(USE_GTK2)
  pango_layout_set_text(g_WidgetInfo->layout, text, strlen(text));
  pango_layout_get_pixel_size(g_WidgetInfo->layout, &width, &height);
  gdk_draw_layout(g_WidgetInfo->pixmap_draw_area,
		  g_WidgetInfo->gc, x0, y0,
		  g_WidgetInfo->layout);
#else
  gdk_string_extents(g_WidgetInfo->font, text,
					 &lbearing, &rbearing,
					 &width, &ascent, &descent);

  gdk_draw_string(g_WidgetInfo->pixmap_draw_area,
				  g_WidgetInfo->font, g_WidgetInfo->gc,
				  x0, y0+ascent, text);
#endif
  redraw_area.x = x0;
  redraw_area.y = y0;
#if defined(USE_GTK2)
  redraw_area.width = width;
  redraw_area.height = height;
#else
  redraw_area.width = width;
  redraw_area.height = ascent+descent;
#endif
  gtk_widget_draw(g_WidgetInfo->draw_area, &redraw_area);
}

void UIGetDrawableSize(int *width, int *height)
{
  if(g_WidgetInfo==NULL){
	*width = 0;
	*height = 0;
	return;
  }

  *width = g_WidgetInfo->draw_area->allocation.width;
  *height = g_WidgetInfo->draw_area->allocation.height;
}


int UISetting(OPTIONS *option)
{
  return SettingDlg(option);
}

void UIDispDiscInfo(UITRACKINFO *uiTrackInfo, int num_track)
{
  display_disc_information(uiTrackInfo, num_track);
}

