/* ʣ̲ - EnbanKensa
 * Copyright (c) 2005 Kagetani Hideto
 * ui.c - 桼󥿡ե
 * $Date: 2006/11/26 15:24:21 $
 * $Revision: 1.5 $
 */
#ifndef __UI_H__
#define __UI_H__

#include <gtk/gtk.h>
#include "typedefs.h"
#include "option.h"

typedef struct {
  WORD session;
  WORD track;
  DWORD start_lba;
  DWORD end_lba;
  DWORD blocks;
  DWORD packet_size;
  char *mode;
  char *comment;
} UITRACKINFO;

typedef struct {
	unsigned short red;
	unsigned short green;
	unsigned short blue;
} UICOLOR;

typedef struct {
  GtkWidget *label;
  GtkWidget *draw_area;
  GdkPixmap *pixmap_draw_area;
  GdkGC *gc;
#if defined(USE_GTK2)
  PangoLayout *layout;
#else
  GdkFont *font;
#endif
} UIWIDGETINFO;


extern void UISetWidgetInfo(UIWIDGETINFO *widget_info);
extern BOOL UICheckAbort();
extern void UISetAbort();
extern void UIClearAbort();
extern int UIDispMessage(const char *message, int type);
/* type value */
#define UIDMT_INFORMATION	0
#define UIDMT_ERROR		1
#define UIDMT_QUESTION	2
/* return value */
#define UIDMRET_OK		0
#define UIDMRET_CANCEL	1

extern void UIDispInfo(const char *message, ...);
extern void UIDrawLine(int x0, int y0, int x1, int y1, const UICOLOR *color);
extern void UIDrawBox(int x0, int y0, int x1, int y1, const UICOLOR *color, BOOL fill);
extern void UIDrawText(int x0, int y0, const UICOLOR *color, const char *text);
extern void UIGetDrawableSize(int *width, int *height);
extern int UISetting(OPTIONS *option);
extern void UIDispDiscInfo(UITRACKINFO *uiTrackInfo, int num_track);

#endif /* !__UI_H__ */
