// DiscInfoDlg.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "enbankensa.h"
#include "DiscInfoDlg.h"
#include "ui.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDiscInfoDlg _CAO


CDiscInfoDlg::CDiscInfoDlg(CWnd* pParent /*=NULL*/)
	: CThemeDialog(CDiscInfoDlg::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDiscInfoDlg)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_DATA_INIT
}


void CDiscInfoDlg::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDiscInfoDlg)
	DDX_Control(pDX, IDC_LST_TRACKS, m_LstTracks);
	DDX_Control(pDX, IDC_EDT_INFO, m_EdtInfo);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(CDiscInfoDlg, CDialog)
	//{{AFX_MSG_MAP(CDiscInfoDlg)
	ON_NOTIFY(LVN_ITEMCHANGED, IDC_LST_TRACKS, OnItemchangedLstTracks)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

LPCTSTR const headers[] = {
	"Sess", "Track", "Jn", "I", "TCY", "pPbgTCY", "[h"
};

/////////////////////////////////////////////////////////////////////////////
// CDiscInfoDlg bZ[W nh

void CDiscInfoDlg::OnCancel() 
{
	// TODO: ̈ʒuɓʂȌ㏈ǉĂB
	
	//CDialog::OnCancel();
}

void CDiscInfoDlg::OnOK() 
{
	// TODO: ̈ʒuɂ̑̌ؗp̃R[hǉĂ
	
	//CDialog::OnOK();
}

BOOL CDiscInfoDlg::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	// TODO: ̈ʒuɏ̕⑫ǉĂ
	m_LstTracks.SetExtendedStyle(LVS_EX_FULLROWSELECT|LVS_EX_GRIDLINES);
	UINT nIndex;
	for(nIndex=0; nIndex<sizeof(headers)/sizeof(LPCTSTR); nIndex++){
		m_LstTracks.InsertColumn(nIndex, headers[nIndex]);
	}
	
	return TRUE;  // Rg[ɃtH[JXݒ肵ȂƂA߂l TRUE ƂȂ܂
	              // O: OCX vpeB y[W̖߂l FALSE ƂȂ܂
}

void CDiscInfoDlg::SetData(UIDISCINFO *pDiscInfo)
{
	UINT nIndex, nNewIndex;
	LVITEM item;
	CString csTmp;
	UITRACKINFO *pTrackInfo;

	::ZeroMemory(&item, sizeof(item));
	m_LstTracks.DeleteAllItems();
	m_csaTrackComment.RemoveAll();

	for(nIndex=0; nIndex<pDiscInfo->tracks; nIndex++){
		pTrackInfo = &pDiscInfo->track_info[nIndex];
		item.mask = LVIF_TEXT;
		item.iItem = nIndex;
		item.iSubItem = 0;
		csTmp.Format("%d", pTrackInfo->session);
		item.pszText = (LPTSTR)(LPCTSTR)csTmp;
		item.cchTextMax = csTmp.GetLength();
		nNewIndex = m_LstTracks.InsertItem(&item);
		
		csTmp.Format("%d", pTrackInfo->track);
		m_LstTracks.SetItemText(nNewIndex, 1, csTmp);

		csTmp.Format("0x%08lX", pTrackInfo->start_lba);
		m_LstTracks.SetItemText(nNewIndex, 2, csTmp);

		csTmp.Format("0x%08lX", pTrackInfo->end_lba);
		m_LstTracks.SetItemText(nNewIndex, 3, csTmp);

		csTmp.Format("0x%08lX", pTrackInfo->blocks);
		m_LstTracks.SetItemText(nNewIndex, 4, csTmp);

		csTmp.Format("0x%08lX", pTrackInfo->packet_size);
		m_LstTracks.SetItemText(nNewIndex, 5, csTmp);

		m_LstTracks.SetItemText(nNewIndex, 6, pTrackInfo->mode);

		csTmp = pTrackInfo->comment;
		csTmp.Replace("\n", "\r\n");
		m_csaTrackComment.Add(csTmp);
	}

	for(nIndex=0; nIndex<m_LstTracks.GetHeaderCtrl()->GetItemCount(); nIndex++){
		m_LstTracks.SetColumnWidth(nIndex, LVSCW_AUTOSIZE_USEHEADER);
	}

	m_LstTracks.SetItemState(0, LVIS_SELECTED|LVIS_FOCUSED, LVIS_SELECTED|LVIS_FOCUSED);
	m_EdtInfo.SetWindowText(m_csaTrackComment.GetAt(0));
}

void CDiscInfoDlg::OnItemchangedLstTracks(NMHDR* pNMHDR, LRESULT* pResult) 
{
	NM_LISTVIEW* pNMListView = (NM_LISTVIEW*)pNMHDR;
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	m_EdtInfo.SetWindowText(m_csaTrackComment.GetAt(pNMListView->iItem));
	
	*pResult = 0;
}
