/* ~Օʉ
 * Copyright (c) 2004 Kagetani Hideto
 */
#ifndef __ASPI_H__
#define __ASPI_H__

#include "typedefs.h"

// ASPI Command
#define CMD_TEST_UNIT_READY		0x00
#define CMD_REZERO_UNIT			0x01
#define CMD_REQUEST_SENSE		0x03
#define CMD_FORMAT_UNIT			0x04
#define CMD_READ6				0x08
#define CMD_SEEK6				0x0b
#define CMD_INQUIRY				0x12
#define CMD_MODE_SELECT6		0x15
#define CMD_RESERVE				0x16
#define CMD_RELEASE				0x17
#define CMD_MODE_SENSE6			0x1a
#define CMD_START_STOP			0x1b
#define CMD_RECIEVE_DIAG		0x1c
#define CMD_SEND_DIAG			0x1d
#define CMD_PREVENT_ALLOW		0x1e
#define CMD_READ_CAPACITY		0x25
#define CMD_READ10				0x28
#define CMD_SEEK10				0x2b
#define CMD_VERIFY				0x2f
#define CMD_PRE_FETCH			0x34
#define CMD_WRITE_BUFFER		0x3b
#define CMD_READ_BUFFER			0x3c
#define CMD_READ_SUBCHANNEL		0x42
#define CMD_READ_TOC			0x43
#define CMD_READ_HEADER			0x44
#define CMD_PLAY_AUDIO10		0x45
#define CMD_PLAY_AUDIO_MSF		0x47
#define CMD_PLAY_TRACK_INDEX	0x48
#define CMD_PLAY_RELATIVE10		0x49
#define CMD_PAUSE				0x4b
#define CMD_MODE_SELECT10		0x55
#define CMD_MODE_SENSE10		0x5a
#define CMD_PLAY_AUDIO12		0xa5
#define CMD_READ12				0xa8
#define CMD_PLAY_RELATIVE12		0xa9
#define CMD_SET_CD_SPEED		0xbb
#define CMD_MECHANISM_STATUS	0xbd
#define CMD_READ_CD				0xbe
#define CMD_READ_CD_DA			0xd4
#define CMD_READ_P_W_SUBCODE	0xd6
#define CMD_WRITE10				0x2a
#define CMD_WRITE12				0xaa
#define CMD_SYNCHRONIZE_CACHE	0x35
#define CMD_READ_DISC_INFO		0x51
#define CMD_READ_TRACK_INFO		0x52
#define CMD_RESERVE_TRACK		0x53
#define CMD_REPAIR_TRACK		0x58
#define CMD_READ_MASTER_CUE		0x59
#define CMD_CLOSE_TRACK_SESSION	0x5b
#define CMD_READ_BUFFER_CAPACITY	0x5c
#define CMD_SEND_CUE_SHEET		0x5d
#define CMD_SEND_OPC_INFOMATION	0x54
#define CMD_BLANK				0xa1
#define CMD_READ_CD_MSF			0xb9
#define CMD_AUDIO_SCAN			0xba
#define CMD_GET_CONFIGURATION	0x46
#define CMD_GET_PERFORMANCE		0x4C
#define CMD_READ_DVD_STRUCTURE	0xad
#define CMD_READ_FORMAT_CAPACITIES	0x23
#define CMD_REPORT_KEY			0xa4
#define CMD_SEND_EVENT			0xa2
#define CMD_SEND_KEY			0xa3
#define CMD_SET_READ_AHEAD		0xa7
#define CMD_SET_STREAMING		0xb6
#define CMD_SEND_DVD_STRUCTURE	0xbf


#define SENSEDATA_SIZE		0x20

typedef struct {
  BYTE cdb[12];
  BYTE snskey;
  BYTE asc;
  BYTE ascq;
  BYTE reqflag;
  DWORD datalen;
  BYTE *data;
  WORD repeat;
} CMDLOG;

typedef struct {
  int hid;
  int tid;
  DWORD timeout;
  int fd;
  BYTE *data_buf;
  int bufsize;
  BYTE sense_data[SENSEDATA_SIZE];
  BOOL atapi;
  BYTE cmdcode;
  CMDLOG *cmdlog;
  int cmdlog_size;
  int cmdlog_start;
  int cmdlog_end;
  DWORD cmdlog_maxdatalen;
} DRIVE;

#define SD_SENSEKEY(d)	(d->sense_data[2] & 0x0f)
#define SD_ASC(d)		(d->sense_data[12])
#define SD_ASCQ(d)		(d->sense_data[13])

/* return value */
#define RET_OK		0
#define RET_ABORT	1
#define RET_NG		-1
#define RET_TIMEOUT -2
#define RET_CMDERR	-3
#define RET_MEMERR	-4

/* reqflag */
#define REQ_NODATA	0x18
#define REQ_DATAOUT	0x10
#define REQ_DATAIN	0x08

extern int OpenAspi(void);
extern void CloseAspi(void);
extern int InitializeDrive(DRIVE *drive, int bufsize, int cdblog_size);
extern void FreeDrive(DRIVE *drive);
extern int SetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern void GetAspiSetting(DRIVE *drive, int *ha, int *tg, DWORD *timeout);
extern int SendCmd(DRIVE *drive, BYTE *cdb, DWORD buflen, BYTE reqflag);
extern int GetHostAdapterCount(void);
extern int GetMaxTarget(void);


#endif /* !__ASPI_H__ */
