/* gchar.c
   Copyright (C) 2007
   NAKANISHI Shin

   This file is part of SBL.

   SBL is free software; you can redistribute it and/or
   modify it under the terms of the GNU Lesser General Public License
   as published by the Free Software Foundation; either version 2.1 of
   the License, or (at your option) any later version.

   SBL is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Lesser General Public License for more details.

   You should have received a copy of the GNU Lesser General Public
   License along with SBL; if not, write to the Free
   Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA
   02111-1307, USA.  */

#include <btron.h>

ERR gset_chp(GID gid, W x, W y, Bool abs)
{
  extern W gchar_x, gchar_y;

  if (abs == 0) {
    gchar_x = gchar_x + x;
    gchar_y = gchar_y + y;
  } else {
    gchar_x = x;
    gchar_y = y;
  }
  return 0;
}

ERR gset_chc(GID gid, COLOR fgc, COLOR bgc)
{
  extern UW gchar_fgc, gchar_bgc;

  gchar_fgc = BLACK; /*  */
  gchar_bgc = WHITE; /*  */
  return 0;
}

ERR gset_fon(GID gid, FSSPEC *fnt)
{
  /* ҤȤޤꤷʤ */
  return 0;
}

WERR gdra_str(GID gid, TC *str, W len, DCM mode)
{
  extern W gchar_x, gchar_y;
  extern UW gchar_fgc;

#ifdef NOGID
  ex_draw_string(gchar_x + swin_x, gchar_y + swin_y, str, gchar_fgc, 0);
#else
  ex_draw_string(gchar_x, gchar_y, str, gchar_fgc, 0);
#endif /* NOGID */
  return 0;
}

WERR gdra_stp(GID gid, W x, W y, TC *str, W len, DCM mode)
{
#ifdef NOGID
  ex_draw_string(x + swin_x, y + swin_y, str, 0, 0);
#else
  ex_draw_string(x, y, str, 0, 0);
#endif /* NOGID */
  return 0;
}

#ifdef SBLTEST
int main(void)
{
  static TC buf[] = "abcdefg";
  GID gid0 = 1;

  gset_chp(gid0, 100, 50, 1);
  gset_chc(gid0, 0x10000000, -1);
  gdra_str(gid0, buf, 8, G_STORE);
  gset_chp(gid0, 100, 50, G_STORE);
  gdra_str(gid0, buf, 8, G_STORE);
  gdra_stp(gid0, 10, 10, buf, 8, G_STORE);
  return 0;
}
#endif /* SBLTEST */
