$KCODE = 'UTF-8'
require 'tk_sdl'
require 'pdbFile'
require 'molvie_ver'
require 'keyboard_Func'
require 'mouse_func'
require 'molvieDisplay'
require "opengl"
require "glut"

class GLmolvieFrame

	def frame_create
		#GUIのウィンドウフレームの作成	
		$menuFrame = TkFrame.new { |f|
			#pack('fil'=>'x','side'=>'top')
			#各種メニューボタンの作成
			#”ファイル”ボタンの作成
			TkMenubutton.new(f, 'text'=>'ファイル', 'underline'=>0) {|btn|
				pack('side'=> 'left')
				btn.menu(menu = TkMenu.new(btn, 'tearoff'=>false))
				menu.add('command','label'=>'ファイルを開く','command'=>proc{
					PdbFile.new.file_read;
					Molvie_ver.new.molvie_Viewer				
			})
				menu.add('command', 'label'=>'終了', 'command'=>proc{MolvieRuby::lmolvieKeyboard('q'[0], 0,0)})
			}
			#”モード”ボタンの作成
			TkMenubutton.new(f, 'text'=>'モード', 'underline'=>0){|btn|
				pack('side'=> 'left')
				btn.menu(menu = TkMenu.new(btn, 'tearoff'=>false))
				menu.add('command','label'=>'molvie_Viewer','command'=>proc{Molvie_ver.new.molvie_Viewer})
				menu.add('command','label'=>'molvie_Projection','command'=>proc{Molvie_ver.new.molvie_Projection})
				menu.add('command','label'=>'molvie_Fly','command'=>proc{Molvie_ver.new.molvie_Flight})
				menu.add('command', 'label'=>'molvie_MrcViewer', 'command'=>proc{Molvie_ver.new.molvie_MrcViewer})
				menu.add('command', 'label'=>'molvie_Dock', 'command'=>proc{Molvie_ver.new.molvie_Dock})
			}
			#”表示”ボタンの作成
			TkMenubutton.new(f, 'text'=>'表示', 'underline'=>0){|btn|
				pack('side'=> 'left')
				btn.menu(menu = TkMenu.new(btn, 'tearoff'=>false))
				menu.add('command','label'=>'スペースフィル::原子で色分け','command'=>proc{ MolvieRuby::lmolvieKeyboard('1'[0], 0,0) })
				menu.add('command','label'=>'スペースフィル::Ｎ端Ｃ端色分け','command'=>proc{ MolvieRuby::lmolvieKeyboard('2'[0], 0,0) })
				menu.add('command','label'=>'スペースフィル::アミノ酸色分け','command'=>proc{ MolvieRuby::lmolvieKeyboard('3'[0], 0,0) })
				menu.add('command','label'=>'スペースフィル::温度因子','command'=>proc{ MolvieRuby::lmolvieKeyboard('4'[0], 0,0) })
				menu.add('command','label'=>'バックボーン::Ｎ端Ｃ端色分け','command'=>proc{ MolvieRuby::lmolvieKeyboard('5'[0], 0,0) })
				menu.add('command','label'=>'バックボーン::アミノ酸色分け','command'=>proc{ MolvieRuby::lmolvieKeyboard('6'[0], 0,0) })
				menu.add('command','label'=>'バックボーン::温度因子','command'=>proc{ MolvieRuby::lmolvieKeyboard('7'[0], 0,0) })
				menu.add('command','label'=>'ワイヤーフレーム','command'=>proc{ MolvieRuby::lmolvieKeyboard('9'[0], 0, 0) })
			}
			#”表示オプション”ボタンの作成
			TkMenubutton.new(f, 'text'=>'表示オプション', 'underline'=>0){|btn|
				pack('side'=> 'left')
				btn.menu(menu = TkMenu.new(btn, 'tearoff'=>false))
				menu.add('command','label'=>'炭素表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('c'[0], 0,0) })
				menu.add('command','label'=>'酸素表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('o'[0], 0,0) })
				menu.add('command','label'=>'窒素表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('n'[0], 0,0) })
				menu.add('command','label'=>'硫黄表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('s'[0], 0,0) })
				menu.add('command','label'=>'リン表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('p'[0], 0,0) })
				menu.add('command','label'=>'水素表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('h'[0], 0,0) })
				menu.add('command','label'=>'鉄・その他表示/非表示切り替え','command'=>proc{ MolvieRuby::lmolvieKeyboard('f'[0], 0,0) })
			}
		}
		$menuFrame.pack('fil'=>'x','side'=>'top')
		#SDL用のTkフレームの作成
		$displayFrame = TkFrame.new(nil, 'container'=>true)
		$displayFrame.pack('fill'=>'both','expand'=>'true')
		frame = $displayFrame

		SDL.init(SDL::INIT_EVERYTHING)			#SDLの初期化
		if(SDL.inited_system(SDL::INIT_EVERYTHING))	
		    puts "Success\n"
		else
	    	puts "Fail\n"
		end
		
		#TkフレームでSDLを機能させる、この際のSDLはOPENGLモード
		SDL.run_on_tk($displayFrame) 
		videoInfo = SDL.video_info;
		if(!videoInfo)
			puts "Video query failed:",SDL::GetError(),"\n"
		end
				
		width = 600
		height =600
		bpp=SDL.checkVideoMode(width,height,32,SDL::OPENGL)
		SDL.set_GL_attr(SDL::GL_DOUBLEBUFFER,1)
		w = SDL::Screen.open(width, height, bpp, SDL::OPENGL)
		GLUT.Init
		
		
		###マウスファンクション###
		frame.bind(
			'Button', 
			proc{|b,f,x,y| MolvieRuby.lmolvieMouse(b-1,0,x,y)},
			"%b %f %x %y")
		frame.bind(
			'ButtonRelease', 
			proc{|b,f,x,y| MolvieRuby.lmolvieMouse(b-1,1,x,y)},
			"%b %f %x %y")
		frame.bind(
			'B1-Motion', 
			proc{|x, y| MolvieRuby.lmolvieMouseMotion(x, y)},
			"%x %y")
		frame.bind(
			'B3-Motion', 
			proc{|x, y| MolvieRuby.lmolvieMouseMotion(x, y)},
			"%x %y")
		
		###キーボードファンクション###
		#frame.bind('Enter',proc {},)
		Tk.root.bind(
			'KeyPress', 
			proc{|a,k,n| MolvieRuby::lmolvieKeyboard(a[0], k, n) },
			"%A %k %N")
	   	## Tkループをスレッド化 	
		tk_thread = Thread.new {
			puts "Tkmainloop Start!\n"
			Tk.mainloop
			puts "Tkmainloop End\n"
		}
		## SDLループをスレッド化 
		sdl_thread = Thread.new {
			puts "SDL-Thread Start !"
			loop {
				puts "SDL-Thread in Loop Start !"
				MolvieDisplay.new.display(width,height);
				puts "SDL-Thread Loop !"		
  			}	
			puts "SDL-Thread End !"
		}		
		tk_thread.join
		sdl_thread.join
	end
end

