/*
# dmFile.h : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : dmFile.h 
# Attention
#   $Loccker$
#  	$State$ 
#
*/
/* $Log$ */
#ifndef DMFILE_H 
#define DMFILE_H 

#include <stdio.h>

/* constant begin */


/* constant end */

/* struct begin */

typedef __int64_t dmFileInteger8; 
typedef __int32_t dmFileInteger4; 
typedef __int16_t dmFileInteger2; 
typedef __int8_t  dmFileInteger1; 

typedef enum dmFileTagDataType {
	dmFileTagDataTypeShort=2,
	dmFileTagDataTypeLong =3,
	dmFileTagDataTypeUShort =4,
} dmFileTagDataType;

// Header
typedef struct dm3FileHeader {
	dmFileInteger4 version;
	dmFileInteger4 rootLength;
	dmFileInteger4 byteOrder;
} dm3FileHeader;

typedef struct dm4FileHeader {
	dmFileInteger4 version;
	dmFileInteger8 rootLength;
	dmFileInteger4 byteOrder;
} dm4FileHeader;

// Root Tag Directory
typedef struct dm3FileRootTagDirectory {
	dmFileInteger1 sortf;
	dmFileInteger1 closef;
	dmFileInteger4 numberOfTags;
} dm3FileRootTagDirectory;

typedef struct dm4FileRootTagDirectory {
	dmFileInteger1 sortf;
	dmFileInteger1 closef;
	dmFileInteger8 numberOfTags;
} dm4FileRootTagDirectory;

// Tag Directory
typedef struct dm3FileTagDirectrory {
	dmFileInteger1 tagID;
	dmFileInteger2 tagNameLength; // Bytes
	char*          tagName;
	dmFileInteger1 seperator[4];
	dmFileInteger4 sizeDim; 
	dmFileInteger4* dim; 
} dm3FileTagDirectrory;

typedef struct dm4FileTagDirectrory {
	dmFileInteger1 tagID;
	dmFileInteger2 tagNameLength; // Bytes
	char*          tagName;
} dm4FileTagDirectrory;

typedef struct dmFile {
	// Header
	dmFileInteger4 version;
	dm3FileHeader Header3;
	dm4FileHeader Header4;
	// Root Tag
	dm3FileRootTagDirectory RootTag3;
	dm4FileRootTagDirectory RootTag4;

	dmFileInteger8 Tail;
} dmFile;

/* struct end */

#ifdef __cplusplus
extern "C" {
#endif

/* prototype begin */

// in dfFileInfo.c
extern void dmFileInfo(FILE* fpt, dmFile dm, int mode);

// in dmFileRead.c
extern void dmFileRead(FILE* fpt, dmFile* dm, char* message, int mode);


/* prototype end */

#ifdef __cplusplus
};
#endif

#endif  /* DMFILE_H */ 
