/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% dmFileInfo ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : dmFileInfo 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%dmFileInfo ver%I%; Date:%D% %Z%";

#include "../inc/dmFile.h"

void
dmFileInfo(FILE* fpt, dmFile dm, int mode)
{
	switch(dm.version) {
		case 3: {
			fprintf(fpt, "version: %d\n", dm.Header3.version);
			fprintf(fpt, "RootLength: %d\n", dm.Header3.rootLength);
			fprintf(fpt, "ByteOrder: %d\n", dm.Header3.byteOrder);
			fprintf(fpt, "sortf: %d\n", dm.RootTag3.sortf);
			fprintf(fpt, "closef: %d\n", dm.RootTag3.closef);
			fprintf(fpt, "numberOfTags: %d\n", dm.RootTag3.numberOfTags);
			break;
		}
		case 4: {
			fprintf(fpt, "version: %d\n", dm.Header4.version);
			fprintf(fpt, "RootLength: %lld\n", dm.Header4.rootLength);
			fprintf(fpt, "ByteOrder: %d\n", dm.Header4.byteOrder);
			fprintf(fpt, "sortf: %d\n", dm.RootTag4.sortf);
			fprintf(fpt, "closef: %d\n", dm.RootTag4.closef);
			fprintf(fpt, "numberOfTags: %lld\n", dm.RootTag4.numberOfTags);
			break;
		}
		default: {
			fprintf(stderr, "%d: Not supported version\n");
			break;
		}

	}
}
