/*
# %M% %Y% %I%
# The latest update : %G% at %U%
#
#%Z% lmrcImageShapePCA ver %I%
#%Z% Created by 
#%Z%
#%Z% Usage : lmrcImageShapePCA 
#%Z% Attention
#%Z%
*/
static char __sccs_id[] = "%Z%lmrcImageShapePCA ver%I%; Date:%D% %Z%";

#include "./lmrcImageShapePCA.h"
int
lmrcImageShapePCA(mrcImage* in, lmrcImageShapePCAInfo* linfo, int mode)
{
        mrcImageParaTypeReal x, y, z;
        double data;
        int n, i;
        Array X;
        Array X1;

        n = in->HeaderN.x*in->HeaderN.y*in->HeaderN.z;
        X.dim  = 2;
        X.n[0] = 3;
        X.n[1] = n*linfo->nLevel;
        arrayInit(&X, "in lmrcImageShapePCA");

        n = 0;
        for(z=0; z<in->HeaderN.z; z++) {
        for(y=0; y<in->HeaderN.y; y++) {
        for(x=0; x<in->HeaderN.x; x++) {
                mrcPixelDataGet(in, x, y, z, &data, mrcPixelRePart, mrcPixelHowNearest);
                for(i=0; i<linfo->nLevel; i++) {
                        if(linfo->Level[i]<data) {
                                arrayDataSet2(X, 0, n, x);
                                arrayDataSet2(X, 1, n, y);
                                arrayDataSet2(X, 2, n, z);
                                n++;
                        }
                }
        }
        }
        }

        X1.dim  = 2;
        X1.n[0] = 3;
        X1.n[1] = n;
        arrayInit(&X1, "in lmrcImageShapePCA");
        DEBUGPRINT1("count: %d\n", n);

        for(i=0; i<n; i++) {
                data = arrayDataGet2(X, 0, i);
                arrayDataSet2(X1, 0, i, data);
                data = arrayDataGet2(X, 1, i);
                arrayDataSet2(X1, 1, i, data);
                data = arrayDataGet2(X, 2, i);
                arrayDataSet2(X1, 2, i, data);
        }
        arrayPCA(&linfo->u, &linfo->C, &linfo->Lambda, &X1, &linfo->Average, 0);
}

int
lmrcImageShapePCAResultsPrint(FILE* fpt, lmrcImageShapePCAInfo* linfo, int mode)
{
	double sum;

        fprintf(fpt, "# PCA Results");
        fprintf(fpt, "Convariace Matrix: ");
        arrayWriteToFile(fpt, &linfo->C, "lmrcImageShapePCAResultsPrint");
        fprintf(fpt, "UnitVector: one unit vector per line, from 1st ");
        arrayWriteToFile(fpt, &linfo->u, "lmrcImageShapePCAResultsPrint");
        fprintf(fpt, "Lambda: 1st 2nd 3rd");
        arrayWriteToFile(fpt, &linfo->Lambda, "lmrcImageShapePCAResultsPrint");
        fprintf(fpt, "Average: ");
        arrayWriteToFile(fpt, &linfo->Average, "lmrcImageShapePCAResultsPrint");
        fprintf(fpt, "Normalized Lambda: 1st 2nd 3rd\n");
	sum  = arrayDataGet1(linfo->Lambda, 0);
	sum += arrayDataGet1(linfo->Lambda, 1);
	sum += arrayDataGet1(linfo->Lambda, 2);
        fprintf(fpt, "%15.6f ", arrayDataGet1(linfo->Lambda, 0)/sum);
        fprintf(fpt, "%15.6f ", arrayDataGet1(linfo->Lambda, 1)/sum);
        fprintf(fpt, "%15.6f \n", arrayDataGet1(linfo->Lambda, 2)/sum);
}
