/*
# pgMemoSelectCORBAServer : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : pgMemoSelectCORBAServer
# Attention
#   $Loccker$
#  	$State$ 
#
*/
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>                  
#define GLOBAL_DECLARATION
#include "../inc/config.h"

#define DEBUG
#include "genUtil.h"
#include "CORBA.h"
#include "DataBaseCorba.h"
#include "DataBaseCorbaImpl.hh"
#include "DataBaseCorbaManager.hh"
#include "DataBaseCorbaBank.hh"
#include <fstream.h>
#include "Memory.h"
#include <coss/CosNaming.h>

/*
Example:
typedef struct lpgMemoSelectCORBAServerInfo {
	float a;
	int   b;
} lpgMemoSelectCORBAServerInfo;

typedef enum lpgMemoSelectCORBAServerMode {
	a=0,
	b=1
} lpgMemoSelectCORBAServerMode;
*/

int
main(int argc, char* argv[]) 
{
	pgMemoSelectCORBAServerInfo info;

	init0(&info);
    argCheck(&info, argc, argv);
    init1(&info);

	DEBUGPRINT("Program Start\n");
	 //Initialize ORB
        CORBA::ORB_var orb=CORBA::ORB_init(argc,argv,"mico-local-orb");

        CORBA::Object_var poaobj=orb->resolve_initial_references("RootPOA");
        PortableServer::POA_var poa=PortableServer::POA::_narrow(poaobj);
        PortableServer::POAManager_var mgr=poa->the_POAManager();


//        Bank_impl * micocash= new Bank_impl;
	DataBaseCorba_impl * memo= new DataBaseCorba_impl;

        PortableServer::ObjectId_var oid = poa->activate_object(memo);
        CORBA::Object_var ref=poa->id_to_reference(oid.in());


        CORBA::Object_var nsobj = orb->resolve_initial_references("NameService");
        CosNaming::NamingContext_var nc = CosNaming::NamingContext::_narrow(nsobj);

        if(CORBA::is_nil(nc)){
        cerr <<"oops, I cannot access the Naming Service!"<<endl;
        exit(1);
        }
	CosNaming::Name name;
        name.length(1);
        name[0].id = CORBA::string_dup("Memo");
        name[0].kind = CORBA::string_dup("");


        cout<< "Binding Bank in the Naming Service ...!"<< flush;
        nc->rebind(name,ref);
        cout<<"done."<<endl;

        printf("Server Running.\n");


        mgr->activate();
	char* host;
        char* port;
        char* dbname;
        host=strdup(info.Host);
        port=strdup(info.Port);
        dbname=strdup(info.DBName);
        memo->ConnectDatabase(host,port,dbname);

        orb->run();
        poa->destroy(TRUE,TRUE);
        delete memo;

        return 0;
	exit(EXIT_SUCCESS);
}

void
additionalUsage()
{
	fprintf(stderr, "----- Additional Usage -----\n");
}
