'use strict';

var _ = require('lodash');

var path   = require('path');
var mkdirp = require('mkdirp');
var glob   = require('glob');
var remove = require('remove');

exports.singleton = function() {

    var list = [];

    this.create = function (req, res) {
        var dirPath = __dirname + "/../../workspace/" + req.params.name;
        mkdirp(dirPath, function (err) {
            if (err) {
                console.error(err);
                res.send(["Error"]);
            } else {
                console.log("Directory creation successed");
                list.push(path.basename(dirPath));
                res.send(["Success"]);
            };
        });
    };

    this.read = function () {
        return list;
    };

    this.update = function (req, res) {
        var wsPath = __dirname + "/../../workspace/*";
        var fullPath = glob.sync(wsPath);
        list = fullPath.map(path.basename);
        res.send(["updated"]);
    };

    this.delete = function (req, res) {
        var dirPath = __dirname + "/../../workspace/" + req.params.name;
        remove(dirPath, function (err) {
            if (err) {
                console.error(err);
                res.send(["Error"]);
            } else {
                console.log("Directory removal successed");
                list.some(function (value, index) {
                    if (value == path.basename(dirPath)) {
                        list.splice(index, 1);
                    }
                });
                res.send(["Success"]);
            }
        });
    };
};
