#include <stdio.h>
#include <stdlib.h>
#include "../inc/Array.h"
#include "Memory.h"
#include "File.h"
#include "String.h"

void
arrayReadFromFile(FILE* fpt, Array* A, char* message)
{
	char s[STRING_MAX_LENGTH*16];
	arrayParaTypeInteger n, i, j;

		
	stringGetFromFile(s, "", fpt, stdout, 1);
	A->dim = stringGetNthIntegerData(s, 1, ARRAY_SEPARATOR);
	if(A->dim>ARRAY_MAX_DIMENSION || A->dim<1) {
		fprintf(stderr, "%s\n", message);
		fprintf(stderr, "Array Dimension(%d) is more than Max(%d) or less than %d in arrayInit\n",
			(int)A->dim, ARRAY_MAX_DIMENSION, ARRAY_MIN_DIMENSION);
		exit(EXIT_FAILURE);
	} 
	for(i=0; i<A->dim; i++) {
		A->n[i] = stringGetNthIntegerData(s, i+2, ARRAY_SEPARATOR); 
	}
	arrayInit(A, "in arrayReadFile");

	n = 1;
	for(i=1; i<A->dim; i++) { /* Calculation Line Number */
		n *= A->n[i];
	}
	for(i=0; i<n; i++) {
		fgets(s, STRING_MAX_LENGTH*16, fpt);
		for(j=0; j<A->n[0]; j++) {
			A->A[j + i*A->n[0]] =stringGetNthRealData(s, j+1, ARRAY_SEPARATOR);
		}
	}
}
