/*
# ctffuncforbayes.h : $Revision$  
# $Date$ 
# Created by $Author$
# Usage : ctffuncforbayes.h 
# Attention
#   $Loccker$
#  	$State$ 
#
*/
/* $Log$ */

#ifndef CTFFUNCFORBAYES_H 
#define CTFFUNCFORBAYES_H


/* constant begin */


/* constant end */

/* struct begin */

typedef struct ctfforbayes{
  int n;
  float* R;
  float rmax;
  float rmin;
  float* I;
  float** Ii;
} ctfforbayes;


typedef struct intensityforbayes{
  float** normI;
  float** logI;
  float** normII;
  float** logII;
  
} intensityforbayes;


/* struct end */

#ifdef __cplusplus
extern "C" {
#endif

/* prototype begin */


/* prototype end */

/* prototype begin */

extern void ctfforbayesInit(FILE* fpt, ctfforbayes* ctf, int mode);
extern void intensityforbayesInit(intensityforbayes* intensity, int filenum, int Inum);
extern void intensitySet(ctfforbayes* ctf, intensityforbayes intensity, int count, int mode);
extern void spatialfrequencyRead(FILE* fpt, ctfforbayes* ctf, float rmax, float rmin, int mode);
extern void intensityRead(char* filename, intensityforbayes* intensity, int count, int mode);

extern void ctfFunctionforbayes(ctfforbayes* ctf, intensityforbayes* intensity, eosBayesDistribution* d, ctfInfo* info, int numLikelihood, int count, int mode);
extern float MTFFunctionforbayes(float R, float m, int mode);


extern void defocuslikelihood(ctfforbayes ctf, eosBayes* d, int count, int mode);
extern void defocuslikelihoodcaluculationLorentz(ctfforbayes ctf, eosBayesDistribution* d, int numLikelihood, int count, int mode);

extern void ctfforbayescheckRvsValue(char* filename, float R,float value, int count);

/* prototype end */

#ifdef __cplusplus
};
#endif

#endif  /* CTFFUNCFORBAYES_H */ 
