#include "DataBase.hh"
#include <stdlib.h>
#include <string.h>
#include <pgsql/libpq-fe.h>

DataBase::DataBase()
{

}


void DataBase::ConnectToDataBase()
{

  con = PQsetdb(host, port, NULL, NULL, dbName);
  printf("DataBaseName = %s\n", PQdb(con));
  if (PQstatus(con) == CONNECTION_BAD) {
    fprintf(stderr, "Connection to database '%s' on %s %s failed.\n", dbName, host,port);
    fprintf(stderr, "%s", PQerrorMessage(con));
    exit(1);
  }else{
    printf("Connect to DataBase!!\n");
  }

}


void 
DataBase::Exec(char* sql)
{
  if(sql==NULL)
    exit(1);
  if(con==NULL)
    exit(1);
  res = PQexec(con, sql);
  
}

void DataBase::ResClear()
{
  PQclear(res);
}

void DataBase::DisplayAll(PGresult *res)
{
  int i;
  int j;
  for(i = 0 ; i < PQntuples(res); i++)
    {
      for(j = 0; j < PQnfields(res) ; j++)
	{
	  printf("%s\t",PQgetvalue(res, i, j));
	}
      printf("\n");
    }
}



void DataBase::SetDataBaseInfo(char* hostN, char* portN, char* dbN)
{

  host = strdup(hostN);
  port = strdup(portN);
  dbName = strdup(dbN);

  ConnectToDataBase();
}

void DataBase::DropTable(char* TableName)
{
  char dropMemo[100];
  sprintf(dropMemo, "DROP TABLE %s", TableName);
  res = PQexec(con, dropMemo);
  PQclear(res);
}

void DataBase::DeleteTable(char* TableName)
{
  char deleteMemo[100];
  sprintf(deleteMemo, "DELETE FROM %s", TableName);
  res = PQexec(con, deleteMemo);
  PQclear(res);
}

void DataBase::CloseDataBase()
{
  PQclear(res);
  PQfinish(con);
}

