/*
 * Decompiled with CFR 0.152.
 */
package xmlrpcsample1;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;

public class SampleFrame
extends JFrame
implements ActionListener {
    private JTextField UrlField;
    private JTextField SearchField;
    private JButton SearchButton;
    private JScrollPane jScrollPane1;
    private JTree ResultTree;
    private DefaultMutableTreeNode rootNode;

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                SampleFrame inst = new SampleFrame();
                inst.setLocationRelativeTo(null);
                inst.setVisible(true);
            }
        });
    }

    public SampleFrame() {
        this.initGUI();
    }

    private void initGUI() {
        try {
            BorderLayout thisLayout = new BorderLayout();
            this.getContentPane().setLayout(thisLayout);
            this.setDefaultCloseOperation(2);
            this.setFont(new Font("Arial", 1, 12));
            this.UrlField = new JTextField();
            this.getContentPane().add((Component)this.UrlField, "North");
            this.UrlField.setText("http://192.168.1.3:80/epgrec/xmlrpc.php");
            this.SearchButton = new JButton();
            this.getContentPane().add((Component)this.SearchButton, "East");
            this.SearchButton.setText("\u691c\u7d22");
            this.SearchButton.addActionListener(this);
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.getVerticalScrollBar().setPreferredSize(new Dimension(0, 0));
            this.getContentPane().add((Component)this.jScrollPane1, "South");
            this.rootNode = new DefaultMutableTreeNode("\u691c\u7d22\u7d50\u679c");
            this.ResultTree = new JTree(this.rootNode);
            this.jScrollPane1.setViewportView(this.ResultTree);
            this.ResultTree.setPreferredSize(new Dimension(450, 232));
            this.SearchField = new JTextField();
            this.getContentPane().add((Component)this.SearchField, "Center");
            this.SearchField.setText("\u691c\u7d22\u6587\u5b57\u5217\u3092\u5165\u529b\u3057\u3066\u304f\u3060\u3055\u3044");
            this.pack();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void actionPerformed(ActionEvent evt) {
        XmlRpcClient client = new XmlRpcClient();
        XmlRpcClientConfigImpl conf = new XmlRpcClientConfigImpl();
        try {
            conf.setServerURL(new URL(this.UrlField.getText()));
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        client.setConfig((XmlRpcClientConfig)conf);
        ArrayList<String> params = new ArrayList<String>();
        params.add(this.SearchField.getText());
        try {
            Object[] ret = (Object[])client.execute("epgrec.searchProgram", params);
            this.rootNode.removeAllChildren();
            this.rootNode = new DefaultMutableTreeNode("\u691c\u7d22\u7d50\u679c");
            int i = 0;
            while (i < ret.length) {
                HashMap data = (HashMap)ret[i];
                DefaultMutableTreeNode node = new DefaultMutableTreeNode(data.get("title"));
                this.rootNode.add(node);
                Date starttime = (Date)data.get("starttime");
                SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateTimeInstance();
                sdf.applyPattern("yyyy/MM/dd 'at' HH:mm:ss");
                DefaultMutableTreeNode stnode = new DefaultMutableTreeNode("\u958b\u59cb\u65e5\u6642 " + sdf.format(starttime));
                node.add(stnode);
                DefaultMutableTreeNode chnode = new DefaultMutableTreeNode(data.get("channel_name"));
                node.add(chnode);
                DefaultMutableTreeNode descnode = new DefaultMutableTreeNode(data.get("description"));
                node.add(descnode);
                DefaultMutableTreeNode prgnode = new DefaultMutableTreeNode(data.get("program_id"));
                node.add(prgnode);
                ++i;
            }
            this.ResultTree = new JTree(this.rootNode);
            this.jScrollPane1.setViewportView(this.ResultTree);
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
    }
}

