package xmlrpcsample1;
import info.clearthought.layout.TableLayout;
import java.awt.BorderLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;

import javax.swing.WindowConstants;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;

import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;


/**
* This code was edited or generated using CloudGarden's Jigloo
* SWT/Swing GUI Builder, which is free for non-commercial
* use. If Jigloo is being used commercially (ie, by a corporation,
* company or business for any purpose whatever) then you
* should purchase a license for each developer using Jigloo.
* Please visit www.cloudgarden.com for details.
* Use of Jigloo implies acceptance of these licensing terms.
* A COMMERCIAL LICENSE HAS NOT BEEN PURCHASED FOR
* THIS MACHINE, SO JIGLOO OR THIS CODE CANNOT BE USED
* LEGALLY FOR ANY CORPORATE OR COMMERCIAL PURPOSE.
*/
public class SampleFrame extends javax.swing.JFrame implements ActionListener {
	private JTextField UrlField;
	private JTextField SearchField;
	private JButton SearchButton;
	private JScrollPane jScrollPane1;
	private JTree ResultTree;
	private DefaultMutableTreeNode rootNode;

	/**
	* Auto-generated main method to display this JFrame
	*/
	public static void main(String[] args) {
		SwingUtilities.invokeLater(new Runnable() {
			public void run() {
				SampleFrame inst = new SampleFrame();
				inst.setLocationRelativeTo(null);
				inst.setVisible(true);
			}
		});
	}

	public SampleFrame() {
		super();
		initGUI();
	}

	private void initGUI() {
		try {
			BorderLayout thisLayout = new BorderLayout();
			getContentPane().setLayout(thisLayout);
			setDefaultCloseOperation(WindowConstants.DISPOSE_ON_CLOSE);
			this.setFont(new java.awt.Font("Arial",1,12));
			{
				UrlField = new JTextField();
				getContentPane().add(UrlField, BorderLayout.NORTH);
				UrlField.setText("http://192.168.1.3:80/epgrec/xmlrpc.php");
			}
			{
				SearchButton = new JButton();
				getContentPane().add(SearchButton, BorderLayout.EAST);
				SearchButton.setText("\u691c\u7d22");
				SearchButton.addActionListener(this);
			}
			{
				jScrollPane1 = new JScrollPane();
				jScrollPane1.getVerticalScrollBar().setPreferredSize(new java.awt.Dimension(0, 0));
				getContentPane().add(jScrollPane1, BorderLayout.SOUTH);
				{
					rootNode = new DefaultMutableTreeNode("検索結果");
					ResultTree = new JTree(rootNode);
					jScrollPane1.setViewportView(ResultTree);
					ResultTree.setPreferredSize(new java.awt.Dimension(450, 232));
				}
			}
			{
				SearchField = new JTextField();
				getContentPane().add(SearchField, BorderLayout.CENTER);
				SearchField.setText("検索文字列を入力してください");
			}
			pack();
		} catch (Exception e) {
			e.printStackTrace();
		}
	}

	public void actionPerformed(ActionEvent evt) {
		XmlRpcClient client = new XmlRpcClient();

		XmlRpcClientConfigImpl conf = new XmlRpcClientConfigImpl();
		try {
			conf.setServerURL(new URL(UrlField.getText()));
		} catch (MalformedURLException e) {
			e.printStackTrace();
		}
		client.setConfig(conf);

		ArrayList params = new ArrayList();
		params.add(SearchField.getText());
		try {
			Object[] ret = (Object [])client.execute("epgrec.searchProgram", params);

			rootNode.removeAllChildren();
			rootNode = new DefaultMutableTreeNode("検索結果");

			for(int i=0; i< ret.length; i++ ) {
				HashMap data =(HashMap)ret[i];

				DefaultMutableTreeNode  node = new DefaultMutableTreeNode(data.get("title"));
				rootNode.add(node);

				// 日時
				Date starttime = (Date)data.get("starttime");
				SimpleDateFormat sdf = (SimpleDateFormat)DateFormat.getDateTimeInstance();
				sdf.applyPattern("yyyy/MM/dd 'at' HH:mm:ss");
				DefaultMutableTreeNode stnode = new DefaultMutableTreeNode("開始日時 "+ sdf.format(starttime));
				node.add(stnode);

				// チャンネル名
				DefaultMutableTreeNode chnode = new DefaultMutableTreeNode(data.get("channel_name"));
				node.add(chnode);

				// 概要
				DefaultMutableTreeNode descnode = new DefaultMutableTreeNode(data.get("description"));
				node.add(descnode);

				// program_id
				DefaultMutableTreeNode prgnode = new DefaultMutableTreeNode(data.get("program_id"));
				node.add(prgnode);
			}
			ResultTree = new JTree(rootNode);
			jScrollPane1.setViewportView(ResultTree);

		} catch (XmlRpcException e) {
			e.printStackTrace();
		}
	}
}
