<?php
// vim: foldmethod=marker
/**
 *	Ethna_ActionClass.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_ActionClass.php,v 1.1 2004/11/29 16:36:02 fujimoto Exp $
 */

// {{{ Ethna_ActionClass
/**
 *	action¹ԥ饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_ActionClass
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	object	Ethna_Backend		backend֥
	 */
	var $backend;

	/**
	 *	@var	object	Ethna_Config		ꥪ֥	
	 */
	var $config;

	/**
	 *	@var	object	Ethna_I18N			i18n֥
	 */
	var $i18n;

	/**
	 *	@var	object	Ethna_ActionError	action error֥
	 */
	var $action_error;

	/**
	 *	@var	object	Ethna_ActionError	action error֥(ά)
	 */
	var $ae;

	/**
	 *	@var	object	Ethna_ActionForm	action form֥
	 */
	var $action_form;

	/**
	 *	@var	object	Ethna_ActionForm	action form֥(ά)
	 */
	var $af;

	/**
	 *	@var	object	Ethna_Session		å󥪥֥
	 */
	var $session;

	/**#@-*/

	/**
	 *	Ethna_ActionClassΥ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	$backend	backend֥
	 */
	function Ethna_ActionClass(&$backend)
	{
		$c =& $backend->getController();
		$this->backend =& $backend;
		$this->config =& $this->backend->getConfig();
		$this->i18n =& $this->backend->getI18N();

		$this->action_error =& $this->backend->getActionError();
		$this->ae =& $this->action_error;

		$this->action_form =& $this->backend->getActionForm();
		$this->af =& $this->action_form;

		$this->session =& $this->backend->getSession();

		// Ethna_AppManager֥Ȥ
		$manager_list = $c->getManagerList();
		foreach ($manager_list as $k => $v) {
			$this->$k = $backend->getManager($v);
		}
	}

	/**
	 *	ӥͥå¹ν(ååեͥå)Ԥ
	 *
	 *	@access	public
	 *	@return	string	Forward̾(nullʤｪλ)
	 */
	function prepare()
	{
		return null;
	}

	/**
	 *	action
	 *
	 *	@access	public
	 *	@return	string	Forward̾
	 */
	function perform()
	{
		return null;
	}

	/**
	 *	ɽ
	 *
	 *	@access	public
	 */
	function preforward()
	{
	}
}
// }}}
?>
