<?php
// vim: foldmethod=marker
/**
 *	Ethna_Error.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@license	http://www.opensource.org/licenses/bsd-license.php The BSD License
 *	@package	Ethna
 *	@version	$Id: Ethna_Error.php,v 1.4 2004/12/08 12:32:38 fujimoto Exp $
 */

// {{{ Ethna_Error
/**
 *	顼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Ethna
 */
class Ethna_Error extends PEAR_Error
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	object	Ethna_I18N	i18n֥
	 */
	var $i18n;

	/**
	 *	@var	object	Ethna_Logger	logger֥
	 */
	var $logger;

	/**#@-*/

	/**
	 *	Ethna_Error饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	int		$level				顼٥
	 *	@param	string	$message			顼å
	 *	@param	int		$code				顼
	 *	@param	array	$userinfo			顼ɲþ(顼ɰʹߤƤΰ)
	 */
	function Ethna_Error($message = null, $code = null, $mode = null, $options = null)
	{
		$controller =& Ethna_Controller::getInstance();
		$this->i18n =& $controller->getI18N();

		// $optionsʹߤΰ->$userinfo
		if (func_num_args() > 4) {
			$userinfo = array_slice(func_get_args(), 4);
			if (count($userinfo) == 1) {
				if (is_array($userinfo[0])) {
					$userinfo = $userinfo[0];
				} else if (is_null($userinfo[0])) {
					$userinfo = array();
				}
			}
		} else {
			$userinfo = array();
		}

		// å
		if (is_null($message)) {
			// $codeå
			$message = $controller->getErrorMessage($code);
			if (is_null($message)) {
				$message = 'unkown error';
			}
		}

		parent::PEAR_Error($message, $code, $mode, $options, $userinfo);

		// Ethnaե졼Υ顼ϥɥ(PEAR_ErrorΥХåȤϰۤʤ)
		Ethna::handleError($this);
	}

	/**
	 *	levelؤΥ(R)
	 *
	 *	@access	public
	 *	@return	int		顼٥
	 */
	function getLevel()
	{
		return $this->level;
	}

	/**
	 *	messageؤΥ(R)
	 *
	 *	PEAR_Error::getMessage()򥪡С饤ɤưʲνԤ
	 *	- 顼åi18n
	 *	- $userinfoȤϤ줿ǡˤvsprintf()
	 *
	 *	@access	public
	 *	@return	string	顼å
	 */
	function getMessage()
	{
		$tmp_message = $this->i18n->get($this->message);
		$tmp_userinfo = to_array($this->userinfo);
		$tmp_message_arg_list = array();
		for ($i = 0; $i < count($tmp_userinfo); $i++) {
			$tmp_message_arg_list[] = $this->i18n->get($tmp_userinfo[$i]);
		}
		return vsprintf($tmp_message, $tmp_message_arg_list);
	}

	/**
	 *	顼ɲþؤΥ(R)
	 *
	 *	PEAR_Error::getUserInfo()򥪡С饤ɤơθġ
	 *	ȥؤΥ򥵥ݡ
	 *
	 *	@access	public
	 *	@param	int		$n		顼ɲþΥǥå(ά)
	 *	@return	mixed	message
	 */
	function getUserInfo($n = null)
	{
		if (is_null($n)) {
			return $this->userinfo;
		}

		if (isset($this->userinfo[$n])) {
			return $this->userinfo[$n];
		} else {
			return null;
		}
	}

	/**
	 *	顼ɲþؤΥ(W)
	 *
	 *	PEAR_Error::addUserInfo()򥪡С饤
	 *
	 *	@access	public
	 *	@param	string	$info	ɲä륨顼
	 */
	function addUserInfo($info)
	{
		$this->userinfo[] = $info;
	}
}
// }}}
?>
