/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnant.commands;

import java.io.File;
import org.tigris.subversion.svnant.SvnAntException;
import org.tigris.subversion.svnant.SvnAntValidationException;
import org.tigris.subversion.svnant.commands.SvnCommand;
import org.tigris.subversion.svnclientadapter.SVNClientException;
import org.tigris.subversion.svnclientadapter.SVNUrl;

public class Mkdir
extends SvnCommand {
    private SVNUrl url = null;
    private File path = null;
    private String message = null;

    public void execute() throws SvnAntException {
        if (this.url != null) {
            try {
                this.svnClient.mkdir(this.url, this.message);
            }
            catch (SVNClientException sVNClientException) {
                throw new SvnAntException("Can't make dir " + this.url, sVNClientException);
            }
        }
        try {
            this.svnClient.mkdir(this.path);
        }
        catch (SVNClientException sVNClientException) {
            throw new SvnAntException("Can't make dir " + this.path, sVNClientException);
        }
    }

    protected void validateAttributes() throws SvnAntValidationException {
        if (this.url == null && this.path == null) {
            throw new SvnAntValidationException("url or path attributes must be set");
        }
        if (this.url != null && this.path != null) {
            throw new SvnAntValidationException("Either url or path attributes must be set");
        }
        if (this.url != null && this.message == null) {
            throw new SvnAntValidationException("Message attribute must be set when url is used");
        }
    }

    public void setUrl(SVNUrl sVNUrl) {
        this.url = sVNUrl;
    }

    public void setPath(File file) {
        this.path = file;
    }

    public void setMessage(String string) {
        this.message = string;
    }
}

