/*************************************************************************
 *
 * Copyright 2009 by bBreak Systems.
 *
 * ExCella Core - Excelt@CJava痘p邽߂̋ʊ
 *
 * $Id: DebugErrorHandler.java 65 2009-05-21 07:44:08Z akira-yokoi $
 * $Revision: 65 $
 *
 * This file is part of ExCella Core.
 *
 * ExCella Core is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * ExCella Core is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the COPYING.LESSER file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with ExCella Core.  If not, see
 * <http://www.gnu.org/licenses/lgpl-3.0-standalone.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/
package org.bbreak.excella.core.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.bbreak.excella.core.BookController;
import org.bbreak.excella.core.exception.ParseException;
import org.bbreak.excella.core.util.PoiUtil;

/**
 * fobOpG[nhONX
 * 
 * ParseExceptionۂɃG[ƂȂZ}[NĎsfBNgzɃG[t@Co͂B
 *  
 * @since 1.0
 *
 */
public class DebugErrorHandler implements ParseErrorHandler {
	
    /** O */
    private static Log log = LogFactory.getLog( DebugErrorHandler.class);

    /** G[t@C̏ݐ */
    private String errorFilePath = null;

    public void notifyException( Workbook workbook, Sheet sheet, ParseException exception) {
        boolean isXssf = false;

        if ( exception != null) {
            Cell errorCell = exception.getCell();
            if ( errorCell != null) {
                // TODO:G[
                workbook.setActiveSheet( workbook.getSheetIndex( errorCell.getSheet()));
                errorCell.setAsActiveCell();

                // Comment comment = null;
                if ( workbook instanceof XSSFWorkbook) {
                    isXssf = true;
                    XSSFWorkbook xssfWorkbook = ( XSSFWorkbook) workbook;

                    Font errorFont = workbook.createFont();
                    errorFont.setColor( HSSFColor.RED.index);
                    CellStyle errorCellStyle = xssfWorkbook.createCellStyle();
                    errorCellStyle.setFont( errorFont);
                    errorCell.setCellStyle( errorCellStyle);

                    // TODO:RgǁA܂ȂBBB
//                    XSSFComment xssfComment = ((XSSFSheet)sheet).createComment();
//                    xssfComment.setRow( errorCell.getRowIndex());
//                    xssfComment.setColumn( (short)errorCell.getColumnIndex());
//                    XSSFRichTextString string = new XSSFRichTextString( ex.getMessage());
//                    xssfComment.setString( ex.getMessage());
                } else {
                    HSSFWorkbook hssfWorkbook = ( HSSFWorkbook) workbook;

                    Font errorFont = workbook.createFont();
                    errorFont.setColor( HSSFColor.RED.index);
                    CellStyle errorCellStyle = hssfWorkbook.createCellStyle();
                    errorCellStyle.setFont( errorFont);
                    errorCell.setCellStyle( errorCellStyle);
                }
            }
        }

        String resultFileName = errorFilePath;
        if ( resultFileName == null) {
            resultFileName = "./" + System.currentTimeMillis();
            if ( isXssf) {
                resultFileName += BookController.XSSF_SUFFIX;
            } else {
                resultFileName += BookController.HSSF_SUFFIX;
            }
        }

        try {
            PoiUtil.writeBook( workbook, resultFileName);
        } catch ( Exception e) {
            log.warn( "G[t@C̐Ɏs܂", e);
        }
    }

    /**
     * G[t@C̏ݐpX̎擾
     * 
     * @return G[t@C̏ݐpX
     */
    public String getErrorFilePath() {
        return errorFilePath;
    }

    /**
     * G[t@C̏ݐpX̐ݒ
     * 
     * @param errorFilePath G[t@C̏ݐpX
     */
    public void setErrorFilePath( String errorFilePath) {
        this.errorFilePath = errorFilePath;
    }
}
